/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.ajax;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AjaxFilter
implements Filter {
    ServletContext context;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
    }

    public ServletContext getContext() {
        return this.context;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String[] stringArray = servletRequest.getParameterValues("ajax");
        String[] stringArray2 = servletRequest.getParameterValues("message");
        if (stringArray != null && stringArray.length > 0) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println("<ajax-response>");
            AjaxResponse ajaxResponse = new AjaxResponse(httpServletRequest, printWriter);
            for (int i = 0; i < stringArray.length; ++i) {
                this.handle(stringArray[i], stringArray2[i], httpServletRequest, ajaxResponse);
            }
            printWriter.println("</ajax-response>");
            byte[] byArray = stringWriter.toString().getBytes("UTF-8");
            httpServletResponse.setHeader("Pragma", "no-cache");
            httpServletResponse.addHeader("Cache-Control", "must-revalidate,no-cache,no-store");
            httpServletResponse.setDateHeader("Expires", 0L);
            httpServletResponse.setContentType("text/xml; charset=UTF-8");
            httpServletResponse.setContentLength(byArray.length);
            httpServletResponse.getOutputStream().write(byArray);
            httpServletResponse.flushBuffer();
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void handle(String string, String string2, HttpServletRequest httpServletRequest, AjaxResponse ajaxResponse) {
        ajaxResponse.elementResponse(null, "<span class=\"error\">No implementation for " + string + " " + httpServletRequest.getParameter("member") + "</span>");
    }

    public void destroy() {
        this.context = null;
    }

    public static String encodeText(String string) {
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            String string2 = null;
            switch (c) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                }
            }
            if (string2 != null) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.length() * 2);
                    stringBuffer.append(string.subSequence(0, i));
                }
                stringBuffer.append(string2);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return string;
    }

    public static class AjaxResponse {
        private HttpServletRequest request;
        private PrintWriter out;

        private AjaxResponse(HttpServletRequest httpServletRequest, PrintWriter printWriter) {
            this.out = printWriter;
            this.request = httpServletRequest;
        }

        public void elementResponse(String string, String string2) {
            if (string == null) {
                string = this.request.getParameter("id");
            }
            if (string == null) {
                string = "unknown";
            }
            this.out.println("<response type=\"element\" id=\"" + string + "\">" + string2 + "</response>");
        }

        public void objectResponse(String string, String string2) {
            if (string == null) {
                string = this.request.getParameter("id");
            }
            if (string == null) {
                string = "unknown";
            }
            this.out.println("<response type=\"object\" id=\"" + string + "\">" + string2 + "</response>");
        }
    }
}

