/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.ajax;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mortbay.log.Log;
import org.mortbay.util.IO;
import org.mortbay.util.Loader;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.TypeUtil;

public class JSON {
    private static JSON __default = new JSON();
    private Map _convertors = Collections.synchronizedMap(new HashMap());
    private int _stringBufferSize = 256;

    public int getStringBufferSize() {
        return this._stringBufferSize;
    }

    public void setStringBufferSize(int n) {
        this._stringBufferSize = n;
    }

    public static void registerConvertor(Class clazz, Convertor convertor) {
        __default.addConvertor(clazz, convertor);
    }

    public static JSON getDefault() {
        return __default;
    }

    public static void setDefault(JSON jSON) {
        __default = jSON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Object object) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(__default.getStringBufferSize());
        synchronized (stringBuffer2) {
            __default.append(stringBuffer, object);
            return stringBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Map map) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(__default.getStringBufferSize());
        synchronized (stringBuffer2) {
            __default.appendMap(stringBuffer, map);
            return stringBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Object[] objectArray) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(__default.getStringBufferSize());
        synchronized (stringBuffer2) {
            __default.appendArray(stringBuffer, objectArray);
            return stringBuffer.toString();
        }
    }

    public static Object parse(String string) {
        return __default.parse(new StringSource(string), false);
    }

    public static Object parse(String string, boolean bl) {
        return __default.parse(new StringSource(string), bl);
    }

    public static Object parse(Reader reader) throws IOException {
        return __default.parse(new ReaderSource(reader), false);
    }

    public static Object parse(Reader reader, boolean bl) throws IOException {
        return __default.parse(new ReaderSource(reader), bl);
    }

    public static Object parse(InputStream inputStream) throws IOException {
        return __default.parse(new StringSource(IO.toString(inputStream)), false);
    }

    public static Object parse(InputStream inputStream, boolean bl) throws IOException {
        return __default.parse(new StringSource(IO.toString(inputStream)), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toJSON(Object object) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(this.getStringBufferSize());
        synchronized (stringBuffer2) {
            this.append(stringBuffer, object);
            return stringBuffer.toString();
        }
    }

    public Object fromJSON(String string) {
        StringSource stringSource = new StringSource(string);
        return this.parse(stringSource);
    }

    public void append(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            stringBuffer.append("null");
        } else if (object instanceof Convertible) {
            this.appendJSON(stringBuffer, (Convertible)object);
        } else if (object instanceof Generator) {
            this.appendJSON(stringBuffer, (Generator)object);
        } else if (object instanceof Map) {
            this.appendMap(stringBuffer, (Map)object);
        } else if (object instanceof Collection) {
            this.appendArray(stringBuffer, (Collection)object);
        } else if (object.getClass().isArray()) {
            this.appendArray(stringBuffer, object);
        } else if (object instanceof Number) {
            this.appendNumber(stringBuffer, (Number)object);
        } else if (object instanceof Boolean) {
            this.appendBoolean(stringBuffer, (Boolean)object);
        } else if (object instanceof String) {
            this.appendString(stringBuffer, (String)object);
        } else {
            Convertor convertor = this.getConvertor(object.getClass());
            if (convertor != null) {
                this.appendJSON(stringBuffer, convertor, object);
            } else {
                this.appendString(stringBuffer, object.toString());
            }
        }
    }

    public void appendNull(StringBuffer stringBuffer) {
        stringBuffer.append("null");
    }

    public void appendJSON(StringBuffer stringBuffer, final Convertor convertor, final Object object) {
        this.appendJSON(stringBuffer, new Convertible(){

            @Override
            public void fromJSON(Map map) {
            }

            @Override
            public void toJSON(Output output) {
                convertor.toJSON(object, output);
            }
        });
    }

    public void appendJSON(final StringBuffer stringBuffer, Convertible convertible) {
        final char[] cArray = new char[]{'{'};
        convertible.toJSON(new Output(){

            @Override
            public void add(Object object) {
                if (cArray[0] == '\u0000') {
                    throw new IllegalStateException();
                }
                JSON.this.append(stringBuffer, object);
                cArray[0] = '\u0000';
            }

            @Override
            public void addClass(Class clazz) {
                if (cArray[0] == '\u0000') {
                    throw new IllegalStateException();
                }
                stringBuffer.append(cArray);
                stringBuffer.append("\"class\":");
                JSON.this.append(stringBuffer, clazz.getName());
                cArray[0] = 44;
            }

            @Override
            public void add(String string, Object object) {
                if (cArray[0] == '\u0000') {
                    throw new IllegalStateException();
                }
                stringBuffer.append(cArray);
                QuotedStringTokenizer.quote(stringBuffer, string);
                stringBuffer.append(':');
                JSON.this.append(stringBuffer, object);
                cArray[0] = 44;
            }

            @Override
            public void add(String string, double d) {
                if (cArray[0] == '\u0000') {
                    throw new IllegalStateException();
                }
                stringBuffer.append(cArray);
                QuotedStringTokenizer.quote(stringBuffer, string);
                stringBuffer.append(':');
                JSON.this.appendNumber(stringBuffer, new Double(d));
                cArray[0] = 44;
            }

            @Override
            public void add(String string, long l) {
                if (cArray[0] == '\u0000') {
                    throw new IllegalStateException();
                }
                stringBuffer.append(cArray);
                QuotedStringTokenizer.quote(stringBuffer, string);
                stringBuffer.append(':');
                JSON.this.appendNumber(stringBuffer, TypeUtil.newLong(l));
                cArray[0] = 44;
            }

            @Override
            public void add(String string, boolean bl) {
                if (cArray[0] == '\u0000') {
                    throw new IllegalStateException();
                }
                stringBuffer.append(cArray);
                QuotedStringTokenizer.quote(stringBuffer, string);
                stringBuffer.append(':');
                JSON.this.appendBoolean(stringBuffer, bl ? Boolean.TRUE : Boolean.FALSE);
                cArray[0] = 44;
            }
        });
        if (cArray[0] == '{') {
            stringBuffer.append("{}");
        } else if (cArray[0] != '\u0000') {
            stringBuffer.append("}");
        }
    }

    public void appendJSON(StringBuffer stringBuffer, Generator generator) {
        generator.addJSON(stringBuffer);
    }

    public void appendMap(StringBuffer stringBuffer, Map map) {
        if (map == null) {
            this.appendNull(stringBuffer);
            return;
        }
        stringBuffer.append('{');
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            QuotedStringTokenizer.quote(stringBuffer, entry.getKey().toString());
            stringBuffer.append(':');
            this.append(stringBuffer, entry.getValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append('}');
    }

    public void appendArray(StringBuffer stringBuffer, Collection collection) {
        if (collection == null) {
            this.appendNull(stringBuffer);
            return;
        }
        stringBuffer.append('[');
        Iterator iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(',');
            }
            bl = false;
            this.append(stringBuffer, iterator.next());
        }
        stringBuffer.append(']');
    }

    public void appendArray(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            this.appendNull(stringBuffer);
            return;
        }
        stringBuffer.append('[');
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            this.append(stringBuffer, Array.get(object, i));
        }
        stringBuffer.append(']');
    }

    public void appendBoolean(StringBuffer stringBuffer, Boolean bl) {
        if (bl == null) {
            this.appendNull(stringBuffer);
            return;
        }
        stringBuffer.append(bl != false ? "true" : "false");
    }

    public void appendNumber(StringBuffer stringBuffer, Number number) {
        if (number == null) {
            this.appendNull(stringBuffer);
            return;
        }
        stringBuffer.append(number);
    }

    public void appendString(StringBuffer stringBuffer, String string) {
        if (string == null) {
            this.appendNull(stringBuffer);
            return;
        }
        QuotedStringTokenizer.quote(stringBuffer, string);
    }

    protected String toString(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    protected Map newMap() {
        return new HashMap();
    }

    protected Object[] newArray(int n) {
        return new Object[n];
    }

    protected JSON contextForArray() {
        return this;
    }

    protected JSON contextFor(String string) {
        return this;
    }

    protected Object convertTo(Class clazz, Map map) {
        if (clazz != null && Convertible.class.isAssignableFrom(clazz)) {
            try {
                Convertible convertible = (Convertible)clazz.newInstance();
                convertible.fromJSON(map);
                return convertible;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        Convertor convertor = this.getConvertor(clazz);
        if (convertor != null) {
            return convertor.fromJSON(map);
        }
        return map;
    }

    public void addConvertor(Class clazz, Convertor convertor) {
        this._convertors.put(clazz.getName(), convertor);
    }

    protected Convertor getConvertor(Class clazz) {
        Class clazz2 = clazz;
        Convertor convertor = (Convertor)this._convertors.get(clazz2.getName());
        if (convertor == null && this != __default) {
            convertor = __default.getConvertor(clazz2);
        }
        while (convertor == null && clazz2 != null && clazz2 != Object.class) {
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = 0;
            while (convertor == null && classArray != null && n < classArray.length) {
                convertor = (Convertor)this._convertors.get(classArray[n++].getName());
            }
            if (convertor != null) continue;
            clazz2 = clazz2.getSuperclass();
            convertor = (Convertor)this._convertors.get(clazz2.getName());
        }
        return convertor;
    }

    public void addConvertorFor(String string, Convertor convertor) {
        this._convertors.put(string, convertor);
    }

    public Convertor getConvertorFor(String string) {
        String string2 = string;
        Convertor convertor = (Convertor)this._convertors.get(string2);
        if (convertor == null && this != __default) {
            convertor = __default.getConvertorFor(string2);
        }
        return convertor;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object parse(Source source, boolean bl) {
        int n = 0;
        if (!bl) {
            return this.parse(source);
        }
        int n2 = 1;
        Object object = null;
        while (true) {
            block27: {
                char c;
                block26: {
                    if (!source.hasNext()) {
                        return object;
                    }
                    c = source.peek();
                    if (n != true) break block26;
                    switch (c) {
                        case '/': {
                            n = -1;
                            break;
                        }
                        case '*': {
                            n = 2;
                            if (n2 == 1) {
                                n = 0;
                                n2 = 2;
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block27;
                }
                if (n > 1) {
                    switch (c) {
                        case '*': {
                            n = 3;
                            break;
                        }
                        case '/': {
                            if (n == 3) {
                                n = 0;
                                if (n2 != 2) break;
                                return object;
                            }
                            n = 2;
                            break;
                        }
                        default: {
                            n = 2;
                            break;
                        }
                    }
                } else if (n < 0) {
                    switch (c) {
                        case '\n': 
                        case '\r': {
                            n = 0;
                            break;
                        }
                    }
                } else if (!Character.isWhitespace(c)) {
                    if (c == '/') {
                        n = 1;
                    } else if (c == '*') {
                        n = 3;
                    } else if (object == null) {
                        object = this.parse(source);
                        continue;
                    }
                }
            }
            source.next();
        }
    }

    public Object parse(Source source) {
        int n = 0;
        while (source.hasNext()) {
            char c = source.peek();
            if (n == 1) {
                switch (c) {
                    case '/': {
                        n = -1;
                        break;
                    }
                    case '*': {
                        n = 2;
                    }
                }
            } else if (n > 1) {
                switch (c) {
                    case '*': {
                        n = 3;
                        break;
                    }
                    case '/': {
                        if (n == 3) {
                            n = 0;
                            break;
                        }
                        n = 2;
                        break;
                    }
                    default: {
                        n = 2;
                        break;
                    }
                }
            } else if (n < 0) {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        n = 0;
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '{': {
                        return this.parseObject(source);
                    }
                    case '[': {
                        return this.parseArray(source);
                    }
                    case '\"': {
                        return this.parseString(source);
                    }
                    case '-': {
                        return this.parseNumber(source);
                    }
                    case 'n': {
                        JSON.complete("null", source);
                        return null;
                    }
                    case 't': {
                        JSON.complete("true", source);
                        return Boolean.TRUE;
                    }
                    case 'f': {
                        JSON.complete("false", source);
                        return Boolean.FALSE;
                    }
                    case 'u': {
                        JSON.complete("undefined", source);
                        return null;
                    }
                    case '/': {
                        n = 1;
                        break;
                    }
                    default: {
                        if (Character.isDigit(c)) {
                            return this.parseNumber(source);
                        }
                        if (Character.isWhitespace(c)) break;
                        return this.handleUnknown(source, c);
                    }
                }
            }
            source.next();
        }
        return null;
    }

    protected Object handleUnknown(Source source, char c) {
        throw new IllegalStateException("unknown char '" + c + "'(" + c + ") in " + source);
    }

    protected Object parseObject(Source source) {
        Object object;
        String string;
        if (source.next() != '{') {
            throw new IllegalStateException();
        }
        Map map = this.newMap();
        char c = this.seekTo("\"}", source);
        while (source.hasNext()) {
            if (c == '}') {
                source.next();
                break;
            }
            string = this.parseString(source);
            this.seekTo(':', source);
            source.next();
            object = this.contextFor(string).parse(source);
            map.put(string, object);
            this.seekTo(",}", source);
            c = source.next();
            if (c == '}') break;
            c = this.seekTo("\"}", source);
        }
        if ((string = (String)map.get("class")) != null) {
            try {
                object = Loader.loadClass(JSON.class, string);
                return this.convertTo((Class)object, map);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        return map;
    }

    protected Object parseArray(Source source) {
        if (source.next() != '[') {
            throw new IllegalStateException();
        }
        int n = 0;
        ArrayList<Object> arrayList = null;
        Object object = null;
        boolean bl = true;
        block8: while (source.hasNext()) {
            char c = source.peek();
            switch (c) {
                case ']': {
                    source.next();
                    switch (n) {
                        case 0: {
                            return this.newArray(0);
                        }
                        case 1: {
                            Object[] objectArray = this.newArray(1);
                            Array.set(objectArray, 0, object);
                            return objectArray;
                        }
                    }
                    return arrayList.toArray(this.newArray(arrayList.size()));
                }
                case ',': {
                    if (bl) {
                        throw new IllegalStateException();
                    }
                    bl = true;
                    source.next();
                    continue block8;
                }
            }
            if (Character.isWhitespace(c)) {
                source.next();
                continue;
            }
            bl = false;
            if (n++ == 0) {
                object = this.contextForArray().parse(source);
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                arrayList.add(object);
                object = this.contextForArray().parse(source);
                arrayList.add(object);
                object = null;
                continue;
            }
            object = this.contextForArray().parse(source);
            arrayList.add(object);
            object = null;
        }
        throw new IllegalStateException("unexpected end of array");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String parseString(Source source) {
        char c;
        char c2;
        if (source.next() != '\"') {
            throw new IllegalStateException();
        }
        boolean bl = false;
        StringBuffer stringBuffer = null;
        char[] cArray = source.scratchBuffer();
        if (cArray != null) {
            int n = 0;
            while (source.hasNext()) {
                if (n >= cArray.length) {
                    stringBuffer = new StringBuffer(cArray.length * 2);
                    stringBuffer.append(cArray, 0, n);
                    break;
                }
                c2 = source.next();
                if (bl) {
                    bl = false;
                    switch (c2) {
                        case '\"': {
                            cArray[n++] = 34;
                            break;
                        }
                        case '\\': {
                            cArray[n++] = 92;
                            break;
                        }
                        case '/': {
                            cArray[n++] = 47;
                            break;
                        }
                        case 'b': {
                            cArray[n++] = 8;
                            break;
                        }
                        case 'f': {
                            cArray[n++] = 12;
                            break;
                        }
                        case 'n': {
                            cArray[n++] = 10;
                            break;
                        }
                        case 'r': {
                            cArray[n++] = 13;
                            break;
                        }
                        case 't': {
                            cArray[n++] = 9;
                            break;
                        }
                        case 'u': {
                            c = (char)((TypeUtil.convertHexDigit((byte)source.next()) << 12) + (TypeUtil.convertHexDigit((byte)source.next()) << 8) + (TypeUtil.convertHexDigit((byte)source.next()) << 4) + TypeUtil.convertHexDigit((byte)source.next()));
                            cArray[n++] = c;
                            break;
                        }
                        default: {
                            cArray[n++] = c2;
                            break;
                        }
                    }
                    continue;
                }
                if (c2 == '\\') {
                    bl = true;
                    continue;
                }
                if (c2 == '\"') {
                    return this.toString(cArray, 0, n);
                }
                cArray[n++] = c2;
            }
            if (stringBuffer == null) {
                return this.toString(cArray, 0, n);
            }
        } else {
            stringBuffer = new StringBuffer(this.getStringBufferSize());
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            while (source.hasNext()) {
                c2 = source.next();
                if (bl) {
                    bl = false;
                    switch (c2) {
                        case '\"': {
                            stringBuffer.append('\"');
                            break;
                        }
                        case '\\': {
                            stringBuffer.append('\\');
                            break;
                        }
                        case '/': {
                            stringBuffer.append('/');
                            break;
                        }
                        case 'b': {
                            stringBuffer.append('\b');
                            break;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            break;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            break;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            break;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            break;
                        }
                        case 'u': {
                            c = (char)((TypeUtil.convertHexDigit((byte)source.next()) << 12) + (TypeUtil.convertHexDigit((byte)source.next()) << 8) + (TypeUtil.convertHexDigit((byte)source.next()) << 4) + TypeUtil.convertHexDigit((byte)source.next()));
                            stringBuffer.append(c);
                            break;
                        }
                        default: {
                            stringBuffer.append(c2);
                            break;
                        }
                    }
                    continue;
                }
                if (c2 == '\\') {
                    bl = true;
                    continue;
                }
                if (c2 == '\"') break;
                stringBuffer.append(c2);
            }
            return stringBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number parseNumber(Source source) {
        boolean bl = false;
        long l = 0L;
        StringBuffer stringBuffer = null;
        block11: while (source.hasNext()) {
            char c = source.peek();
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    l = l * 10L + (long)(c - 48);
                    source.next();
                    continue block11;
                }
                case '+': 
                case '-': {
                    if (l != 0L) {
                        throw new IllegalStateException("bad number");
                    }
                    bl = true;
                    source.next();
                    continue block11;
                }
                case '.': 
                case 'E': 
                case 'e': {
                    stringBuffer = new StringBuffer(16);
                    if (bl) {
                        stringBuffer.append('-');
                    }
                    stringBuffer.append(l);
                    stringBuffer.append(c);
                    source.next();
                    break;
                }
            }
            break;
        }
        if (stringBuffer == null) {
            return TypeUtil.newLong(bl ? -1L * l : l);
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            block12: while (source.hasNext()) {
                char c = source.peek();
                switch (c) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'E': 
                    case 'e': {
                        stringBuffer.append(c);
                        source.next();
                        continue block12;
                    }
                }
                break;
            }
            return new Double(stringBuffer.toString());
        }
    }

    protected void seekTo(char c, Source source) {
        while (source.hasNext()) {
            char c2 = source.peek();
            if (c2 == c) {
                return;
            }
            if (!Character.isWhitespace(c2)) {
                throw new IllegalStateException("Unexpected '" + c2 + " while seeking '" + c + "'");
            }
            source.next();
        }
        throw new IllegalStateException("Expected '" + c + "'");
    }

    protected char seekTo(String string, Source source) {
        while (source.hasNext()) {
            char c = source.peek();
            if (string.indexOf(c) >= 0) {
                return c;
            }
            if (!Character.isWhitespace(c)) {
                throw new IllegalStateException("Unexpected '" + c + "' while seeking one of '" + string + "'");
            }
            source.next();
        }
        throw new IllegalStateException("Expected one of '" + string + "'");
    }

    protected static void complete(String string, Source source) {
        int n = 0;
        while (source.hasNext() && n < string.length()) {
            char c = source.next();
            if (c == string.charAt(n++)) continue;
            throw new IllegalStateException("Unexpected '" + c + " while seeking  \"" + string + "\"");
        }
        if (n < string.length()) {
            throw new IllegalStateException("Expected \"" + string + "\"");
        }
    }

    public static class Literal
    implements Generator {
        private String _json;

        public Literal(String string) {
            if (Log.isDebugEnabled()) {
                JSON.parse(string);
            }
            this._json = string;
        }

        public String toString() {
            return this._json;
        }

        @Override
        public void addJSON(StringBuffer stringBuffer) {
            stringBuffer.append(this._json);
        }
    }

    public static interface Generator {
        public void addJSON(StringBuffer var1);
    }

    public static interface Convertor {
        public void toJSON(Object var1, Output var2);

        public Object fromJSON(Map var1);
    }

    public static interface Convertible {
        public void toJSON(Output var1);

        public void fromJSON(Map var1);
    }

    public static interface Output {
        public void addClass(Class var1);

        public void add(Object var1);

        public void add(String var1, Object var2);

        public void add(String var1, double var2);

        public void add(String var1, long var2);

        public void add(String var1, boolean var2);
    }

    public static class ReaderSource
    implements Source {
        private Reader _reader;
        private int _next = -1;
        private char[] scratch;

        public ReaderSource(Reader reader) {
            this._reader = reader;
        }

        public void setReader(Reader reader) {
            this._reader = reader;
            this._next = -1;
        }

        @Override
        public boolean hasNext() {
            this.getNext();
            if (this._next < 0) {
                this.scratch = null;
                return false;
            }
            return true;
        }

        @Override
        public char next() {
            this.getNext();
            char c = (char)this._next;
            this._next = -1;
            return c;
        }

        @Override
        public char peek() {
            this.getNext();
            return (char)this._next;
        }

        private void getNext() {
            if (this._next < 0) {
                try {
                    this._next = this._reader.read();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }

        @Override
        public char[] scratchBuffer() {
            if (this.scratch == null) {
                this.scratch = new char[1024];
            }
            return this.scratch;
        }
    }

    public static class StringSource
    implements Source {
        private final String string;
        private int index;
        private char[] scratch;

        public StringSource(String string) {
            this.string = string;
        }

        @Override
        public boolean hasNext() {
            if (this.index < this.string.length()) {
                return true;
            }
            this.scratch = null;
            return false;
        }

        @Override
        public char next() {
            return this.string.charAt(this.index++);
        }

        @Override
        public char peek() {
            return this.string.charAt(this.index);
        }

        public String toString() {
            return this.string.substring(0, this.index) + "|||" + this.string.substring(this.index);
        }

        @Override
        public char[] scratchBuffer() {
            if (this.scratch == null) {
                this.scratch = new char[this.string.length()];
            }
            return this.scratch;
        }
    }

    public static interface Source {
        public boolean hasNext();

        public char next();

        public char peek();

        public char[] scratchBuffer();
    }
}

