/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.mortbay.component.LifeCycle;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.util.TypeUtil;
import org.mortbay.xml.XmlParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlConfiguration {
    private static Class[] __primitives = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
    private static Class[] __primitiveHolders = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class};
    private static final Integer ZERO = new Integer(0);
    private static XmlParser __parser;
    private XmlParser.Node _config;
    private Map _idMap = new HashMap();
    private Map _propertyMap = new HashMap();

    private static synchronized void initParser() throws IOException {
        if (__parser != null) {
            return;
        }
        __parser = new XmlParser();
        try {
            URL uRL = Loader.getResource(XmlConfiguration.class, "org/mortbay/xml/configure_6_0.dtd", true);
            __parser.redirectEntity("configure.dtd", uRL);
            __parser.redirectEntity("configure_1_3.dtd", uRL);
            __parser.redirectEntity("http://jetty.mortbay.org/configure.dtd", uRL);
            __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure//EN", uRL);
            __parser.redirectEntity("http://jetty.mortbay.org/configure_1_3.dtd", uRL);
            __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.3//EN", uRL);
            __parser.redirectEntity("configure_1_2.dtd", uRL);
            __parser.redirectEntity("http://jetty.mortbay.org/configure_1_2.dtd", uRL);
            __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.2//EN", uRL);
            __parser.redirectEntity("configure_1_1.dtd", uRL);
            __parser.redirectEntity("http://jetty.mortbay.org/configure_1_1.dtd", uRL);
            __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.1//EN", uRL);
            __parser.redirectEntity("configure_1_0.dtd", uRL);
            __parser.redirectEntity("http://jetty.mortbay.org/configure_1_0.dtd", uRL);
            __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.0//EN", uRL);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.warn(classNotFoundException.toString());
            Log.debug(classNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(URL uRL) throws SAXException, IOException {
        XmlConfiguration.initParser();
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._config = __parser.parse(uRL.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(String string) throws SAXException, IOException {
        XmlConfiguration.initParser();
        string = "<?xml version=\"1.0\"  encoding=\"ISO-8859-1\"?>\n<!DOCTYPE Configure PUBLIC \"-//Mort Bay Consulting//DTD Configure 1.2//EN\" \"http://jetty.mortbay.org/configure_1_2.dtd\">" + string;
        InputSource inputSource = new InputSource(new StringReader(string));
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._config = __parser.parse(inputSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(InputStream inputStream) throws SAXException, IOException {
        XmlConfiguration.initParser();
        InputSource inputSource = new InputSource(inputStream);
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._config = __parser.parse(inputSource);
        }
    }

    public Map getIdMap() {
        return this._idMap;
    }

    public void setIdMap(Map map) {
        this._idMap = map;
    }

    public void setProperties(Map map) {
        this._propertyMap = map;
    }

    public Map getProperties() {
        return this._propertyMap;
    }

    public void configure(Object object) throws Exception {
        Class clazz = this.nodeClass(this._config);
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("Object is not of type " + clazz);
        }
        this.configure(object, this._config, 0);
    }

    public Object configure() throws Exception {
        Object var3_3;
        Class clazz = this.nodeClass(this._config);
        String string = this._config.getAttribute("id");
        Object v0 = var3_3 = string == null ? null : this._idMap.get(string);
        if (var3_3 == null && clazz != null) {
            var3_3 = clazz.newInstance();
        }
        if (clazz != null && !clazz.isInstance(var3_3)) {
            throw new ClassCastException(clazz.toString());
        }
        this.configure(var3_3, this._config, 0);
        return var3_3;
    }

    private Class nodeClass(XmlParser.Node node) throws ClassNotFoundException {
        String string = node.getAttribute("class");
        if (string == null) {
            return null;
        }
        return Loader.loadClass(XmlConfiguration.class, string, true);
    }

    private void configure(Object object, XmlParser.Node node, int n) throws Exception {
        String string = node.getAttribute("id");
        if (string != null) {
            this._idMap.put(string, object);
        }
        while (n < node.size()) {
            block13: {
                Object object2 = node.get(n);
                if (!(object2 instanceof String)) {
                    XmlParser.Node node2 = (XmlParser.Node)object2;
                    try {
                        String string2 = node2.getTag();
                        if ("Set".equals(string2)) {
                            this.set(object, node2);
                            break block13;
                        }
                        if ("Put".equals(string2)) {
                            this.put(object, node2);
                            break block13;
                        }
                        if ("Call".equals(string2)) {
                            this.call(object, node2);
                            break block13;
                        }
                        if ("Get".equals(string2)) {
                            this.get(object, node2);
                            break block13;
                        }
                        if ("New".equals(string2)) {
                            this.newObj(object, node2);
                            break block13;
                        }
                        if ("Array".equals(string2)) {
                            this.newArray(object, node2);
                            break block13;
                        }
                        if ("Ref".equals(string2)) {
                            this.refObj(object, node2);
                            break block13;
                        }
                        if ("Property".equals(string2)) {
                            this.propertyObj(object, node2);
                            break block13;
                        }
                        throw new IllegalStateException("Unknown tag: " + string2);
                    }
                    catch (Exception exception) {
                        Log.warn("Config error at " + node2, exception.toString());
                        throw exception;
                    }
                }
            }
            ++n;
        }
    }

    private void set(Object object, XmlParser.Node node) throws Exception {
        Method[] methodArray;
        String string = node.getAttribute("name");
        String string2 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
        Object object2 = this.value(object, node);
        Object[] objectArray = new Object[]{object2};
        Class<?> clazz = this.nodeClass(node);
        if (clazz != null) {
            object = null;
        } else {
            clazz = object.getClass();
        }
        Class[] classArray = new Class[]{Object.class};
        if (object2 != null) {
            classArray[0] = object2.getClass();
        }
        if (Log.isDebugEnabled()) {
            Log.debug("XML " + (object != null ? object.toString() : clazz.getName()) + "." + string2 + "(" + object2 + ")");
        }
        try {
            Method method = clazz.getMethod(string2, classArray);
            method.invoke(object, objectArray);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.ignore(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.ignore(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.ignore(noSuchMethodException);
        }
        try {
            Field field = classArray[0].getField("TYPE");
            classArray[0] = (Class)field.get(null);
            Method method = clazz.getMethod(string2, classArray);
            method.invoke(object, objectArray);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Log.ignore(noSuchFieldException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.ignore(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.ignore(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.ignore(noSuchMethodException);
        }
        try {
            methodArray = clazz.getField(string);
            if (Modifier.isPublic(methodArray.getModifiers())) {
                methodArray.set(object, object2);
                return;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Log.ignore(noSuchFieldException);
        }
        methodArray = clazz.getMethods();
        Method method = null;
        for (int i = 0; methodArray != null && i < methodArray.length; ++i) {
            if (!string2.equals(methodArray[i].getName()) || methodArray[i].getParameterTypes().length != 1) continue;
            try {
                method = methodArray[i];
                methodArray[i].invoke(object, objectArray);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.ignore(illegalArgumentException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.ignore(illegalAccessException);
            }
        }
        if (method != null) {
            try {
                Class clazz2 = method.getParameterTypes()[0];
                if (clazz2.isPrimitive()) {
                    for (int i = 0; i < __primitives.length; ++i) {
                        if (!clazz2.equals(__primitives[i])) continue;
                        clazz2 = __primitiveHolders[i];
                        break;
                    }
                }
                Constructor<?> constructor = clazz2.getConstructor(classArray);
                objectArray[0] = constructor.newInstance(objectArray);
                method.invoke(object, objectArray);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.ignore(noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.ignore(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                Log.ignore(instantiationException);
            }
        }
        throw new NoSuchMethodException(clazz + "." + string2 + "(" + classArray[0] + ")");
    }

    private void put(Object object, XmlParser.Node node) throws Exception {
        if (!(object instanceof Map)) {
            throw new IllegalArgumentException("Object for put is not a Map: " + object);
        }
        Map map = (Map)object;
        String string = node.getAttribute("name");
        Object object2 = this.value(object, node);
        map.put(string, object2);
        if (Log.isDebugEnabled()) {
            Log.debug("XML " + object + ".put(" + string + "," + object2 + ")");
        }
    }

    private Object get(Object object, XmlParser.Node node) throws Exception {
        Class<?> clazz = this.nodeClass(node);
        if (clazz != null) {
            object = null;
        } else {
            clazz = object.getClass();
        }
        String string = node.getAttribute("name");
        String string2 = node.getAttribute("id");
        if (Log.isDebugEnabled()) {
            Log.debug("XML get " + string);
        }
        try {
            Method method = clazz.getMethod("get" + string.substring(0, 1).toUpperCase() + string.substring(1), null);
            object = method.invoke(object, (Object[])null);
            this.configure(object, node, 0);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Field field = clazz.getField(string);
                object = field.get(object);
                this.configure(object, node, 0);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw noSuchMethodException;
            }
        }
        if (string2 != null) {
            this._idMap.put(string2, object);
        }
        return object;
    }

    private Object call(Object object, XmlParser.Node node) throws Exception {
        String string = node.getAttribute("id");
        Class<?> clazz = this.nodeClass(node);
        if (clazz != null) {
            object = null;
        } else if (object != null) {
            clazz = object.getClass();
        }
        if (clazz == null) {
            throw new IllegalArgumentException(node.toString());
        }
        int n = 0;
        int n2 = node.size();
        for (int i = 0; i < node.size(); ++i) {
            Object object2 = node.get(i);
            if (object2 instanceof String) continue;
            if (!((XmlParser.Node)object2).getTag().equals("Arg")) {
                n2 = i;
                break;
            }
            ++n;
        }
        Object[] objectArray = new Object[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            Object object3 = node.get(n3);
            if (!(object3 instanceof String)) {
                objectArray[n4++] = this.value(object, (XmlParser.Node)object3);
            }
            ++n3;
        }
        String string2 = node.getAttribute("name");
        if (Log.isDebugEnabled()) {
            Log.debug("XML call " + string2);
        }
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; methodArray != null && i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string2) || methodArray[i].getParameterTypes().length != n || Modifier.isStatic(methodArray[i].getModifiers()) != (object == null) || object == null && methodArray[i].getDeclaringClass() != clazz) continue;
            Object object4 = null;
            boolean bl = false;
            try {
                object4 = methodArray[i].invoke(object, objectArray);
                bl = true;
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.ignore(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.ignore(illegalArgumentException);
            }
            if (!bl) continue;
            if (string != null) {
                this._idMap.put(string, object4);
            }
            this.configure(object4, node, n2);
            return object4;
        }
        throw new IllegalStateException("No Method: " + node + " on " + clazz);
    }

    private Object newObj(Object object, XmlParser.Node node) throws Exception {
        Object object2;
        Class clazz = this.nodeClass(node);
        String string = node.getAttribute("id");
        int n = 0;
        int n2 = node.size();
        for (int i = 0; i < node.size(); ++i) {
            Object object3 = node.get(i);
            if (object3 instanceof String) continue;
            if (!((XmlParser.Node)object3).getTag().equals("Arg")) {
                n2 = i;
                break;
            }
            ++n;
        }
        Object[] objectArray = new Object[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            object2 = node.get(n3);
            if (!(object2 instanceof String)) {
                objectArray[n4++] = this.value(object, (XmlParser.Node)object2);
            }
            ++n3;
        }
        if (Log.isDebugEnabled()) {
            Log.debug("XML new " + clazz);
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (n4 = 0; constructorArray != null && n4 < constructorArray.length; ++n4) {
            if (constructorArray[n4].getParameterTypes().length != n) continue;
            object2 = null;
            boolean bl = false;
            try {
                object2 = constructorArray[n4].newInstance(objectArray);
                bl = true;
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.ignore(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                Log.ignore(instantiationException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.ignore(illegalArgumentException);
            }
            if (!bl) continue;
            if (string != null) {
                this._idMap.put(string, object2);
            }
            this.configure(object2, node, n2);
            return object2;
        }
        throw new IllegalStateException("No Constructor: " + node + " on " + object);
    }

    private Object refObj(Object object, XmlParser.Node node) throws Exception {
        String string = node.getAttribute("id");
        object = this._idMap.get(string);
        if (object == null) {
            throw new IllegalStateException("No object for id=" + string);
        }
        this.configure(object, node, 0);
        return object;
    }

    private Object newArray(Object object, XmlParser.Node node) throws Exception {
        Object object2;
        Class clazz = Object.class;
        String string = node.getAttribute("type");
        String string2 = node.getAttribute("id");
        if (string != null && (clazz = TypeUtil.fromName(string)) == null) {
            clazz = "String".equals(string) ? String.class : ("URL".equals(string) ? URL.class : ("InetAddress".equals(string) ? InetAddress.class : Loader.loadClass(XmlConfiguration.class, string, true)));
        }
        Object object3 = null;
        Iterator iterator = node.iterator("Item");
        while (iterator.hasNext()) {
            object2 = (XmlParser.Node)iterator.next();
            String string3 = ((XmlParser.Node)object2).getAttribute("id");
            Object object4 = this.value(object, (XmlParser.Node)object2);
            object3 = LazyList.add(object3, object4 == null && clazz.isPrimitive() ? ZERO : object4);
            if (string3 == null) continue;
            this._idMap.put(string3, object4);
        }
        object2 = LazyList.toArray(object3, clazz);
        if (string2 != null) {
            this._idMap.put(string2, object2);
        }
        return object2;
    }

    private Object newMap(Object object, XmlParser.Node node) throws Exception {
        String string = node.getAttribute("id");
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (string != null) {
            this._idMap.put(string, hashMap);
        }
        for (int i = 0; i < node.size(); ++i) {
            Object object2;
            Object object3 = node.get(i);
            if (object3 instanceof String) continue;
            XmlParser.Node node2 = (XmlParser.Node)object3;
            if (!node2.getTag().equals("Entry")) {
                throw new IllegalStateException("Not an Entry");
            }
            Object object4 = null;
            Object object5 = null;
            for (int j = 0; j < node2.size(); ++j) {
                object3 = node2.get(j);
                if (object3 instanceof String) continue;
                object2 = (XmlParser.Node)object3;
                if (!((XmlParser.Node)object2).getTag().equals("Item")) {
                    throw new IllegalStateException("Not an Item");
                }
                if (object4 == null) {
                    object4 = object2;
                    continue;
                }
                object5 = object2;
            }
            if (object4 == null || object5 == null) {
                throw new IllegalStateException("Missing Item in Entry");
            }
            String string2 = ((XmlParser.Node)object4).getAttribute("id");
            object2 = ((XmlParser.Node)object5).getAttribute("id");
            Object object6 = this.value(object, (XmlParser.Node)object4);
            Object object7 = this.value(object, (XmlParser.Node)object5);
            hashMap.put(object6, object7);
            if (string2 != null) {
                this._idMap.put(string2, object6);
            }
            if (object2 == null) continue;
            this._idMap.put(object2, object7);
        }
        return hashMap;
    }

    private Object propertyObj(Object object, XmlParser.Node node) throws Exception {
        String string = node.getAttribute("id");
        String string2 = node.getAttribute("name");
        String string3 = node.getAttribute("default");
        String string4 = null;
        if (this._propertyMap != null && this._propertyMap.containsKey(string2)) {
            string4 = this._propertyMap.get(string2);
        } else if (string3 != null) {
            string4 = string3;
        }
        if (string != null) {
            this._idMap.put(string, string4);
        }
        if (string4 != null) {
            this.configure(string4, node, 0);
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object value(Object object, XmlParser.Node node) throws Exception {
        Object object2 = null;
        String string = node.getAttribute("type");
        String string2 = node.getAttribute("ref");
        if (string2 != null) {
            object2 = this._idMap.get(string2);
        } else {
            int n;
            Object object3;
            if (node.size() == 0) {
                if ("String".equals(string)) {
                    return "";
                }
                return null;
            }
            int n2 = node.size() - 1;
            if (string == null || !"String".equals(string)) {
                object3 = null;
                for (n = 0; n <= n2 && (object3 = node.get(n)) instanceof String && ((String)(object3 = ((String)object3).trim())).length() <= 0; ++n) {
                }
                while (n < n2 && (object3 = node.get(n2)) instanceof String && ((String)(object3 = ((String)object3).trim())).length() <= 0) {
                    --n2;
                }
                if (n > n2) {
                    return null;
                }
            }
            if (n == n2) {
                object2 = this.itemValue(object, node.get(n));
            } else {
                Object object4 = object3 = new StringBuffer();
                synchronized (object4) {
                    for (int i = n; i <= n2; ++i) {
                        Object object5 = node.get(i);
                        ((StringBuffer)object3).append(this.itemValue(object, object5));
                    }
                    object2 = ((StringBuffer)object3).toString();
                }
            }
        }
        if (object2 == null) {
            if ("String".equals(string)) {
                return "";
            }
            return null;
        }
        if (string == null) {
            if (object2 != null && object2 instanceof String) {
                return ((String)object2).trim();
            }
            return object2;
        }
        if ("String".equals(string) || "java.lang.String".equals(string)) {
            return object2.toString();
        }
        Class clazz = TypeUtil.fromName(string);
        if (clazz != null) {
            return TypeUtil.valueOf(clazz, object2.toString());
        }
        if ("URL".equals(string) || "java.net.URL".equals(string)) {
            if (object2 instanceof URL) {
                return object2;
            }
            try {
                return new URL(object2.toString());
            }
            catch (MalformedURLException malformedURLException) {
                throw new InvocationTargetException(malformedURLException);
            }
        }
        if ("InetAddress".equals(string) || "java.net.InetAddress".equals(string)) {
            if (object2 instanceof InetAddress) {
                return object2;
            }
            try {
                return InetAddress.getByName(object2.toString());
            }
            catch (UnknownHostException unknownHostException) {
                throw new InvocationTargetException(unknownHostException);
            }
        }
        throw new IllegalStateException("Unknown type " + string);
    }

    private Object itemValue(Object object, Object object2) throws Exception {
        if (object2 instanceof String) {
            return object2;
        }
        XmlParser.Node node = (XmlParser.Node)object2;
        String string = node.getTag();
        if ("Call".equals(string)) {
            return this.call(object, node);
        }
        if ("Get".equals(string)) {
            return this.get(object, node);
        }
        if ("New".equals(string)) {
            return this.newObj(object, node);
        }
        if ("Ref".equals(string)) {
            return this.refObj(object, node);
        }
        if ("Array".equals(string)) {
            return this.newArray(object, node);
        }
        if ("Map".equals(string)) {
            return this.newMap(object, node);
        }
        if ("Property".equals(string)) {
            return this.propertyObj(object, node);
        }
        if ("SystemProperty".equals(string)) {
            String string2 = node.getAttribute("name");
            String string3 = node.getAttribute("default");
            return System.getProperty(string2, string3);
        }
        Log.warn("Unknown value tag: " + node, new Throwable());
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            XmlConfiguration xmlConfiguration;
            int n;
            Properties properties = new Properties();
            XmlConfiguration xmlConfiguration2 = null;
            Object[] objectArray = new Object[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].toLowerCase().endsWith(".properties")) {
                    properties.load(Resource.newResource((String)stringArray[n]).getInputStream());
                    continue;
                }
                xmlConfiguration = new XmlConfiguration(Resource.newResource((String)stringArray[n]).getURL());
                if (xmlConfiguration2 != null) {
                    xmlConfiguration.getIdMap().putAll(xmlConfiguration2.getIdMap());
                }
                if (properties.size() > 0) {
                    xmlConfiguration.setProperties(properties);
                }
                objectArray[n] = xmlConfiguration.configure();
                xmlConfiguration2 = xmlConfiguration;
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (!(objectArray[n] instanceof LifeCycle) || (xmlConfiguration = (LifeCycle)objectArray[n]).isRunning()) continue;
                xmlConfiguration.start();
            }
        }
        catch (Exception exception) {
            Log.warn("EXCEPTION ", exception);
        }
    }
}

