/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.tools.util.Logging;
import com.google.appengine.tools.util.Option;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import java.awt.Toolkit;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public abstract class SharedMain {
    private static String originalTimeZone;
    private boolean disableRestrictedCheck = false;
    private String runtime = null;
    private String pathToPythonApiServer = null;
    private List<String> apisUsingPythonStubs = null;
    private List<String> propertyOptions = null;
    private List<String> pythonApiServerFlags = null;

    protected List<Option> getSharedOptions() {
        return Arrays.asList(new Option("h", "help", true){

            @Override
            public void apply() {
                SharedMain.this.printHelp(System.err);
                System.exit(0);
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --help, -h                 Show this help message and exit.");
            }
        }, new Option(this, null, "sdk_root", false){

            @Override
            public void apply() {
                System.setProperty("appengine.sdk.root", this.getValue());
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --sdk_root=DIR             Overrides where the SDK is located.");
            }
        }, new Option(null, "disable_restricted_check", true){

            @Override
            public void apply() {
                SharedMain.this.disableRestrictedCheck = true;
            }
        }, new Option(null, "property", false){

            @Override
            public void apply() {
                SharedMain.this.propertyOptions = this.getValues();
            }
        }, new Option(this, null, "allow_remote_shutdown", true){

            @Override
            public void apply() {
                System.setProperty("appengine.allowRemoteShutdown", "true");
            }
        }, new Option(null, "api_using_python_stub", false){

            @Override
            public void apply() {
                SharedMain.this.apisUsingPythonStubs = this.getValues();
                if (!SharedMain.this.apisUsingPythonStubs.isEmpty()) {
                    System.setProperty("appengine.apisUsingPythonStubs", Joiner.on(',').join(SharedMain.this.apisUsingPythonStubs));
                }
            }
        }, new Option(null, "path_to_python_api_server", false){

            @Override
            public void apply() {
                SharedMain.this.pathToPythonApiServer = this.getValue();
                System.setProperty("appengine.pathToPythonApiServer", SharedMain.this.pathToPythonApiServer);
            }
        }, new Option(this, null, "no_java_agent", true){

            @Override
            public void apply() {
            }
        }, new Option(null, "runtime", false){

            @Override
            public void apply() {
                SharedMain.this.runtime = this.getValue();
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --runtime=runtime_id       (java8 only).");
            }
        }, new Option(null, "python_api_server_flag", false){

            @Override
            public void apply() {
                SharedMain.this.pythonApiServerFlags = this.getValues();
                if (!SharedMain.this.pythonApiServerFlags.isEmpty()) {
                    System.setProperty("appengine.pythonApiServerFlags", Joiner.on('|').join(SharedMain.this.pythonApiServerFlags));
                }
            }
        });
    }

    protected static void sharedInit() {
        SharedMain.recordTimeZone();
        Logging.initializeLogging();
        if (System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            Toolkit.getDefaultToolkit();
        }
    }

    private static void recordTimeZone() {
        originalTimeZone = System.getProperty("user.timezone");
    }

    protected abstract void printHelp(PrintStream var1);

    protected void postServerActions(Map<String, String> stringProperties) {
        this.setTimeZone(stringProperties);
        if (this.disableRestrictedCheck) {
            stringProperties.put("appengine.disableRestrictedCheck", "");
        }
    }

    protected void addPropertyOptionToProperties(Map<String, String> properties) {
        properties.putAll(SharedMain.parsePropertiesList(this.propertyOptions));
    }

    protected Map<String, String> getSystemProperties() {
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) continue;
            String string = String.valueOf(entry.getKey());
            throw new IllegalArgumentException(new StringBuilder(20 + String.valueOf(string).length()).append("Non-string property ").append(string).toString());
        }
        Properties stringProperties = properties;
        return Collections.checkedMap(stringProperties, String.class, String.class);
    }

    private void setTimeZone(Map<String, String> serviceProperties) {
        String timeZone = serviceProperties.get("appengine.user.timezone");
        if (timeZone != null) {
            TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
        } else {
            timeZone = originalTimeZone;
        }
        serviceProperties.put("appengine.user.timezone.impl", timeZone);
    }

    public void validateWarPath(File war) {
        if (!war.exists()) {
            String string = String.valueOf(war);
            System.out.println(new StringBuilder(36 + String.valueOf(string).length()).append("Unable to find the webapp directory ").append(string).toString());
            this.printHelp(System.err);
            System.exit(1);
        } else if (!war.isDirectory()) {
            System.out.println("dev_appserver only accepts webapp directories, not war files.");
            this.printHelp(System.err);
            System.exit(1);
        }
    }

    protected void configureRuntime(File appDirectory) {
        if (this.runtime != null) {
            return;
        }
        File webXmlFile = new File(appDirectory, "WEB-INF/web.xml");
        if (!webXmlFile.exists()) {
            this.runtime = "java8";
        } else {
            AppEngineWebXml appEngineWebXml = new AppEngineWebXmlReader(appDirectory.getAbsolutePath()).readAppEngineWebXml();
            this.runtime = appEngineWebXml.getRuntime();
            if (this.runtime == null) {
                this.runtime = "java8";
            }
        }
        if (this.runtime.equals("java7")) {
            throw new IllegalArgumentException("the Java7 runtime is not supported anymore.");
        }
    }

    protected String getRuntime() {
        return this.runtime;
    }

    @VisibleForTesting
    static Map<String, String> parsePropertiesList(List<String> properties) {
        HashMap<String, String> parsedProperties = new HashMap<String, String>();
        if (properties != null) {
            for (String property : properties) {
                String[] propertyKeyValue = property.split("=", 2);
                if (propertyKeyValue.length == 2) {
                    parsedProperties.put(propertyKeyValue[0], propertyKeyValue[1]);
                    continue;
                }
                if (propertyKeyValue[0].startsWith("no")) {
                    parsedProperties.put(propertyKeyValue[0].substring(2), "false");
                    continue;
                }
                parsedProperties.put(propertyKeyValue[0], "true");
            }
        }
        return parsedProperties;
    }
}

