/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlException;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlReader;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.appengine.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.appengine.repackaged.com.google.api.client.json.jackson.JacksonFactory;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSortedSet;
import com.google.appengine.tools.admin.AdminException;
import com.google.appengine.tools.admin.AppAdmin;
import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.AppDownload;
import com.google.appengine.tools.admin.Application;
import com.google.appengine.tools.admin.ConfirmationCallback;
import com.google.appengine.tools.admin.CronEntry;
import com.google.appengine.tools.admin.IndexDeleter;
import com.google.appengine.tools.admin.LoginReader;
import com.google.appengine.tools.admin.LoginReaderFactory;
import com.google.appengine.tools.admin.OAuth2Native;
import com.google.appengine.tools.admin.ResourceLimits;
import com.google.appengine.tools.admin.ServerConnection;
import com.google.appengine.tools.admin.ServerConnectionFactory;
import com.google.appengine.tools.admin.UpdateFailureEvent;
import com.google.appengine.tools.admin.UpdateListener;
import com.google.appengine.tools.admin.UpdateProgressEvent;
import com.google.appengine.tools.admin.UpdateSuccessEvent;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.appengine.tools.info.SupportInfo;
import com.google.appengine.tools.info.UpdateCheck;
import com.google.appengine.tools.info.Version;
import com.google.appengine.tools.util.Action;
import com.google.appengine.tools.util.ActionsAndOptions;
import com.google.appengine.tools.util.ClientCookieManager;
import com.google.appengine.tools.util.Logging;
import com.google.appengine.tools.util.Option;
import com.google.appengine.tools.util.Parser;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.BackendsXml;
import com.google.apphosting.utils.config.EarHelper;
import com.google.apphosting.utils.config.EarInfo;
import com.google.apphosting.utils.config.StagingOptions;
import com.google.apphosting.utils.config.WebModule;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class AppCfg {
    private static final String OVERRIDE_MODULE_SHORT_ARG = "M";
    private static final String OVERRIDE_MODULE_LONG_ARG = "module";
    private final AppAdminFactory.ConnectOptions connectOptions;
    private AppCfgAction action;
    private String applicationDirectory;
    private String moduleName;
    private AppAdmin admin;
    private boolean passin;
    private boolean doBatch = true;
    private StagingOptions defaultStagingOptions = null;
    private StagingOptions.Builder stagingFlagsBuilder = null;
    private boolean disablePrompt = false;
    private File logFile = null;
    private LoginReader loginReader = null;
    private String overrideAppId;
    private String overrideModule;
    private String overrideAppVersion;
    private boolean oauth2;
    private String oauth2RefreshToken = null;
    private String oauth2ClientId = null;
    private String oauth2ClientSecret = null;
    private String jsonKeyPath = null;
    private boolean useCookies = true;
    private boolean useGoogleApplicationDefaultCredentials = false;
    private boolean useAsyncQuickstart = false;
    private String runtime;
    private boolean allowAnyRuntime = false;
    private boolean disableUpdateCheck = false;
    private boolean failOnPrecompilationError = false;
    private boolean ignoreEndpointsFailures = true;
    private boolean updateUsageReporting = true;
    private boolean enableQuickstart = false;
    private boolean autoUpdateDispatch = false;
    private static final List<String> generalOptionNamesInHelpOrder = ImmutableList.of("server", "email", "host", "proxy", "proxy_https", "no_cookies", "sdk_root", "passin", "insecure", "ignore_bad_cert", "application", "module", new String[]{"version", "oauth2", "noisy"});
    private static final List<String> optionNamesInHelpOrder = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(generalOptionNamesInHelpOrder)).add(new String[]{"enable_new_staging_defaults", "enable_jar_splitting", "jar_splitting_excludes", "disable_jar_jsps", "enable_jar_classes", "delete_jsps", "retain_upload_dir", "compile_encoding", "num_days", "severity", "include_all", "append", "num_runs", "force", "no_usage_reporting", "use_google_application_default_credentials", "service_account_json_key_file", "auto_update_dispatch"})).build();
    private static final List<String> actionNamesInHelpOrder = ImmutableList.of("help", "download_app", "request_logs", "rollback", "start_module_version", "stop_module_version", "update", "update_indexes", "update_cron", "update_queues", "update_dispatch", "update_dos", new String[]{"version", "set_default_version", "cron_info", "resource_limits_info", "vacuum_indexes", "backends list", "backends update", "backends rollback", "backends start", "backends stop", "backends delete", "backends configure", "list_versions", "delete_version"});
    private String helpText = null;
    private final List<Option> builtInOptions = Arrays.asList(new Option("h", "help", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -h, --help            Show the help message and exit.");
        }

        @Override
        public void apply() {
            AppCfg.this.printHelp();
            System.exit(1);
        }
    }, new Option("s", "server", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -s SERVER, --server=SERVER", "                        The server to connect to.");
        }

        @Override
        public void apply() {
            AppCfg.this.connectOptions.setServer(this.getValue());
        }
    }, new Option("e", "email", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -e EMAIL, --email=EMAIL", "                        The username to use. Will prompt if omitted.");
        }

        @Override
        public void apply() {
            AppCfg.this.connectOptions.setUserId(this.getValue());
        }
    }, new Option("H", "host", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.");
        }

        @Override
        public void apply() {
            AppCfg.this.connectOptions.setHost(this.getValue());
        }
    }, new Option(this, "p", "proxy", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]", "                        Proxies requests through the given proxy server.", "                        If --proxy_https is also set, only HTTP will be", "                        proxied here, otherwise both HTTP and HTTPS will.");
        }

        @Override
        public void apply() {
            HostPort hostport = new HostPort(this.getValue());
            System.setProperty("http.proxyHost", hostport.getHost());
            if (hostport.hasPort()) {
                System.setProperty("http.proxyPort", hostport.getPort());
            }
        }
    }, new Option(this, null, "proxy_https", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --proxy_https=PROXYHOST[:PORT]", "                        Proxies HTTPS requests through the given proxy server.");
        }

        @Override
        public void apply() {
            HostPort hostport = new HostPort(this.getValue());
            System.setProperty("https.proxyHost", hostport.getHost());
            if (hostport.hasPort()) {
                System.setProperty("https.proxyPort", hostport.getPort());
            }
        }
    }, new Option(null, "insecure", true){

        @Override
        public void apply() {
            AppCfg.this.connectOptions.setSecure(false);
        }
    }, new Option(this, null, "ignore_bad_cert", true){

        @Override
        public void apply() {
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(this){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
    }, new Option(null, "no_cookies", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --no_cookies          Do not save/load access credentials to/from disk.");
        }

        @Override
        public void apply() {
            AppCfg.this.useCookies = false;
            AppCfg.this.connectOptions.setUsePersistedCredentials(false);
        }
    }, new Option("f", "force", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -f, --force           Force deletion of indexes without being prompted.");
        }

        @Override
        public void apply() {
            if (AppCfg.this.action instanceof VacuumIndexesAction) {
                VacuumIndexesAction viAction = (VacuumIndexesAction)AppCfg.this.action;
                viAction.promptUserForEachDelete = false;
            }
        }
    }, new Option("a", "append", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -a, --append          Append to existing file.");
        }

        @Override
        public void apply() {
            if (AppCfg.this.action instanceof RequestLogsAction) {
                RequestLogsAction logsAction = (RequestLogsAction)AppCfg.this.action;
                logsAction.append = true;
            }
        }
    }, new Option("n", "num_days", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -n NUM_DAYS, --num_days=NUM_DAYS", "                        Number of days worth of log data to get. The cut-off", "                        point is midnight UTC. Use 0 to get all available", "                        logs. Default is 1.");
        }

        @Override
        public void apply() {
            if (AppCfg.this.action instanceof RequestLogsAction) {
                RequestLogsAction logsAction = (RequestLogsAction)AppCfg.this.action;
                try {
                    logsAction.numDays = Integer.parseInt(this.getValue());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("num_days must be an integral number.");
                }
            } else if (AppCfg.this.action instanceof CronInfoAction) {
                CronInfoAction croninfoAction = (CronInfoAction)AppCfg.this.action;
                croninfoAction.setNumRuns(this.getValue());
            }
        }
    }, new Option(null, "num_runs", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -n NUM_RUNS, --num_runs=NUM_RUNS", "                        Number of scheduled execution times to compute");
        }

        @Override
        public void apply() {
            if (AppCfg.this.action instanceof CronInfoAction) {
                CronInfoAction croninfoAction = (CronInfoAction)AppCfg.this.action;
                croninfoAction.setNumRuns(this.getValue());
            }
        }
    }, new Option(null, "severity", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --severity=SEVERITY   Severity of app-level log messages to get. The range", "                        is 0 (DEBUG) through 4 (CRITICAL). If omitted, only", "                        request logs are returned.");
        }

        @Override
        public void apply() {
            RequestLogsAction logsAction = (RequestLogsAction)AppCfg.this.action;
            try {
                int severity = Integer.parseInt(this.getValue());
                int maxSeverity = AppAdmin.LogSeverity.CRITICAL.ordinal();
                if (severity < 0 || severity > maxSeverity) {
                    throw new IllegalArgumentException(new StringBuilder(42).append("severity must be between 0 and ").append(maxSeverity).toString());
                }
                logsAction.severity = severity;
            }
            catch (NumberFormatException e) {
                for (AppAdmin.LogSeverity severity : AppAdmin.LogSeverity.values()) {
                    if (!this.getValue().equalsIgnoreCase(severity.toString())) continue;
                    logsAction.severity = severity.ordinal();
                    return;
                }
                throw new IllegalArgumentException("severity must be an integral number 0-4, or one of DEBUG, INFO, WARN, ERROR, CRITICAL");
            }
        }
    }, new Option(null, "include_all", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --include_all   Include everything in log messages.");
        }

        @Override
        public void apply() {
            RequestLogsAction logsAction = (RequestLogsAction)AppCfg.this.action;
            logsAction.includeAll = true;
        }
    }, new Option(null, "sdk_root", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --sdk_root=root       Overrides where the SDK is located.");
        }

        @Override
        public void apply() {
            AppCfg.this.connectOptions.setSdkRoot(this.getValue());
        }
    }, new Option(null, "enable_new_staging_defaults", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --enable_new_staging_defaults", "                        Use new set of staging options defaults (recommended).", "                        --enable_jar_splitting, --enable_jar_classes, and ", "                        --delete_jsps will all be set to true.");
        }

        @Override
        public void apply() {
            AppCfg.this.defaultStagingOptions = StagingOptions.SANE_DEFAULTS;
        }
    }, new Option(null, "disable_jar_jsps", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --disable_jar_jsps", "                        Do not jar the classes generated from JSPs.");
        }

        @Override
        public void apply() {
            AppCfg.this.stagingFlagsBuilder.setJarJsps(Optional.of(false));
        }
    }, new Option(null, "enable_jar_classes", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --enable_jar_classes", "                        Jar the WEB-INF/classes content.");
        }

        @Override
        public void apply() {
            AppCfg.this.stagingFlagsBuilder.setJarClasses(Optional.of(true));
        }
    }, new Option(null, "delete_jsps", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --delete_jsps", "                        Delete the JSP source files after compilation.");
        }

        @Override
        public void apply() {
            AppCfg.this.stagingFlagsBuilder.setDeleteJsps(Optional.of(true));
        }
    }, new Option(null, "use_async_quickstart", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --use_async_quickstart", "                        Use Servlet Async mode.");
        }

        @Override
        public void apply() {
            AppCfg.this.useAsyncQuickstart = true;
        }
    }, new Option(null, "enable_jar_splitting", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --enable_jar_splitting", "                        Split large jar files (> 10M) into smaller fragments.");
        }

        @Override
        public void apply() {
            AppCfg.this.stagingFlagsBuilder.setSplitJarFiles(Optional.of(true));
        }
    }, new Option(null, "jar_splitting_excludes", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --jar_splitting_excludes=SUFFIXES", "                        When --enable-jar-splitting is set, files that match", "                        the list of comma separated SUFFIXES will be excluded", "                        from all jars.");
        }

        @Override
        public void apply() {
            AppCfg.this.stagingFlagsBuilder.setSplitJarFilesExcludes(Optional.of(ImmutableSortedSet.copyOf((Comparable[])this.getValue().split(","))));
        }
    }, new Option(null, "retain_upload_dir", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --retain_upload_dir", "                        Do not delete temporary (staging) directory used in", "                        uploading.");
        }

        @Override
        public void apply() {
            AppCfg.this.connectOptions.setRetainUploadDir(true);
        }
    }, new Option(null, "passin", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --passin              Always read the login password from stdin.");
        }

        @Override
        public void apply() {
            AppCfg.this.passin = true;
        }
    }, new Option(null, "no_batch", true){

        @Override
        public void apply() {
            AppCfg.this.doBatch = false;
        }
    }, new Option(null, "compile_encoding", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --compile_encoding", "                        The character encoding to use when compiling JSPs.");
        }

        @Override
        public void apply() {
            AppCfg.this.stagingFlagsBuilder.setCompileEncoding(Optional.of(this.getValue()));
        }
    }, new Option(null, "disable_prompt", true){

        @Override
        public void apply() {
            AppCfg.this.disablePrompt = true;
        }
    }, new Option(null, "disable_update_check", true){

        @Override
        public void apply() {
            AppCfg.this.disableUpdateCheck = true;
        }
    }, new Option("A", "application", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -A APP_ID, --application=APP_ID", "                        Override application id from appengine-web.xml or app.yaml");
        }

        @Override
        public void apply() {
            AppCfg.this.overrideAppId = this.getValue();
        }
    }, new Option("M", "module", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -M MODULE, --module=MODULE", "                        Override module from appengine-web.xml or app.yaml");
        }

        @Override
        public void apply() {
            AppCfg.this.overrideModule = this.getValue();
        }
    }, new Option("V", "version", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -V VERSION, --version=VERSION", "                        Override (major) version from appengine-web.xml or app.yaml");
        }

        @Override
        public void apply() {
            AppCfg.this.overrideAppVersion = this.getValue();
        }
    }, new Option(this, null, "oauth2", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --oauth2              Ignored (OAuth2 is the default).");
        }

        @Override
        public void apply() {
        }
    }, new Option(null, "use_google_application_default_credentials", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("   --use_google_application_default_credentials", "                        Use Google Application Default Credentials as described in https://developers.google.com/identity/protocols/application-default-credentials");
        }

        @Override
        public void apply() {
            AppCfg.this.useCookies = false;
            AppCfg.this.useGoogleApplicationDefaultCredentials = true;
        }
    }, new Option(null, "oauth2_refresh_token", false){

        @Override
        public void apply() {
            AppCfg.this.oauth2RefreshToken = this.getValue();
            AppCfg.this.useCookies = false;
        }
    }, new Option(null, "oauth2_client_id", false){

        @Override
        public void apply() {
            AppCfg.this.oauth2ClientId = this.getValue();
            AppCfg.this.useCookies = false;
        }
    }, new Option(null, "oauth2_client_secret", false){

        @Override
        public void apply() {
            AppCfg.this.oauth2ClientSecret = this.getValue();
            AppCfg.this.useCookies = false;
        }
    }, new Option(null, "oauth2_config_file", false){

        @Override
        public void apply() {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(this.getValue()));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(String.format("OAuth2 configuration file does not exist: %s", this.getValue()), e);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Could not read OAuth2 configuration file: %s", this.getValue()), e);
            }
            AppCfg.this.oauth2RefreshToken = props.getProperty("oauth2_refresh_token");
            AppCfg.this.oauth2ClientId = props.getProperty("oauth2_client_id");
            AppCfg.this.oauth2ClientSecret = props.getProperty("oauth2_client_secret");
            if (AppCfg.this.oauth2RefreshToken != null || AppCfg.this.oauth2ClientId != null || AppCfg.this.oauth2ClientSecret != null) {
                AppCfg.this.useCookies = false;
            }
        }
    }, new Option(null, "service_account_json_key_file", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --service_account_json_key_file=path", "                       location of the service account json key file for a", "                       Service Account Credential login.", "                       (The cloud SDK uses ~/.config/gcloud/application_default_credentials.json )");
        }

        @Override
        public void apply() {
            AppCfg.this.jsonKeyPath = this.getValue();
            AppCfg.this.useCookies = false;
        }
    }, new Option(null, "no_usage_reporting", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --no_usage_reporting", "                        Disable usage reporting.");
        }

        @Override
        public void apply() {
            AppCfg.this.updateUsageReporting = false;
        }
    }, new Option(this, null, "use_java8", true){

        @Override
        public void apply() {
            System.err.println("The flag --use_java8 is ignored, please do not use it anymore.Instead, you can specify <runtime>java8</runtime> in appengine-web.xml.");
        }
    }, new Option(this, null, "noisy", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --noisy", "                        Log much more information about what the tool is doing.");
        }

        @Override
        public void apply() {
            Logger rootLogger = Logger.getLogger("");
            rootLogger.getHandlers()[0].setLevel(Level.ALL);
        }
    }, new Option("r", "runtime", false){

        @Override
        public void apply() {
            AppCfg.this.runtime = this.getValue();
        }
    }, new Option("R", "allow_any_runtime", true){

        @Override
        public void apply() {
            AppCfg.this.allowAnyRuntime = true;
        }
    }, new Option(null, "fail_on_precompilation_error", true){

        @Override
        public void apply() {
            AppCfg.this.failOnPrecompilationError = true;
        }
    }, new Option(null, "ignore_endpoints_failures", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --ignore_endpoints_failures", "                        When uploading an app that uses Google Cloud Endpoints,                        if there's a a failure to update the configuration on the                         Endpoints server, deployment should still complete.");
        }

        @Override
        public void apply() {
            AppCfg.this.ignoreEndpointsFailures = true;
        }
    }, new Option(null, "no_ignore_endpoints_failures", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --no_ignore_endpoints_failures", "                        When uploading an app that uses Google Cloud Endpoints,                        if there's a a failure to update the configuration on the                         Endpoints server, deployment should fail and rollback.");
        }

        @Override
        public void apply() {
            AppCfg.this.ignoreEndpointsFailures = false;
        }
    }, new Option(null, "use_remote_resource_limits", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --use_remote_resource_limits", "                        Get resource limits from server when staging");
        }

        @Override
        public void apply() {
            if (AppCfg.this.action instanceof StagingAction) {
                StagingAction stagingAction = (StagingAction)AppCfg.this.action;
                stagingAction.useRemoteResourceLimits = true;
            }
        }
    }, new Option(null, "enable_quickstart", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --enable_quickstart", "                        Use jetty quickstart to process servlet annotations");
        }

        @Override
        public void apply() {
            AppCfg.this.enableQuickstart = true;
        }
    }, new Option("D", "auto_update_dispatch", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -D, --auto_update_dispatch", "                        Include dispatch.yaml in updates ");
        }

        @Override
        public void apply() {
            AppCfg.this.autoUpdateDispatch = true;
        }
    });
    private final List<Action> builtInActions = Arrays.asList(new UpdateAction(), new RequestLogsAction(), new RollbackAction(), new UpdateIndexesAction(), new UpdateCronAction(), new UpdateDispatchAction(), new UpdateDosAction(), new UpdateQueueAction(), new CronInfoAction(), new VacuumIndexesAction(), new HelpAction(), new DownloadAppAction(), new VersionAction(this), new SetDefaultVersionAction(), new ResourceLimitsInfoAction(), new StartModuleVersionAction(), new StopModuleVersionAction(), new BackendsListAction(), new BackendsRollbackAction(), new BackendsUpdateAction(), new BackendsStartAction(), new BackendsStopAction(), new BackendsDeleteAction(), new BackendsConfigureAction(), new BackendsAction(), new ListVersionsAction(), new DeleteVersionAction(), new DebugAction(), new MigrateTrafficAction(), new StagingAction());
    private Map<String, Option> builtInOptionMap;
    private final ActionsAndOptions actionsAndOptions = this.buildActionsAndOptions();

    public static void main(String[] args) {
        Logging.initializeLogging();
        new AppCfg(args);
    }

    protected AppCfg(String[] cmdLineArgs) {
        this(new AppAdminFactory(), cmdLineArgs);
    }

    public AppCfg(AppAdminFactory factory, String[] cmdLineArgs) {
        PrintWriter logWriter;
        this.connectOptions = new AppAdminFactory.ConnectOptions();
        Parser parser = new Parser();
        this.oauth2 = this.isOauth2EnabledByDefault();
        this.defaultStagingOptions = StagingOptions.ANCIENT_DEFAULTS;
        this.stagingFlagsBuilder = StagingOptions.builder();
        try {
            this.logFile = File.createTempFile("appcfg", ".log");
            logWriter = new PrintWriter((Writer)new FileWriter(this.logFile), true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to enable logging.", e);
        }
        try {
            Parser.ParseResult result = parser.parseArgs(this.actionsAndOptions.actions, this.actionsAndOptions.options, cmdLineArgs);
            this.action = (AppCfgAction)result.getAction();
            this.validateCommandLineForEar();
            try {
                result.applyArgs();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace(logWriter);
                String string = String.valueOf(e.getMessage());
                System.out.println(string.length() != 0 ? "Bad argument: ".concat(string) : new String("Bad argument: "));
                System.out.println(this.action.getHelpString());
                System.exit(1);
            }
            if (System.getProperty("http.proxyHost") != null && System.getProperty("https.proxyHost") == null) {
                System.setProperty("https.proxyHost", System.getProperty("http.proxyHost"));
                if (System.getProperty("http.proxyPort") != null && System.getProperty("https.proxyPort") == null) {
                    System.setProperty("https.proxyPort", System.getProperty("http.proxyPort"));
                }
            }
            if (this.applicationDirectory != null) {
                File appDirectoryFile = new File(this.applicationDirectory);
                this.validateApplicationDirectory(appDirectoryFile);
                UpdateCheck updateCheck = new UpdateCheck(this.connectOptions.getServer(), appDirectoryFile, this.connectOptions.getSecure());
                if (!this.disableUpdateCheck) {
                    updateCheck.maybePrintNagScreen(System.out);
                }
                updateCheck.checkJavaVersion(System.out);
                if (this.action.requiresAuth()) {
                    if (this.oauth2) {
                        this.authorizeOauth2(this.connectOptions);
                    } else {
                        this.loadCookies(this.connectOptions);
                    }
                }
                factory.setBatchMode(this.doBatch);
                factory.setDefaultStagingOptions(this.defaultStagingOptions);
                factory.setStagingOptions(this.stagingFlagsBuilder.build());
                factory.setUseAsyncQuickstart(this.useAsyncQuickstart);
                factory.setRuntime(this.runtime);
                factory.setAllowAnyRuntime(this.allowAnyRuntime);
                factory.setCallerUploadingDispatch(this.autoUpdateDispatch);
                factory.setFailOnPrecompilationError(this.failOnPrecompilationError);
                factory.setIgnoreEndpointsFailures(this.ignoreEndpointsFailures);
                factory.setQuickstart(this.enableQuickstart);
                System.out.println("Reading application configuration data...");
            }
            Iterable<Application> applications = this.readApplication();
            this.validateApplications(applications, this.action instanceof StagingAction);
            this.executeAction(factory, applications, logWriter, this.action);
            System.out.println("Success.");
            this.cleanStaging(applications);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(logWriter);
            String string = String.valueOf(e.getMessage());
            System.out.println(string.length() != 0 ? "Bad argument: ".concat(string) : new String("Bad argument: "));
            this.printHelp();
            System.exit(1);
        }
        catch (AppEngineConfigException e) {
            e.printStackTrace(logWriter);
            String string = String.valueOf(e.getMessage());
            System.out.println(string.length() != 0 ? "Bad configuration: ".concat(string) : new String("Bad configuration: "));
            if (e.getCause() != null) {
                String string2 = String.valueOf(e.getCause().getMessage());
                System.out.println(string2.length() != 0 ? "  Caused by: ".concat(string2) : new String("  Caused by: "));
            }
            this.printLogLocation();
            System.exit(1);
        }
        catch (Exception e) {
            String string = String.valueOf(e.getMessage());
            System.out.println(string.length() != 0 ? "Encountered a problem: ".concat(string) : new String("Encountered a problem: "));
            e.printStackTrace(logWriter);
            this.printLogLocation();
            System.exit(1);
        }
    }

    boolean isOauth2EnabledByDefault() {
        return true;
    }

    private void validateCommandLineForEar() {
        if (EarHelper.isEar(this.applicationDirectory)) {
            if (!this.action.isEarAction()) {
                throw new IllegalArgumentException("The requested action does not support EAR configurations");
            }
            if (this.overrideModule != null) {
                throw new IllegalArgumentException("With an EAR configuration -M/--module is not allowed.");
            }
        }
    }

    private Iterable<Application> readApplication() throws IOException {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        if (this.applicationDirectory != null) {
            if (EarHelper.isEar(this.applicationDirectory, false)) {
                EarInfo earInfo = EarHelper.readEarInfo(this.applicationDirectory, new File(Application.getSdkDocsDir(), "appengine-application.xsd"));
                String applicationId = this.overrideAppId != null ? this.overrideAppId : earInfo.getAppengineApplicationXml().getApplicationId();
                for (WebModule webModule : earInfo.getWebModules()) {
                    String string = String.valueOf(webModule.getModuleName());
                    System.out.println(string.length() != 0 ? "Processing module ".concat(string) : new String("Processing module "));
                    resultBuilder.add(this.readWar(webModule.getApplicationDirectory().getAbsolutePath(), applicationId, null));
                    String contextRootWarning = "Ignoring application.xml context-root element, for details see https://developers.google.com/appengine/docs/java/modules/#config";
                    System.out.println(contextRootWarning);
                }
            } else {
                resultBuilder.add(this.readWar(this.applicationDirectory, this.overrideAppId, this.overrideModule));
            }
        }
        return resultBuilder.build();
    }

    private void validateApplications(Iterable<Application> applications, boolean isStaging) {
        for (Application application : applications) {
            if (isStaging) {
                application.validateForStaging();
                continue;
            }
            application.validate();
        }
    }

    private Application readWar(String warDirectory, String applicationIdOrNull, String moduleNameOrNull) throws IOException {
        Application application = Application.readApplication(warDirectory, applicationIdOrNull, moduleNameOrNull, this.overrideAppVersion);
        application.setListener(new UpdateListener(this){

            @Override
            public void onProgress(UpdateProgressEvent event) {
                int n = event.getPercentageComplete();
                String string = event.getMessage();
                System.out.println(new StringBuilder(13 + String.valueOf(string).length()).append(n).append("% ").append(string).toString());
            }

            @Override
            public void onSuccess(UpdateSuccessEvent event) {
                System.out.println("Operation complete.");
            }

            @Override
            public void onFailure(UpdateFailureEvent event) {
                System.out.println(event.getFailureMessage());
            }
        });
        return application;
    }

    private void newAdmin(AppAdminFactory factory, Application application, PrintWriter logWriter, boolean firstModule) {
        this.admin = factory.createAppAdmin(this.connectOptions, application, logWriter);
        Version localVersion = AppengineSdk.getSdk().getLocalVersion();
        String sdkVersion = String.format("Java/%s(%s)", localVersion.getRelease(), localVersion.getTimestamp());
        this.admin.getUpdateOptions().setSdkVersion(sdkVersion);
        this.admin.getUpdateOptions().setUpdateUsageReporting(this.updateUsageReporting);
        if (!firstModule) {
            this.admin.getUpdateOptions().setUpdateGlobalConfigurations(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAction(AppAdminFactory factory, Iterable<Application> applications, PrintWriter logWriter, AppCfgAction executeMe) {
        try {
            if (applications.iterator().hasNext()) {
                Application firstApplication = null;
                for (Application application : applications) {
                    if (firstApplication == null) {
                        firstApplication = application;
                    }
                    boolean doJsps = !application.getAppEngineWebXml().getUseVm() && !application.getAppEngineWebXml().isFlexible();
                    factory.setCompileJsps(doJsps);
                    this.newAdmin(factory, application, logWriter, application.equals(firstApplication));
                    this.moduleName = WebModule.getModuleName(application.getAppEngineWebXml());
                    try {
                        System.out.printf("%n%nBeginning interaction for module %s...%n", this.moduleName);
                        executeMe.execute();
                    }
                    finally {
                        this.moduleName = null;
                    }
                }
                if (this.autoUpdateDispatch && firstApplication.getDispatchXml() != null) {
                    this.newAdmin(factory, firstApplication, logWriter, true);
                    String dispatchXmlPath = new File(firstApplication.getPath(), "dispatch.xml").getCanonicalPath();
                    System.out.printf("%n%nBeginning update %s...%n", dispatchXmlPath);
                    this.admin.updateDispatch();
                }
            } else {
                this.admin = factory.createAppAdmin(this.connectOptions, null, logWriter);
                executeMe.execute();
            }
        }
        catch (AdminException | IOException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace(logWriter);
            this.printLogLocation();
            System.exit(1);
        }
        finally {
            this.admin = null;
        }
    }

    private void cleanStaging(Iterable<Application> applications) throws IOException {
        for (Application application : applications) {
            if (application == null) continue;
            String moduleName = WebModule.getModuleName(application.getAppEngineWebXml());
            if (!this.connectOptions.getRetainUploadDir()) {
                System.out.printf("Cleaning up temporary files for module %s...%n", moduleName);
                application.cleanStagingDirectory();
                continue;
            }
            File stage = application.getStagingDir();
            if (stage == null) {
                System.out.printf("Temporary staging directory was not needed, and not created for module %s%n", moduleName);
                continue;
            }
            System.out.printf("Temporary staging for module %s directory left in %s%n", moduleName, stage.getCanonicalPath());
        }
    }

    private void printLogLocation() {
        if (this.logFile != null) {
            String string = this.logFile.getAbsolutePath();
            System.out.println(new StringBuilder(47 + String.valueOf(string).length()).append("Please see the logs [").append(string).append("] for further information.").toString());
        }
    }

    private String loadCookies(final AppAdminFactory.ConnectOptions options) {
        Preferences prefs = Preferences.userNodeForPackage(ServerConnection.class);
        String prefsEmail = prefs.get("email", null);
        if (options.getUsePersistedCredentials() && prefsEmail != null) {
            ClientCookieManager cookies = null;
            byte[] serializedCookies = prefs.getByteArray("cookies", null);
            if (serializedCookies != null) {
                try {
                    cookies = (ClientCookieManager)new ObjectInputStream(new ByteArrayInputStream(serializedCookies)).readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (options.getUserId() == null || prefsEmail.equals(options.getUserId())) {
                options.setCookies(cookies);
            }
        }
        options.setPasswordPrompt(new AppAdminFactory.PasswordPrompt(){

            @Override
            public String getPassword() {
                AppCfg.this.doPrompt();
                options.setUserId(AppCfg.this.loginReader.getUsername());
                return AppCfg.this.loginReader.getPassword();
            }
        });
        return prefsEmail;
    }

    private void authorizeOauth2(AppAdminFactory.ConnectOptions options) {
        Credential credential = null;
        if (this.jsonKeyPath != null) {
            credential = this.getServiceAccountCredential(this.jsonKeyPath);
        } else if (this.useGoogleApplicationDefaultCredentials) {
            try {
                credential = GoogleCredential.getApplicationDefault().createScoped(Arrays.asList(OAuth2Native.OAUTH2_SCOPE));
                credential.refreshToken();
            }
            catch (IOException ex) {
                throw new RuntimeException("Cannot get Application Default Credentials.", ex);
            }
        } else {
            OAuth2Native client = new OAuth2Native(this.useCookies, this.oauth2ClientId, this.oauth2ClientSecret, this.oauth2RefreshToken);
            credential = client.authorize();
        }
        if (credential != null && credential.getAccessToken() != null) {
            options.setOauthToken(credential.getAccessToken());
        } else {
            System.exit(1);
        }
    }

    private Credential getServiceAccountCredential(String jsonKeyPath) {
        GoogleCredential googleCredential;
        FileInputStream jsonKey = new FileInputStream(jsonKeyPath);
        try {
            GoogleCredential credential = GoogleCredential.fromStream(jsonKey, new NetHttpTransport(), new JacksonFactory()).createScoped(Arrays.asList(OAuth2Native.OAUTH2_SCOPE));
            credential.refreshToken();
            googleCredential = credential;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jsonKey.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(String.format("JSON key file does not exist: %s", jsonKeyPath), e);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Could not read JSON key file: %s", jsonKeyPath), e);
            }
        }
        jsonKey.close();
        return googleCredential;
    }

    private void doPrompt() {
        if (this.disablePrompt) {
            System.out.println("Your authentication credentials can't be found and may have expired.\nPlease run appcfg directly from the command line to re-establish your credentials.");
            System.exit(1);
        }
        this.getLoginReader().doPrompt();
    }

    private LoginReader getLoginReader() {
        if (this.loginReader == null) {
            this.loginReader = LoginReaderFactory.createLoginReader(this.connectOptions, this.passin);
        }
        return this.loginReader;
    }

    private void printHelp() {
        if (this.helpText == null) {
            ArrayList<String> helpLines = new ArrayList<String>();
            helpLines.add("usage: AppCfg [options] <action> [<app-dir>] [<argument>]");
            helpLines.add("");
            helpLines.add("Action must be one of:");
            for (String actionName : this.actionsAndOptions.actionNames) {
                Action action = this.actionsAndOptions.getAction(actionName);
                if (action == null) continue;
                String string = action.getShortDescription();
                helpLines.add(new StringBuilder(4 + String.valueOf(actionName).length() + String.valueOf(string).length()).append("  ").append(actionName).append(": ").append(string).toString());
            }
            helpLines.add("Use 'help <action>' for a detailed description.");
            helpLines.add("");
            helpLines.add("options:");
            for (String optionName : this.actionsAndOptions.optionNames) {
                Option option = this.actionsAndOptions.getOption(optionName);
                helpLines.addAll(option.getHelpLines());
            }
            this.helpText = Joiner.on("\n").join(helpLines);
        }
        System.out.println(this.helpText);
        System.out.println();
    }

    private List<Option> builtInOptions(String ... optionNames) {
        if (this.builtInOptionMap == null) {
            this.builtInOptionMap = new HashMap<String, Option>(this.builtInOptions.size());
            for (Option option : this.builtInOptions) {
                this.builtInOptionMap.put(option.getLongName(), option);
            }
        }
        ArrayList<Option> options = new ArrayList<Option>();
        for (String name : optionNames) {
            Option option = this.builtInOptionMap.get(name);
            if (option == null) continue;
            options.add(option);
        }
        return options;
    }

    private ActionsAndOptions buildActionsAndOptions() {
        ActionsAndOptions actionsAndOptions = this.getBuiltInActionsAndOptions();
        return actionsAndOptions;
    }

    private ActionsAndOptions getBuiltInActionsAndOptions() {
        ActionsAndOptions actionsAndOptions = new ActionsAndOptions();
        actionsAndOptions.actions = this.builtInActions;
        actionsAndOptions.actionNames = actionNamesInHelpOrder;
        actionsAndOptions.options = this.builtInOptions;
        actionsAndOptions.optionNames = optionNamesInHelpOrder;
        actionsAndOptions.generalOptionNames = generalOptionNamesInHelpOrder;
        return actionsAndOptions;
    }

    private void validateApplicationDirectory(File war) {
        if (!war.exists()) {
            String string = String.valueOf(war);
            System.out.println(new StringBuilder(36 + String.valueOf(string).length()).append("Unable to find the webapp directory ").append(string).toString());
            this.printHelp();
            System.exit(1);
        } else if (!war.isDirectory()) {
            System.out.println("appcfg only accepts webapp directories, not war files.");
            this.printHelp();
            System.exit(1);
        }
    }

    private static class HostPort {
        private final String host;
        private final String port;

        public HostPort(String hostport) {
            int colon = hostport.indexOf(58);
            this.host = colon < 0 ? hostport : hostport.substring(0, colon);
            this.port = colon < 0 ? "" : hostport.substring(colon + 1);
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public boolean hasPort() {
            return this.port.length() > 0;
        }
    }

    private static class AppCfgVacuumIndexesListener
    extends AppCfgListener {
        AppCfgVacuumIndexesListener() {
            super("vacuum_indexes");
        }
    }

    private static class AppCfgUpdateBackendListener
    extends AppCfgListener {
        AppCfgUpdateBackendListener() {
            super("Update");
        }
    }

    private class AppCfgUpdateModuleListener
    extends AppCfgListener {
        AppCfgUpdateModuleListener() {
            super("Update");
        }

        @Override
        protected String getSuccessSummaryMessage() {
            String string = this.getOperationName();
            String string2 = AppCfg.this.moduleName;
            return new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" for module ").append(string2).append(" completed successfully.").toString();
        }
    }

    private static class AppCfgListener
    implements UpdateListener {
        private final String operationName;

        AppCfgListener(String opName) {
            this.operationName = opName;
        }

        @Override
        public void onProgress(UpdateProgressEvent event) {
            int n = event.getPercentageComplete();
            String string = event.getMessage();
            System.out.println(new StringBuilder(13 + String.valueOf(string).length()).append(n).append("% ").append(string).toString());
        }

        @Override
        public void onSuccess(UpdateSuccessEvent event) {
            String details = event.getDetails();
            if (details.length() > 0) {
                System.out.println();
                System.out.println("Details:");
                System.out.println(details);
            }
            System.out.println();
            System.out.println(this.getSuccessSummaryMessage());
        }

        @Override
        public void onFailure(UpdateFailureEvent event) {
            String details = event.getDetails();
            if (details.length() > 0) {
                System.out.println();
                System.out.println("Error Details:");
                System.out.println(details);
            }
            System.out.println();
            String failMsg = event.getFailureMessage();
            System.out.println(failMsg);
        }

        protected String getOperationName() {
            return this.operationName;
        }

        protected String getSuccessSummaryMessage() {
            return String.valueOf(this.getOperationName()).concat(" completed successfully.");
        }
    }

    class StagingAction
    extends AppCfgAction {
        private File stagingDir;
        private boolean useRemoteResourceLimits;

        StagingAction() {
            super(AppCfg.this.builtInOptions(new String[]{"enable_new_staging_defaults", "enable_jar_splitting", "use_remote_resource_limits", "quickstart", "jar_splitting_excludes", "retain_upload_dir", "compile_encoding", "disable_jar_jsps", "delete_jsps", "enable_jar_classes"}), "stage");
            this.useRemoteResourceLimits = false;
            this.shortDescription = "Generate a deploy-ready application directory";
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() != 2) {
                throw new IllegalArgumentException("Expected <app-dir> <staging-dir>");
            }
            this.stagingDir = new File(this.getArgs().get(1));
        }

        @Override
        public void execute() {
            AppCfg.this.connectOptions.setRetainUploadDir(true);
            if (this.useRemoteResourceLimits) {
                AppCfg.this.admin.stageApplicationWithRemoteResourceLimits(this.stagingDir);
            } else {
                AppCfg.this.admin.stageApplicationWithDefaultResourceLimits(this.stagingDir);
            }
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] stage <app-dir> <staging-dir>", "", "Generate a deploy-ready application directory");
        }

        @Override
        protected boolean requiresAuth() {
            return this.useRemoteResourceLimits;
        }
    }

    class MigrateTrafficAction
    extends AppCfgAction {
        MigrateTrafficAction() {
            super("migrate_traffic");
            this.shortDescription = "Change the default version, but more gently than set_default_version.";
        }

        @Override
        public void execute() {
            AppCfg.this.admin.migrateTraffic();
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] migrate_traffic <app-dir>", "", "Changes the default version, but more gently than set_default_version.");
        }
    }

    class StopModuleVersionAction
    extends AppCfgAction {
        StopModuleVersionAction() {
            super("stop_module_version");
            this.shortDescription = "Stop the specified module version.";
        }

        @Override
        public void execute() {
            AppCfg.this.admin.stopModuleVersion();
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] stop_module_version <app-dir>", "", "Stops the specified module version.");
        }
    }

    class StartModuleVersionAction
    extends AppCfgAction {
        StartModuleVersionAction() {
            super("start_module_version");
            this.shortDescription = "Start the specified module version.";
        }

        @Override
        public void execute() {
            AppCfg.this.admin.startModuleVersion();
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] start_module_version <app-dir>", "", "Starts the specified module version.");
        }
    }

    class BackendsAction
    extends AppCfgAction {
        private AppCfgAction subAction;

        BackendsAction() {
            super("backends");
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() < 2) {
                throw new IllegalArgumentException("Expected backends <app-dir> <sub-command> [...]");
            }
            String dir = this.getArgs().get(0);
            String subCommand = this.getArgs().get(1);
            this.subAction = (AppCfgAction)Parser.lookupAction(((AppCfg)AppCfg.this).actionsAndOptions.actions, new String[]{"backends", subCommand}, 0);
            if (this.subAction instanceof BackendsAction) {
                throw new IllegalArgumentException("Unknown backends subcommand.");
            }
            ArrayList<String> newArgs = new ArrayList<String>();
            newArgs.add(dir);
            newArgs.addAll(this.getArgs().subList(2, this.getArgs().size()));
            this.subAction.setArgs(newArgs);
            this.subAction.apply();
        }

        @Override
        public void execute() {
            this.outputBackendsMessage();
            this.subAction.execute();
        }

        @Override
        protected List<String> getHelpLines() {
            return ImmutableList.of("AppCfg [options] backends list: List the currently configured backends.", "AppCfg [options] backends update: Update the specified backend or all backends.", "AppCfg [options] backends rollback: Roll back a previously in-progress update.", "AppCfg [options] backends start: Start the specified backend.", "AppCfg [options] backends stop: Stop the specified backend.", "AppCfg [options] backends delete: Delete the specified backend.", "AppCfg [options] backends configure: Configure the specified backend.");
        }
    }

    class BackendsConfigureAction
    extends AppCfgAction {
        private String backendName;

        BackendsConfigureAction() {
            super("backends", "configure");
            this.shortDescription = "Configure the specified backend.";
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() != 2) {
                throw new IllegalArgumentException("Expected the backend name");
            }
            this.backendName = this.getArgs().get(1);
        }

        @Override
        public void execute() {
            this.outputBackendsMessage();
            AppCfg.this.admin.configureBackend(this.backendName);
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] backends configure <app-dir> <backend>", "", "Updates the configuration of the backend with the specified name, without", "stopping instances that are currently running.  Only valid for certain", "settings (instances, options: failfast, options: public).");
        }
    }

    class BackendsDeleteAction
    extends AppCfgAction {
        private String backendName;

        BackendsDeleteAction() {
            super("backends", "delete");
            this.shortDescription = "Delete the specified backend.";
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() != 2) {
                throw new IllegalArgumentException("Expected the backend name");
            }
            this.backendName = this.getArgs().get(1);
        }

        @Override
        public void execute() {
            this.outputBackendsMessage();
            AppCfg.this.admin.deleteBackend(this.backendName);
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] backends delete", "", "Deletes the specified backend.");
        }
    }

    class BackendsStopAction
    extends AppCfgAction {
        private String backendName;

        BackendsStopAction() {
            super("backends", "stop");
            this.shortDescription = "Stop the specified backend.";
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() != 2) {
                throw new IllegalArgumentException("Expected the backend name");
            }
            this.backendName = this.getArgs().get(1);
        }

        @Override
        public void execute() {
            this.outputBackendsMessage();
            AppCfg.this.admin.setBackendState(this.backendName, BackendsXml.State.STOP);
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] backends stop <app-dir> <backend>", "", "Stops the backend with the specified name.");
        }
    }

    class BackendsStartAction
    extends AppCfgAction {
        private String backendName;

        BackendsStartAction() {
            super("backends", "start");
            this.shortDescription = "Start the specified backend.";
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() != 2) {
                throw new IllegalArgumentException("Expected the backend name");
            }
            this.backendName = this.getArgs().get(1);
        }

        @Override
        public void execute() {
            this.outputBackendsMessage();
            AppCfg.this.admin.setBackendState(this.backendName, BackendsXml.State.START);
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] backends start <app-dir> <backend>", "", "Starts the backend with the specified name.");
        }
    }

    class BackendsUpdateAction
    extends AppCfgAction {
        private String backendName;

        BackendsUpdateAction() {
            super(AppCfg.this.builtInOptions(new String[]{"enable_new_staging_defaults", "enable_jar_splitting", "jar_splitting_excludes", "retain_upload_dir", "compile_encoding", "disable_jar_jsps", "delete_jsps", "enable_jar_classes"}), "backends", "update");
            this.shortDescription = "Update the specified backend or all backends.";
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() < 1 || this.getArgs().size() > 2) {
                throw new IllegalArgumentException("Expected <app-dir> [<backend-name>]");
            }
            if (this.getArgs().size() == 2) {
                this.backendName = this.getArgs().get(1);
            }
        }

        @Override
        public void execute() {
            this.outputBackendsMessage();
            if (this.backendName != null) {
                AppCfg.this.admin.updateBackend(this.backendName, new AppCfgUpdateBackendListener());
            } else {
                AppCfg.this.admin.updateAllBackends(new AppCfgUpdateBackendListener());
            }
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] backends update <app-dir> [<backend-name>]", "", "Update the specified backend or all backends.");
        }
    }

    class BackendsRollbackAction
    extends AppCfgAction {
        private String backendName;

        BackendsRollbackAction() {
            super("backends", "rollback");
            this.shortDescription = "Roll back a previously in-progress update.";
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() < 1 || this.getArgs().size() > 2) {
                throw new IllegalArgumentException("Expected <app-dir> [<backend-name>]");
            }
            if (this.getArgs().size() == 2) {
                this.backendName = this.getArgs().get(1);
            }
        }

        @Override
        public void execute() {
            this.outputBackendsMessage();
            if (this.backendName != null) {
                AppCfg.this.admin.rollbackBackend(this.backendName);
            } else {
                AppCfg.this.admin.rollbackAllBackends();
            }
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] backends rollback <app-dir> [<backend-name>]", "", "The 'backends update' command requires a server-side transaction.", "Use 'backends rollback' if you experience an error during 'backends update'", "and want to begin a new update transaction.");
        }
    }

    class BackendsListAction
    extends AppCfgAction {
        BackendsListAction() {
            super("backends", "list");
            this.shortDescription = "List the currently configured backends.";
        }

        @Override
        public void execute() {
            this.outputBackendsMessage();
            for (BackendsXml.Entry backend : AppCfg.this.admin.listBackends()) {
                System.out.println(backend);
            }
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] backends list <app-dir>", "", "List the currently configured backends.");
        }
    }

    class DebugAction
    extends AppCfgAction {
        DebugAction() {
            super("debug");
            this.shortDescription = "Debug a vm runtime application.";
        }

        @Override
        public void execute() {
            String debugResponse = AppCfg.this.admin.debugVersion();
            System.out.println(debugResponse);
            boolean done = false;
            int retries = 0;
            int nextSleep = 1000;
            int maxSleep = 6000;
            try {
                while (!done && retries < 20) {
                    Map yaml = (Map)new YamlReader(AppCfg.this.admin.debugVersionState()).read();
                    String message = (String)yaml.get("message");
                    System.out.println(message);
                    String state = (String)yaml.get("state");
                    done = !state.equals("PENDING");
                    if (done) continue;
                    try {
                        Thread.sleep(nextSleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++retries;
                    if ((nextSleep *= 2) <= maxSleep) continue;
                    nextSleep = maxSleep;
                }
            }
            catch (YamlException ex) {
                String string = String.valueOf(ex.toString());
                System.out.println(string.length() != 0 ? "Error waiting for debug request status: ".concat(string) : new String("Error waiting for debug request status: "));
            }
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] -A app_id -V version [-M module] debug <app_dir>", "", "Configures a vm runtime version to be accessible for debugging.");
        }
    }

    class DeleteVersionAction
    extends AppCfgAction {
        DeleteVersionAction() {
            super("delete_version");
            this.shortDescription = "Delete the specified version.";
        }

        @Override
        public void execute() {
            if (AppCfg.this.overrideAppVersion == null) {
                throw new IllegalArgumentException("You must specify a version ID via -V or --version");
            }
            String response = AppCfg.this.admin.deleteVersion(AppCfg.this.overrideAppId, AppCfg.this.overrideModule, AppCfg.this.overrideAppVersion);
            System.out.println(response);
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] delete_version <app-dir> -V version [-M module]", "", "Deletes the specified version.");
        }
    }

    class ListVersionsAction
    extends AppCfgAction {
        ListVersionsAction() {
            super("list_versions");
            this.shortDescription = "List the currently uploaded versions.";
        }

        @Override
        public void execute() {
            String response = AppCfg.this.admin.listVersions();
            YamlReader yaml = new YamlReader(new StringReader(response));
            try {
                Object obj = yaml.read();
                if (obj != null) {
                    Map responseMap = (Map)obj;
                    if (!responseMap.isEmpty()) {
                        System.out.println(response);
                    } else {
                        System.out.println("No versions uploaded for application.");
                    }
                    return;
                }
            }
            catch (YamlException yamlException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            System.out.println("There was a problem retrieving the list of versions.");
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] list_versions <app-dir>", "", "List the currently configured versions.");
        }
    }

    class ResourceLimitsInfoAction
    extends AppCfgAction {
        public ResourceLimitsInfoAction() {
            super("resource_limits_info");
            this.shortDescription = "Display resource limits.";
        }

        @Override
        public void execute() {
            ResourceLimits resourceLimits = AppCfg.this.admin.getResourceLimits();
            for (String key : new TreeSet<String>(resourceLimits.keySet())) {
                long l = resourceLimits.get(key);
                System.out.println(new StringBuilder(22 + String.valueOf(key).length()).append(key).append(": ").append(l).toString());
            }
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] resource_limits_info <app-dir>", "", "Displays the resource limits available to the app. An app will", "not update if any of the app's resources are larger than the", "appropriate resource limit.");
        }
    }

    class SetDefaultVersionAction
    extends AppCfgAction {
        SetDefaultVersionAction() {
            super("set_default_version");
            this.shortDescription = "Set the default serving version.";
        }

        @Override
        public void execute() {
            AppCfg.this.admin.setDefaultVersion();
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] set_default_version <app-dir>", "", "Sets the default (serving) version of the app. Defaults to using", "the application, version and module specified in your app directory.", "Use the --application, --version and --module flags to override these", "values. The --module flag can also be a comma-delimited string of", "several modules. (ex. module1,module2,module3) In this case, the default", "version of each module will be changed to the version specified.");
        }
    }

    class VersionAction
    extends AppCfgAction {
        VersionAction(AppCfg this$0) {
            super("version");
            this.shortDescription = "Prints version information.";
        }

        @Override
        public void apply() {
            System.out.println(SupportInfo.getVersionString());
            System.exit(0);
        }

        @Override
        public void execute() {
        }

        @Override
        protected List<String> getHelpLines() {
            return ImmutableList.of("AppCfg version", "", "Prints version information.");
        }
    }

    class DownloadAppAction
    extends AppCfgAction {
        DownloadAppAction() {
            super("download_app");
            this.shortDescription = "Download a previously uploaded app version.";
        }

        @Override
        public void apply() {
            if (this.getArgs().size() != 1) {
                throw new IllegalArgumentException("Expected download directory as an argument after download_app.");
            }
            File downloadDir = new File(this.getArgs().get(0));
            if (AppCfg.this.overrideAppId == null) {
                throw new IllegalArgumentException("You must specify an app ID via -A or --application");
            }
            if (AppCfg.this.oauth2) {
                AppCfg.this.authorizeOauth2(AppCfg.this.connectOptions);
            } else {
                AppCfg.this.loadCookies(AppCfg.this.connectOptions);
            }
            AppDownload appDownload = new AppDownload(ServerConnectionFactory.getServerConnection(AppCfg.this.connectOptions), new AppCfgListener("download_app"));
            int exitCode = appDownload.download(AppCfg.this.overrideAppId, AppCfg.this.overrideModule, AppCfg.this.overrideAppVersion, downloadDir) ? 0 : 1;
            System.exit(exitCode);
        }

        @Override
        public void execute() {
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] -A app_id [ -M module ] [ -V version ] download_app <out-dir>", "", "Download a previously-uploaded app to the specified directory.  The app", "ID is specified by the \"-A\" option.  The optional module is specified by the \"-M\" ", "option and the optional version is specified by the \"-V\" option.");
        }
    }

    class HelpAction
    extends AppCfgAction {
        HelpAction() {
            super("help");
            this.shortDescription = "Print help for a specific action.";
        }

        @Override
        public void apply() {
            if (this.getArgs().isEmpty()) {
                AppCfg.this.printHelp();
            } else {
                Action foundAction = Parser.lookupAction(((AppCfg)AppCfg.this).actionsAndOptions.actions, this.getArgs().toArray(new String[0]), 0);
                if (foundAction == null) {
                    String string = this.getArgs().get(0);
                    System.out.println(new StringBuilder(20 + String.valueOf(string).length()).append("No such command \"").append(string).append("\"\n\n").toString());
                    AppCfg.this.printHelp();
                } else {
                    System.out.println(foundAction.getHelpString());
                    System.out.println();
                }
            }
            System.exit(1);
        }

        @Override
        public void execute() {
        }

        @Override
        protected List<String> getHelpLines() {
            return ImmutableList.of("AppCfg help <command>", "", "Prints help about a specific command.", "");
        }
    }

    class VacuumIndexesAction
    extends AppCfgAction {
        public boolean promptUserForEachDelete;

        VacuumIndexesAction() {
            super(AppCfg.this.builtInOptions(new String[]{"force"}), "vacuum_indexes");
            this.promptUserForEachDelete = true;
            this.shortDescription = "Delete unused indexes from application.";
        }

        @Override
        public void execute() {
            ConfirmationCallback<IndexDeleter.DeleteIndexAction> callback = null;
            if (this.promptUserForEachDelete) {
                callback = new ConfirmationCallback<IndexDeleter.DeleteIndexAction>(this){

                    @Override
                    public ConfirmationCallback.Response confirmAction(IndexDeleter.DeleteIndexAction action) {
                        String response;
                        do {
                            String string = action.getPrompt();
                            String prompt = new StringBuilder(11 + String.valueOf(string).length()).append("\n").append(string).append(" (N/y/a): ").toString();
                            System.out.print(prompt);
                            System.out.flush();
                            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                            try {
                                response = in.readLine();
                            }
                            catch (IOException ioe) {
                                response = null;
                            }
                            String string2 = response = null == response ? "" : response.trim().toLowerCase();
                            if ("y".equals(response)) {
                                return ConfirmationCallback.Response.YES;
                            }
                            if (!"n".equals(response) && !response.isEmpty()) continue;
                            return ConfirmationCallback.Response.NO;
                        } while (!"a".equals(response));
                        return ConfirmationCallback.Response.YES_ALL;
                    }
                };
            }
            AppCfg.this.admin.vacuumIndexes(callback, new AppCfgVacuumIndexesListener());
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] vacuum_indexes <app-dir>", "", "Deletes indexes on the server that are not present in the local", "index configuration file.  The user is prompted before each delete.");
        }
    }

    class CronInfoAction
    extends AppCfgAction {
        int numRuns;

        CronInfoAction() {
            super(AppCfg.this.builtInOptions(new String[]{"num_runs"}), "cron_info");
            this.numRuns = 5;
            this.shortDescription = "Displays times for the next several runs of each cron job.";
        }

        @Override
        public void execute() {
            List<CronEntry> entries = AppCfg.this.admin.cronInfo();
            if (entries.isEmpty()) {
                System.out.println("No cron jobs defined.");
            } else {
                int n = entries.size();
                System.out.println(new StringBuilder(34).append(n).append(" cron entries defined.\n").toString());
                for (CronEntry entry : entries) {
                    System.out.println(entry.toXml());
                    int n2 = this.numRuns;
                    System.out.println(new StringBuilder(33).append("Next ").append(n2).append(" execution times:").toString());
                    Iterator<String> iter = entry.getNextTimesIterator();
                    for (int i = 0; i < this.numRuns; ++i) {
                        String string = String.valueOf(iter.next());
                        System.out.println(string.length() != 0 ? "  ".concat(string) : new String("  "));
                    }
                    System.out.println("");
                }
            }
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] cron_info <app-dir>", "", "Displays times for the next several runs of each cron job.");
        }

        public void setNumRuns(String numberString) {
            try {
                this.numRuns = Integer.parseInt(numberString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("num_runs must be an integral number.");
            }
            if (this.numRuns < 0) {
                throw new IllegalArgumentException("num_runs must be positive.");
            }
        }
    }

    class UpdateQueueAction
    extends AppCfgAction {
        UpdateQueueAction() {
            super("update_queues");
            this.shortDescription = "Update application task queue definitions.";
        }

        @Override
        public void execute() {
            AppCfg.this.admin.updateQueues();
        }

        @Override
        protected List<String> getInitialHelpLines() {
            String string = this.getNameString();
            return ImmutableList.of(new StringBuilder(27 + String.valueOf(string).length()).append("AppCfg [options] ").append(string).append(" <app-dir>").toString(), "", "Updates any new, removed or changed task queue definitions.", "Does not otherwise alter the running application version.");
        }
    }

    class UpdateDosAction
    extends AppCfgAction {
        UpdateDosAction() {
            super("update_dos");
            this.shortDescription = "Update application DoS protection configuration.";
        }

        @Override
        public void execute() {
            AppCfg.this.admin.updateDos();
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] update_dos <app-dir>", "", "Updates the DoS protection configuration for the application.", "Does not otherwise alter the running application version.");
        }
    }

    class UpdateDispatchAction
    extends AppCfgAction {
        UpdateDispatchAction() {
            super("update_dispatch");
            this.shortDescription = "Update the application dispatch configuration.";
        }

        @Override
        public void execute() {
            AppCfg.this.admin.updateDispatch();
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] update_dispatch <app-dir>", "", "Updates the application dispatch configuration.", "Does not otherwise alter the running application version.");
        }
    }

    class UpdateCronAction
    extends AppCfgAction {
        UpdateCronAction() {
            super("update_cron");
            this.shortDescription = "Update application cron jobs.";
        }

        @Override
        public void execute() {
            AppCfg.this.admin.updateCron();
            this.shortDescription = "Update application cron jobs.";
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] update_cron <app-dir>", "", "Updates the cron jobs for the application. Updates any new, removed or changed", "cron jobs. Does not otherwise alter the running application version.");
        }
    }

    class UpdateIndexesAction
    extends AppCfgAction {
        UpdateIndexesAction() {
            super("update_indexes");
            this.shortDescription = "Update application indexes.";
        }

        @Override
        public void execute() {
            AppCfg.this.admin.updateIndexes();
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] update_indexes <app-dir>", "", "Updates the datastore indexes for the server to add any in the current", "application directory.  Does not alter the running application version, nor", "remove any existing indexes.");
        }
    }

    class RollbackAction
    extends AppCfgAction {
        RollbackAction() {
            super("rollback");
            this.shortDescription = "Rollback an in-progress update.";
        }

        @Override
        public void execute() {
            AppCfg.this.admin.rollback();
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] rollback <app-dir>", "", "The 'update' command requires a server-side transaction.", "Use 'rollback' if you experience an error during 'update'", "and want to begin a new update transaction.");
        }
    }

    class RequestLogsAction
    extends AppCfgAction {
        String outputFile;
        int numDays;
        int severity;
        boolean includeAll;
        boolean append;

        RequestLogsAction() {
            super(AppCfg.this.builtInOptions(new String[]{"num_days", "severity", "include_all", "append"}), "request_logs");
            this.numDays = 1;
            this.severity = -1;
            this.includeAll = false;
            this.append = false;
            this.shortDescription = "Write request logs in Apache common log format.";
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() != 2) {
                throw new IllegalArgumentException("Expected the application directory and log file as arguments after the request_logs action name.");
            }
            this.outputFile = this.getArgs().get(1);
        }

        @Override
        public void execute() {
            Reader reader = AppCfg.this.admin.requestLogs(this.numDays, this.severity >= 0 ? AppAdmin.LogSeverity.values()[this.severity] : null, this.includeAll);
            if (reader == null) {
                return;
            }
            BufferedReader r = new BufferedReader(reader);
            PrintWriter writer = null;
            try {
                writer = this.outputFile.equals("-") ? new PrintWriter(System.out) : new PrintWriter(new FileWriter(this.outputFile, this.append));
                String line = null;
                while ((line = r.readLine()) != null) {
                    writer.println(line);
                }
            }
            catch (IOException e) {
                String string = String.valueOf(e);
                throw new RuntimeException(new StringBuilder(21 + String.valueOf(string).length()).append("Failed to read logs: ").append(string).toString());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] request_logs <app-dir> <output-file>", "", "Populates the output-file with recent logs from the application.");
        }
    }

    class UpdateAction
    extends AppCfgAction {
        UpdateAction() {
            super(AppCfg.this.builtInOptions(new String[]{"enable_new_staging_defaults", "enable_jar_splitting", "jar_splitting_excludes", "retain_upload_dir", "compile_encoding", "disable_jar_jsps", "delete_jsps", "enable_jar_classes"}), "update");
            this.shortDescription = "Create or update an app version.";
        }

        @Override
        public void execute() {
            AppCfg.this.admin.update(new AppCfgUpdateModuleListener());
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] update <app-dir>", "", "Installs a new version of the application onto the server, or", "updates an existing version.  Does not change the default", "(serving) version.");
        }

        @Override
        protected boolean isEarAction() {
            return true;
        }
    }

    abstract class AppCfgAction
    extends Action {
        AppCfgAction(String ... names) {
            this((List<Option>)null, names);
        }

        AppCfgAction(List<Option> options, String ... names) {
            super(options, names);
        }

        @Override
        protected void setArgs(List<String> args) {
            super.setArgs(args);
        }

        @Override
        public void apply() {
            if (this.getArgs().size() < 1) {
                throw new IllegalArgumentException("Expected the application directory as an argument after the action name.");
            }
            AppCfg.this.applicationDirectory = this.getArgs().get(0);
            AppCfg.this.validateCommandLineForEar();
        }

        public abstract void execute();

        @Override
        protected List<String> getHelpLines() {
            ArrayList<String> helpLines = new ArrayList<String>();
            helpLines.addAll(this.getInitialHelpLines());
            helpLines.add("");
            helpLines.add("Options:");
            for (String optionName : ((AppCfg)AppCfg.this).actionsAndOptions.generalOptionNames) {
                Option option = AppCfg.this.actionsAndOptions.getOption(optionName);
                if (option == null) continue;
                helpLines.addAll(option.getHelpLines());
            }
            if (this.extraOptions != null) {
                for (Option option : this.extraOptions) {
                    helpLines.addAll(option.getHelpLines());
                }
            }
            return helpLines;
        }

        protected List<String> getInitialHelpLines() {
            return ImmutableList.of();
        }

        protected boolean isEarAction() {
            return false;
        }

        protected boolean requiresAuth() {
            return true;
        }

        protected void outputBackendsMessage() {
            System.out.println("Warning: This application uses Backends, a deprecated feature that has been replaced by Modules, which offers additional functionality. Please convert your backends to modules as described at: https://developers.google.com/appengine/docs/java/modules/converting.");
        }
    }
}

