/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.glob;

import com.google.apphosting.utils.glob.AbstractGlob;
import com.google.apphosting.utils.glob.ConflictResolver;
import com.google.apphosting.utils.glob.Glob;
import com.google.apphosting.utils.glob.LeafGlob;
import java.util.HashSet;
import java.util.Set;

class BranchGlob
extends AbstractGlob {
    private final Set<Glob> children = new HashSet<Glob>();

    BranchGlob(String pattern) {
        super(pattern);
    }

    public void addChild(Glob child) {
        if (child instanceof LeafGlob) {
            this.children.add(child);
        } else {
            BranchGlob branch = (BranchGlob)child;
            for (Glob realChild : branch.getChildren()) {
                this.children.add(realChild);
            }
        }
    }

    public Set<Glob> getChildren() {
        return this.children;
    }

    @Override
    public Object getProperty(String propertyName, ConflictResolver resolver) {
        return resolver.chooseValue(propertyName, this.children);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof BranchGlob) {
            BranchGlob glob = (BranchGlob)object;
            return super.equals(glob) && this.children.equals(glob.children);
        }
        return false;
    }

    @Override
    public String toString() {
        String string = this.pattern;
        String string2 = String.valueOf(this.children);
        return new StringBuilder(String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).toString();
    }
}

