/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend.system;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.flogger.LogSite;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LogData;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LogMessageFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.backend.MessageUtils;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Metadata;
import com.google.appengine.repackaged.com.google.common.flogger.backend.SimpleMessageFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.util.Checks;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public abstract class AbstractLogRecord
extends LogRecord {
    private static final Formatter jdkMessageFormatter = new Formatter(){

        @Override
        public String format(LogRecord record) {
            throw new UnsupportedOperationException();
        }
    };
    private static final Object[] NO_PARAMETERS = new Object[0];
    private final LogData data;
    private final Metadata scope;

    protected AbstractLogRecord(LogData data, Metadata scope) {
        super(data.getLevel(), null);
        this.data = data;
        this.scope = Checks.checkNotNull(scope, "scope");
        LogSite logSite = data.getLogSite();
        this.setSourceClassName(logSite.getClassName());
        this.setSourceMethodName(logSite.getMethodName());
        this.setLoggerName(data.getLoggerName());
        this.setMillis(TimeUnit.NANOSECONDS.toMillis(data.getTimestampNanos()));
        super.setParameters(NO_PARAMETERS);
    }

    protected AbstractLogRecord(RuntimeException error, LogData data, Metadata scope) {
        this(data, scope);
        this.setLevel(data.getLevel().intValue() < Level.WARNING.intValue() ? Level.WARNING : data.getLevel());
        this.setThrown(error);
        StringBuilder errorMsg = new StringBuilder("LOGGING ERROR: ").append(error.getMessage()).append('\n');
        AbstractLogRecord.safeAppend(data, errorMsg);
        this.setMessage(errorMsg.toString());
    }

    protected LogMessageFormatter getLogMessageFormatter() {
        return SimpleMessageFormatter.getDefaultFormatter();
    }

    @Override
    public final void setParameters(Object[] parameters) {
        this.getMessage();
        if (parameters == null) {
            parameters = NO_PARAMETERS;
        }
        super.setParameters(parameters);
    }

    @Override
    public final void setMessage(String message) {
        if (message == null) {
            message = "";
        }
        super.setMessage(message);
    }

    @Override
    public final String getMessage() {
        String cachedMessage = super.getMessage();
        if (cachedMessage != null) {
            return cachedMessage;
        }
        String formattedMessage = this.getLogMessageFormatter().format(this.data, this.scope);
        super.setMessage(formattedMessage);
        return formattedMessage;
    }

    public final StringBuilder appendFormattedMessageTo(StringBuilder buffer) {
        String cachedMessage = super.getMessage();
        if (cachedMessage == null) {
            this.getLogMessageFormatter().append(this.data, this.scope, buffer);
        } else if (this.getParameters().length == 0) {
            buffer.append(cachedMessage);
        } else {
            buffer.append(jdkMessageFormatter.formatMessage(this));
        }
        return buffer;
    }

    public final String getFormattedMessage() {
        if (this.getParameters().length == 0) {
            return this.getMessage();
        }
        return jdkMessageFormatter.formatMessage(this);
    }

    @Override
    public final void setResourceBundle(ResourceBundle bundle) {
    }

    @Override
    public final void setResourceBundleName(String name) {
    }

    @GoogleInternal
    public final LogRecord toMutableLogRecord() {
        LogRecord copy = new LogRecord(this.getLevel(), this.getMessage());
        copy.setParameters(NO_PARAMETERS);
        copy.setSourceClassName(this.getSourceClassName());
        copy.setSourceMethodName(this.getSourceMethodName());
        copy.setLoggerName(this.getLoggerName());
        copy.setMillis(this.getMillis());
        copy.setThrown(this.getThrown());
        copy.setThreadID(this.getThreadID());
        return copy;
    }

    public final LogData getLogData() {
        return this.data;
    }

    public final Metadata getScope() {
        return this.scope;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.getClass().getSimpleName()).append(" {\n  message: ").append(this.getMessage()).append("\n  arguments: ").append(this.getParameters() != null ? Arrays.asList(this.getParameters()) : "<none>").append('\n');
        AbstractLogRecord.safeAppend(this.getLogData(), out);
        out.append("\n}");
        return out.toString();
    }

    private static void safeAppend(LogData data, StringBuilder out) {
        out.append("  original message: ");
        if (data.getTemplateContext() == null) {
            out.append(MessageUtils.safeToString(data.getLiteralArgument()));
        } else {
            out.append(data.getTemplateContext().getMessage());
            out.append("\n  original arguments:");
            for (Object arg : data.getArguments()) {
                out.append("\n    ").append(MessageUtils.safeToString(arg));
            }
        }
        Metadata metadata = data.getMetadata();
        if (metadata.size() > 0) {
            out.append("\n  metadata:");
            for (int n = 0; n < metadata.size(); ++n) {
                out.append("\n    ").append(metadata.getKey(n).getLabel()).append(": ").append(MessageUtils.safeToString(metadata.getValue(n)));
            }
        }
        out.append("\n  level: ").append(MessageUtils.safeToString(data.getLevel()));
        out.append("\n  timestamp (nanos): ").append(data.getTimestampNanos());
        out.append("\n  class: ").append(data.getLogSite().getClassName());
        out.append("\n  method: ").append(data.getLogSite().getMethodName());
        out.append("\n  line number: ").append(data.getLogSite().getLineNumber());
    }
}

