/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.WebXml;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class WebXmlReader
extends AbstractConfigXmlReader<WebXml> {
    private static final String[] DEFAULT_WELCOME_FILES = new String[]{"index.html", "index.jsp"};
    public static final String DEFAULT_RELATIVE_FILENAME = "WEB-INF/web.xml";
    private final String relativeFilename;
    private String servletVersion;

    public WebXmlReader(String appDir, String relativeFilename) {
        super(appDir, true);
        this.relativeFilename = relativeFilename;
    }

    public WebXmlReader(String appDir, String relativeFilename, boolean isRequired) {
        super(appDir, isRequired);
        this.relativeFilename = relativeFilename;
    }

    public WebXmlReader(String appDir, boolean isRequired) {
        this(appDir, DEFAULT_RELATIVE_FILENAME, isRequired);
    }

    public WebXmlReader(String appDir) {
        this(appDir, DEFAULT_RELATIVE_FILENAME, true);
    }

    @Override
    protected String getRelativeFilename() {
        return this.relativeFilename;
    }

    public WebXml readWebXml() {
        WebXml value = (WebXml)this.readConfigXml();
        if (value == null) {
            value = new WebXml();
            value.setServletVersion("3.1");
            for (String welcomeFile : DEFAULT_WELCOME_FILES) {
                value.addWelcomeFile(welcomeFile);
            }
        }
        return value;
    }

    public String getServletVersion() {
        return this.servletVersion;
    }

    @Override
    protected WebXml processXml(InputStream is) {
        WebXml webXml = new WebXml();
        Element root = XmlUtils.parseXml(is).getDocumentElement();
        this.parseWebXml(root, webXml);
        if (webXml.getWelcomeFiles().isEmpty()) {
            for (String welcomeFile : DEFAULT_WELCOME_FILES) {
                webXml.addWelcomeFile(welcomeFile);
            }
        }
        return webXml;
    }

    private void parseWebXml(Element webAppElement, WebXml webXml) {
        if (!webAppElement.getTagName().equals("web-app")) {
            String string = WebXmlReader.sanitizeTag(webAppElement.getTagName());
            throw this.appEngineConfigException(new StringBuilder(40 + String.valueOf(string).length()).append("Root element should be <web-app>, not <").append(string).append(">").toString());
        }
        this.servletVersion = XmlUtils.getAttributeOrNull(webAppElement, "version");
        webXml.setServletVersion(this.servletVersion);
        for (Element childElement : XmlUtils.getChildren(webAppElement)) {
            switch (childElement.getTagName()) {
                case "servlet-mapping": 
                case "filter-mapping": {
                    this.parseServletOrFilterMapping(childElement, webXml);
                    break;
                }
                case "filter": {
                    this.parseFilter(childElement, webXml);
                    break;
                }
                case "security-constraint": {
                    this.parseSecurityConstraint(childElement, webXml);
                    break;
                }
                case "mime-mapping": {
                    this.parseMimeMapping(childElement, webXml);
                    break;
                }
                case "error-page": {
                    this.parseErrorPage(childElement, webXml);
                    break;
                }
                case "welcome-file-list": {
                    this.parseWelcomeFileList(childElement, webXml);
                    break;
                }
                case "context-param": {
                    this.parseContextParam(childElement, webXml);
                    break;
                }
            }
        }
    }

    private boolean isServletVersionThreeOrHigher() {
        float servletVersionFloat = 0.0f;
        try {
            servletVersionFloat = Float.parseFloat(this.servletVersion);
        }
        catch (Exception e) {
            return false;
        }
        return (double)servletVersionFloat >= 3.0;
    }

    private void parseServletOrFilterMapping(Element mappingElement, WebXml webXml) {
        for (Element patternElement : XmlUtils.getChildren(mappingElement, "url-pattern")) {
            String id = XmlUtils.getAttributeOrNull(patternElement, "id");
            if (this.isServletVersionThreeOrHigher() && XmlUtils.getText(patternElement).isEmpty()) {
                webXml.addServletPattern("", id);
                continue;
            }
            webXml.addServletPattern(this.stringContents(patternElement), id);
        }
    }

    private void parseSecurityConstraint(Element constraintElement, WebXml webXml) {
        WebXml.SecurityConstraint securityConstraint = webXml.addSecurityConstraint();
        block10: for (Element child : XmlUtils.getChildren(constraintElement)) {
            switch (child.getTagName()) {
                case "web-resource-collection": {
                    for (Element patternElement : XmlUtils.getChildren(child, "url-pattern")) {
                        securityConstraint.addUrlPattern(this.stringContents(patternElement));
                    }
                    continue block10;
                }
                case "auth-constraint": {
                    Optional<String> role = this.getOptionalChildContents(child, "role-name");
                    if (!role.isPresent()) break;
                    securityConstraint.setRequiredRole(this.parseRequiredRole(role.get()));
                    break;
                }
                case "user-data-constraint": {
                    Optional<String> guarantee = this.getOptionalChildContents(child, "transport-guarantee");
                    if (!guarantee.isPresent()) break;
                    securityConstraint.setTransportGuarantee(this.parseTransportGuarantee(guarantee.get()));
                    break;
                }
            }
        }
    }

    private void parseMimeMapping(Element mimeMappingElement, WebXml webXml) {
        String extension = this.getRequiredChildContents(mimeMappingElement, "extension");
        String mimeType = this.getRequiredChildContents(mimeMappingElement, "mime-type");
        webXml.addMimeMapping(extension, mimeType);
    }

    private void parseContextParam(Element contextParamElement, WebXml webXml) {
        if (!this.isServletVersionThreeOrHigher()) {
            return;
        }
        String name = this.getRequiredChildContents(contextParamElement, "param-name");
        String value = this.getRequiredChildContentsWithCData(contextParamElement, "param-value");
        webXml.addContextParam(name, value);
    }

    private void parseFilter(Element childElement, WebXml webXml) {
        if (!this.isServletVersionThreeOrHigher()) {
            return;
        }
        Optional<String> filterClass = this.getOptionalChildContents(childElement, "filter-class");
        if (filterClass.isPresent()) {
            webXml.addFilterClass(filterClass.get());
        }
    }

    private void parseErrorPage(Element errorPageElement, WebXml webXml) {
        Optional<String> errorCode = this.getOptionalChildContents(errorPageElement, "error-code");
        if ("404".equals(errorCode.orElse(null))) {
            webXml.setFallThroughToRuntime(true);
        }
    }

    private void parseWelcomeFileList(Element welcomesElement, WebXml webXml) {
        for (String welcomeFile : this.getAllChildContents(welcomesElement, "welcome-file")) {
            webXml.addWelcomeFile(welcomeFile);
        }
    }

    private WebXml.SecurityConstraint.RequiredRole parseRequiredRole(String role) {
        switch (role) {
            case "*": {
                return WebXml.SecurityConstraint.RequiredRole.ANY_USER;
            }
            case "admin": {
                return WebXml.SecurityConstraint.RequiredRole.ADMIN;
            }
        }
        throw this.appEngineConfigException("Unknown role-name: must be '*' or 'admin'");
    }

    private WebXml.SecurityConstraint.TransportGuarantee parseTransportGuarantee(String transportGuarantee) {
        if ("NONE".equalsIgnoreCase(transportGuarantee)) {
            return WebXml.SecurityConstraint.TransportGuarantee.NONE;
        }
        if ("INTEGRAL".equalsIgnoreCase(transportGuarantee)) {
            return WebXml.SecurityConstraint.TransportGuarantee.INTEGRAL;
        }
        if ("CONFIDENTIAL".equalsIgnoreCase(transportGuarantee)) {
            return WebXml.SecurityConstraint.TransportGuarantee.CONFIDENTIAL;
        }
        throw this.appEngineConfigException("Unknown transport-guarantee: must be NONE, INTEGRAL, or CONFIDENTIAL.");
    }

    private ImmutableList<String> getAllChildContents(Element parent, String childTagName) {
        ImmutableList.Builder children = ImmutableList.builder();
        List<Element> childElements = XmlUtils.getChildren(parent, childTagName);
        for (Element childElement : childElements) {
            children.add(this.stringContents(childElement));
        }
        return children.build();
    }

    private ImmutableList<String> getAllChildContentsWithCData(Element parent, String childTagName) {
        ImmutableList.Builder children = ImmutableList.builder();
        for (Element element : XmlUtils.getChildren(parent, "param-value")) {
            Node child;
            String value = element.getTextContent();
            if (value == null && element.hasChildNodes() && (child = element.getFirstChild()) instanceof Text) {
                value = ((Text)child).getTextContent();
            }
            if (value == null) {
                throw this.appEngineConfigException("param-value is missing");
            }
            children.add(value);
        }
        return children.build();
    }

    private Optional<String> getOptionalChildContents(Element parent, String childTagName) {
        ImmutableList<String> children = this.getAllChildContents(parent, childTagName);
        switch (children.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of((String)children.get(0));
            }
        }
        String string = WebXmlReader.sanitizeTag(parent.getTagName());
        String string2 = WebXmlReader.sanitizeTag(childTagName);
        String string3 = String.valueOf(children);
        throw this.appEngineConfigException(new StringBuilder(25 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("<").append(string).append("> has more than one <").append(string2).append(">: ").append(string3).toString());
    }

    private Optional<String> getOptionalChildContentsWithCData(Element parent, String childTagName) {
        ImmutableList<String> children = this.getAllChildContentsWithCData(parent, childTagName);
        switch (children.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of((String)children.get(0));
            }
        }
        String string = WebXmlReader.sanitizeTag(parent.getTagName());
        String string2 = WebXmlReader.sanitizeTag(childTagName);
        String string3 = String.valueOf(children);
        throw this.appEngineConfigException(new StringBuilder(25 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("<").append(string).append("> has more than one <").append(string2).append(">: ").append(string3).toString());
    }

    private String getRequiredChildContents(Element parent, String childTagName) {
        Optional<String> contents = this.getOptionalChildContents(parent, childTagName);
        if (!contents.isPresent()) {
            String string = WebXmlReader.sanitizeTag(parent.getTagName());
            String string2 = WebXmlReader.sanitizeTag(childTagName);
            throw this.appEngineConfigException(new StringBuilder(16 + String.valueOf(string).length() + String.valueOf(string2).length()).append("<").append(string).append("> is missing <").append(string2).append(">").toString());
        }
        return contents.get();
    }

    private String getRequiredChildContentsWithCData(Element parent, String childTagName) {
        Optional<String> contents = this.getOptionalChildContentsWithCData(parent, childTagName);
        if (!contents.isPresent()) {
            String string = WebXmlReader.sanitizeTag(parent.getTagName());
            String string2 = WebXmlReader.sanitizeTag(childTagName);
            throw this.appEngineConfigException(new StringBuilder(16 + String.valueOf(string).length() + String.valueOf(string2).length()).append("<").append(string).append("> is missing <").append(string2).append(">").toString());
        }
        return contents.get();
    }

    private AppEngineConfigException appEngineConfigException(String message) {
        String string = this.getFilename();
        return new AppEngineConfigException(new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(message).length()).append(string).append(": ").append(message).toString());
    }
}

