/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.labs.command;

import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Verify;
import com.google.appengine.repackaged.com.google.common.base.VerifyException;
import com.google.appengine.repackaged.com.google.common.labs.command.CapturingOutputStream;
import com.google.appengine.repackaged.com.google.common.labs.command.Command;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandFailureException;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandFuture;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandResult;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandStartException;
import com.google.appengine.repackaged.com.google.common.labs.command.ForwardingOutputStream;
import com.google.appengine.repackaged.com.google.common.labs.command.InputSource;
import com.google.appengine.repackaged.com.google.common.labs.command.Opener;
import com.google.appengine.repackaged.com.google.common.labs.command.OutputSink;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public abstract class CommandProcess {
    private final Command command;
    private final CapturingOutputStream stdoutStream = new CapturingOutputStream();
    private final CapturingOutputStream stderrStream = new CapturingOutputStream();
    private volatile CommandResult result = null;

    protected CommandProcess(Command command, StreamConsumer streamConsumer) throws CommandStartException {
        this.command = Preconditions.checkNotNull(command);
        Opener<InputStream> stdinSourceOpener = new Opener<InputStream>(command.stdinSource()::openStream);
        Opener<OutputStream> stdoutSinkOpener = new Opener<OutputStream>(() -> {
            switch (command.stdoutSink().kind()) {
                case PROCESS_OUT: {
                    return this.stdoutStream;
                }
                case PROCESS_ERR: {
                    return this.stderrStream;
                }
            }
            return command.stdoutSink().openStream();
        });
        Opener<OutputStream> stderrSinkOpener = new Opener<OutputStream>(() -> {
            switch (command.stderrSink().kind()) {
                case PROCESS_OUT: {
                    return this.stdoutStream;
                }
                case PROCESS_ERR: {
                    return this.stderrStream;
                }
            }
            return command.stderrSink().openStream();
        });
        try {
            if (!command.stdinSource().kind().equals((Object)InputSource.Kind.PROCESS)) {
                streamConsumer.acceptStdinSourceStream(stdinSourceOpener);
            }
            streamConsumer.acceptStdoutSinkStream(stdoutSinkOpener);
            if (command.stdoutSink().kind().equals((Object)OutputSink.Kind.PROCESS_OUT) || command.stdoutSink().kind().equals((Object)OutputSink.Kind.PROCESS_ERR)) {
                Verify.verify(stdoutSinkOpener.opened());
            }
            streamConsumer.acceptStderrSinkStream(stderrSinkOpener);
            if ((command.stderrSink().kind().equals((Object)OutputSink.Kind.PROCESS_OUT) || command.stderrSink().kind().equals((Object)OutputSink.Kind.PROCESS_ERR)) && !command.stdoutSink().equals(command.stderrSink())) {
                Verify.verify(stderrSinkOpener.opened());
            }
        }
        catch (IOException e) {
            throw new CommandStartException(command, e);
        }
    }

    public final Command command() {
        return this.command;
    }

    public ListenableFuture<CommandResult> asFuture() {
        return new CommandFuture(this);
    }

    public final boolean isAlive() {
        return this.isAliveHook();
    }

    @CanIgnoreReturnValue
    public final CommandResult await() throws CommandFailureException, InterruptedException {
        this.awaitHook();
        return this.processFinished();
    }

    @CanIgnoreReturnValue
    public final CommandResult await(Duration timeout) throws CommandFailureException, InterruptedException, TimeoutException {
        if (this.awaitHook(timeout)) {
            return this.processFinished();
        }
        throw new TimeoutException(String.format("%s did not complete after %s", this.command, timeout));
    }

    @CanIgnoreReturnValue
    public final CommandResult awaitUninterruptibly() throws CommandFailureException {
        boolean interrupted = false;
        while (true) {
            try {
                CommandResult commandResult = this.await();
                return commandResult;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @CanIgnoreReturnValue
    public final <E extends Exception> CommandResult awaitChecked(Function<Exception, E> factory) throws E {
        try {
            return this.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (Exception)factory.apply(e);
        }
        catch (CommandFailureException e) {
            throw (Exception)factory.apply(e);
        }
    }

    public final CommandResult getDone() throws CommandFailureException {
        Preconditions.checkState(!this.isAlive(), "Process %s is still alive - use await() to wait for the process to complete.", (Object)this);
        return this.processFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandResult processFinished() throws CommandFailureException {
        if (this.result == null) {
            CommandProcess commandProcess = this;
            synchronized (commandProcess) {
                if (this.result == null) {
                    int exitCode = this.exitCodeFromFinishedProcess();
                    this.result = new CommandResult(exitCode, this.stdoutStream, this.stderrStream);
                }
            }
        }
        if (this.command.successCondition().test(this.result)) {
            return this.result;
        }
        throw new CommandFailureException(this.command, this.result);
    }

    @CanIgnoreReturnValue
    public final CommandProcess kill() {
        this.killHook();
        return this;
    }

    @CanIgnoreReturnValue
    public final CommandProcess killForcibly() {
        this.killForciblyHook();
        return this;
    }

    public final OutputStream stdinStream() {
        return new ForwardingOutputStream(this, this.maybeGetStdinStream()){};
    }

    public final Writer stdinWriter(Charset cs) {
        return new OutputStreamWriter(this.maybeGetStdinStream(), cs);
    }

    public final Writer stdinWriterUtf8() {
        return this.stdinWriter(StandardCharsets.UTF_8);
    }

    public final InputStream stdoutStream() {
        return this.maybeGetStdoutStream().openInputStream();
    }

    public final InputStream stderrStream() {
        return this.maybeGetStderrStream().openInputStream();
    }

    public final Reader stdoutReader(Charset cs) {
        return new InputStreamReader(this.stdoutStream(), cs);
    }

    public final Reader stderrReader(Charset cs) {
        return new InputStreamReader(this.stderrStream(), cs);
    }

    public final Reader stdoutReaderUtf8() {
        return this.stdoutReader(StandardCharsets.UTF_8);
    }

    public final Reader stderrReaderUtf8() {
        return this.stderrReader(StandardCharsets.UTF_8);
    }

    private OutputStream maybeGetStdinStream() {
        Preconditions.checkState(this.command.stdinSource().kind().equals((Object)InputSource.Kind.PROCESS), "The process is reading stdin from %s, there is no stdin stream", (Object)this.command.stdinSource());
        return this.stdinStreamHook();
    }

    private CapturingOutputStream maybeGetStdoutStream() {
        Preconditions.checkState(this.command.stdoutSink().kind().equals((Object)OutputSink.Kind.PROCESS_OUT) || this.command.stderrSink().kind().equals((Object)OutputSink.Kind.PROCESS_OUT), "The process is writing stdout to %s and stderr to %s, there is no stdout stream", (Object)this.command.stdoutSink(), (Object)this.command.stderrSink());
        return this.stdoutStream;
    }

    private CapturingOutputStream maybeGetStderrStream() {
        Preconditions.checkState(this.command.stdoutSink().kind().equals((Object)OutputSink.Kind.PROCESS_ERR) || this.command.stderrSink().kind().equals((Object)OutputSink.Kind.PROCESS_ERR), "The process is writing stdout to %s and stderr to %s, there is no stderr stream", (Object)this.command.stdoutSink(), (Object)this.command.stderrSink());
        return this.stderrStream;
    }

    public final long processId() {
        return this.processIdHook();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final String toString() {
        return MoreObjects.toStringHelper(this).add("command", this.command).add("alive", this.isAlive()).toString();
    }

    private int exitCodeFromFinishedProcess() {
        Verify.verify(!this.isAliveHook());
        try {
            return this.awaitHook();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new VerifyException("await() should not trigger an interrupt on finished processes", e);
        }
    }

    protected abstract boolean isAliveHook();

    @CanIgnoreReturnValue
    protected abstract int awaitHook() throws InterruptedException;

    protected abstract boolean awaitHook(Duration var1) throws InterruptedException;

    protected abstract void killHook();

    protected abstract void killForciblyHook();

    protected abstract long processIdHook();

    protected abstract OutputStream stdinStreamHook();

    protected static interface StreamConsumer {
        public void acceptStdinSourceStream(Opener<InputStream> var1) throws IOException;

        public void acceptStdoutSinkStream(Opener<OutputStream> var1) throws IOException;

        public void acceptStderrSinkStream(Opener<OutputStream> var1) throws IOException;
    }
}

