/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.flogger.AbstractLogger;
import com.google.appengine.repackaged.com.google.common.flogger.GoogleLoggingApi;
import com.google.appengine.repackaged.com.google.common.flogger.LogContext;
import com.google.appengine.repackaged.com.google.common.flogger.LogSiteKey;
import com.google.appengine.repackaged.com.google.common.flogger.LoggingScope;
import com.google.appengine.repackaged.com.google.common.flogger.LoggingScopeProvider;
import com.google.appengine.repackaged.com.google.common.flogger.StackSize;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Metadata;
import com.google.appengine.repackaged.com.google.common.flogger.parser.DefaultPrintfMessageParser;
import com.google.appengine.repackaged.com.google.common.flogger.parser.MessageParser;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@CheckReturnValue
public abstract class GoogleLogContext<LOGGER extends AbstractLogger<API>, API extends GoogleLoggingApi<API>>
extends LogContext<LOGGER, API>
implements GoogleLoggingApi<API> {
    static final String EYE3_TAG_INTERNED_LABEL = "eye3tag";

    protected GoogleLogContext(Level level, boolean isForced) {
        super(level, isForced);
    }

    @Override
    protected final MessageParser getMessageParser() {
        return DefaultPrintfMessageParser.getInstance();
    }

    @Override
    @GoogleInternal
    public API per(LoggingScopeProvider scopeProvider) {
        LoggingScope scope = scopeProvider.getCurrentScope();
        if (scope != null) {
            this.addMetadata(LogContext.Key.LOG_SITE_GROUPING_KEY, scope);
        }
        return (API)((GoogleLoggingApi)this.api());
    }

    @Override
    protected boolean postProcess(@NullableDecl LogSiteKey logSiteKey) {
        Metadata metadata = this.getMetadata();
        int size = metadata.size();
        for (int n = 0; n < size; ++n) {
            if (metadata.getKey(n).getLabel() != EYE3_TAG_INTERNED_LABEL) continue;
            if (metadata.findValue(LogContext.Key.LOG_CAUSE) != null || metadata.findValue(LogContext.Key.CONTEXT_STACK_SIZE) != null) break;
            this.addMetadata(LogContext.Key.CONTEXT_STACK_SIZE, StackSize.SMALL);
            break;
        }
        return super.postProcess(logSiteKey);
    }
}

