/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.labs.command;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.flogger.GoogleLogger;
import com.google.appengine.repackaged.com.google.common.time.Sleeper;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.IntConsumer;
import javax.annotation.concurrent.GuardedBy;

final class ProcessPoller {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/appengine/repackaged/com/google/common/labs/command/ProcessPoller");
    private static final Executor EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("process-poller-%d").build());
    private static final Duration POLLING_INTERVAL = Duration.ofMillis(100L);
    @GuardedBy(value="this")
    private final Set<Entry> pending = new HashSet<Entry>();

    ProcessPoller() {
    }

    synchronized void add(Process process, IntConsumer exitCodeObserver) {
        if (this.pending.isEmpty()) {
            EXECUTOR.execute(this::pollUntilComplete);
        }
        this.pending.add(new Entry(process, exitCodeObserver));
    }

    private void pollUntilComplete() {
        block4: {
            try {
                while (!this.checkComplete()) {
                    Sleeper.defaultSleeper().sleep(POLLING_INTERVAL);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).withInjectedLogSite("com/google/appengine/repackaged/com/google/common/labs/command/ProcessPoller", "pollUntilComplete", 51, "ProcessPoller.java")).log("Polling thread interrupted.");
                this.cancelAllPending();
            }
            catch (Throwable t) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(t)).withInjectedLogSite("com/google/appengine/repackaged/com/google/common/labs/command/ProcessPoller", "pollUntilComplete", 55, "ProcessPoller.java")).log("Unexpected exception killed polling thread, all pending futures cancelled.");
                this.cancelAllPending();
                if (!(t instanceof Error)) break block4;
                throw t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkComplete() {
        ImmutableList<Entry> local;
        ProcessPoller processPoller = this;
        synchronized (processPoller) {
            local = ImmutableList.copyOf(this.pending);
        }
        ArrayList<Entry> finished = new ArrayList<Entry>();
        for (Entry e : local) {
            if (e.process.isAlive()) continue;
            e.exitCodeConsumer.accept(e.process.exitValue());
            finished.add(e);
        }
        ProcessPoller processPoller2 = this;
        synchronized (processPoller2) {
            this.pending.removeAll(finished);
            return this.pending.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllPending() {
        ImmutableList<Entry> local;
        ProcessPoller processPoller = this;
        synchronized (processPoller) {
            local = ImmutableList.copyOf(this.pending);
            this.pending.clear();
        }
        for (Entry e : local) {
            e.process.destroyForcibly();
            e.exitCodeConsumer.accept(-1);
        }
    }

    private static class Entry {
        private final Process process;
        private final IntConsumer exitCodeConsumer;

        private Entry(Process process, IntConsumer exitCodeConsumer) {
            this.process = Preconditions.checkNotNull(process);
            this.exitCodeConsumer = Preconditions.checkNotNull(exitCodeConsumer);
        }
    }
}

