/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.labs.command;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.labs.command.Command;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandFailureException;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandResult;
import com.google.appengine.repackaged.com.google.common.time.Durations;
import com.google.appengine.repackaged.com.google.common.util.concurrent.AbstractFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Futures;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Monitor;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.concurrent.GuardedBy;
import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class AtomicResult {
    private final Command command;
    private final Runnable kill;
    private final Monitor monitor = new Monitor();
    @GuardedBy(value="monitor")
    private CommandResult result;
    @GuardedBy(value="monitor")
    private boolean failed;
    @GuardedBy(value="monitor")
    private final Set<ResultFuture> futures = new HashSet<ResultFuture>();
    private final Monitor.Guard processComplete = new Monitor.Guard(this.monitor){

        @Override
        public boolean isSatisfied() {
            return AtomicResult.this.result != null;
        }
    };

    AtomicResult(Command command, Runnable kill) {
        this.command = Preconditions.checkNotNull(command);
        this.kill = Preconditions.checkNotNull(kill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void complete(CommandResult result) {
        HashSet<ResultFuture> futuresCopy;
        Preconditions.checkNotNull(result, "result");
        CommandFailureException ex = null;
        this.monitor.enter();
        try {
            Preconditions.checkState(this.result == null, "result already set");
            this.result = result;
            boolean bl = this.failed = !this.command.successCondition().test(result);
            if (this.failed) {
                ex = new CommandFailureException(this.command, result);
            }
            futuresCopy = new HashSet<ResultFuture>(this.futures);
            this.futures.clear();
        }
        finally {
            this.monitor.leave();
        }
        if (ex == null) {
            for (ResultFuture future : futuresCopy) {
                future.set(result);
            }
        } else {
            for (ResultFuture future : futuresCopy) {
                future.setException(ex);
            }
        }
    }

    boolean isComplete() {
        this.monitor.enter();
        try {
            boolean bl = this.result != null;
            return bl;
        }
        finally {
            this.monitor.leave();
        }
    }

    Optional<CommandResult> get() throws CommandFailureException {
        this.monitor.enter();
        try {
            Optional<CommandResult> optional = Optional.ofNullable(this.getOrThrow());
            return optional;
        }
        finally {
            this.monitor.leave();
        }
    }

    CommandResult await() throws InterruptedException, CommandFailureException {
        this.monitor.enterWhen(this.processComplete);
        try {
            CommandResult commandResult = this.getOrThrow();
            return commandResult;
        }
        finally {
            this.monitor.leave();
        }
    }

    CommandResult await(Duration timeout) throws InterruptedException, CommandFailureException, TimeoutException {
        if (this.monitor.enterWhen(this.processComplete, Durations.toNanosSaturated(timeout), TimeUnit.NANOSECONDS)) {
            try {
                CommandResult commandResult = this.getOrThrow();
                return commandResult;
            }
            finally {
                this.monitor.leave();
            }
        }
        throw new TimeoutException(String.format("%s did not complete after %s", this.command, timeout));
    }

    ListenableFuture<CommandResult> future() {
        this.monitor.enter();
        try {
            if (this.failed) {
                ListenableFuture<CommandResult> listenableFuture = Futures.immediateFailedFuture(new CommandFailureException(this.command, this.result));
                return listenableFuture;
            }
            if (this.result != null) {
                ListenableFuture<CommandResult> listenableFuture = Futures.immediateFuture(this.result);
                return listenableFuture;
            }
            ResultFuture future = new ResultFuture();
            this.futures.add(future);
            ResultFuture resultFuture = future;
            return resultFuture;
        }
        finally {
            this.monitor.leave();
        }
    }

    @GuardedBy(value="monitor")
    private CommandResult getOrThrow() throws CommandFailureException {
        if (this.failed) {
            throw new CommandFailureException(this.command, this.result);
        }
        return this.result;
    }

    private class ResultFuture
    extends AbstractFuture<CommandResult> {
        private ResultFuture() {
        }

        @Override
        @CanIgnoreReturnValue
        protected boolean set(CommandResult result) {
            return super.set(result);
        }

        @Override
        @CanIgnoreReturnValue
        protected boolean setException(Throwable ex) {
            return super.setException(ex);
        }

        @Override
        protected void afterDone() {
            if (this.wasInterrupted()) {
                AtomicResult.this.kill.run();
            }
        }
    }
}

