/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import com.google.appengine.repackaged.com.google.common.labs.command.Command;
import com.google.appengine.tools.admin.AutoValue_RepoInfo_SourceContext;
import com.google.appengine.tools.admin.Utility;
import com.google.auto.value.AutoValue;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

final class RepoInfo {
    private static final Logger logger = Logger.getLogger(RepoInfo.class.getName());
    private static final String REMOTE_URL_PATTERN = "remote\\.(.*)\\.url";
    private final GitClient git;
    private static final Pattern REMOTE_URL_RE = Pattern.compile("remote\\.(.*)\\.url");

    RepoInfo(File baseDir) {
        this(new GitCommandClient(baseDir));
    }

    RepoInfo(GitClient git) {
        this.git = git;
    }

    @Nullable
    SourceContext getSourceContext() {
        Multimap<String, String> remoteUrls;
        String revision = null;
        try {
            revision = this.getGitHeadRevision();
            remoteUrls = this.getGitRemoteUrls();
            if (remoteUrls.isEmpty()) {
                logger.logp(Level.FINE, "com.google.appengine.tools.admin.RepoInfo", "getSourceContext", "Local git repo has no remote URLs");
                return SourceContext.createLocal(revision);
            }
        }
        catch (GitException e) {
            logger.logp(Level.FINE, "com.google.appengine.tools.admin.RepoInfo", "getSourceContext", "not a git repository or problem calling git");
            return revision == null ? null : SourceContext.createLocal(revision);
        }
        SourceContext bestReturn = null;
        SourceContext.RemoteType bestRemote = null;
        for (Map.Entry<String, String> remoteUrl : remoteUrls.entries()) {
            int compareResult;
            SourceContext candidate = SourceContext.createFromUrl(remoteUrl.getValue(), revision);
            if (bestRemote != null && ((compareResult = candidate.getRemoteType().compareTo(bestRemote)) < 0 || compareResult == 0 && !remoteUrl.getKey().equals("origin"))) continue;
            bestRemote = candidate.getRemoteType();
            bestReturn = candidate;
        }
        return bestReturn;
    }

    private String getGitRemoteUrlConfigs() throws GitException {
        return this.git.callGit("config", "--get-regexp", REMOTE_URL_PATTERN);
    }

    private Multimap<String, String> getGitRemoteUrls() throws GitException {
        String[] configLines;
        String remoteUrlConfigOutput = this.getGitRemoteUrlConfigs();
        if (remoteUrlConfigOutput.isEmpty()) {
            return ImmutableMultimap.of();
        }
        ImmutableMultimap.Builder<String, String> result = ImmutableMultimap.builder();
        for (String configLine : configLines = remoteUrlConfigOutput.split("\\r?\\n")) {
            if (configLine.isEmpty()) continue;
            String[] parts = configLine.split(" +");
            if (parts.length != 2) {
                logger.logp(Level.FINE, "com.google.appengine.tools.admin.RepoInfo", "getGitRemoteUrls", String.format("Skipping unexpected git config line, incorrect segments: %s", configLine));
                continue;
            }
            String remoteUrlConfigName = parts[0];
            String remoteUrl = parts[1];
            Matcher matcher = REMOTE_URL_RE.matcher(remoteUrlConfigName);
            if (!matcher.matches()) {
                logger.logp(Level.FINE, "com.google.appengine.tools.admin.RepoInfo", "getGitRemoteUrls", String.format("Skipping unexpected git config line, could not match remote: %s", configLine));
                continue;
            }
            String remoteUrlName = matcher.group(1);
            result.put(remoteUrlName, remoteUrl);
        }
        logger.logp(Level.FINE, "com.google.appengine.tools.admin.RepoInfo", "getGitRemoteUrls", String.format("Remote git URLs: %s", result.toString()));
        return result.build();
    }

    private String getGitHeadRevision() throws GitException {
        String head = this.git.callGit("rev-parse", "HEAD").trim();
        if (head.isEmpty()) {
            throw new GitException("Empty head revision returned by git");
        }
        return head;
    }

    private static final class GitCommandClient
    implements GitClient {
        private final File baseDir;

        GitCommandClient(File baseDir) {
            this.baseDir = baseDir;
        }

        @Override
        public String callGit(String ... args) throws GitException {
            return Command.command(Utility.isOsWindows() ? "git.exe" : "git", args).withWorkingDirectory(this.baseDir.toPath()).executeChecked(GitException::new).stdoutStringUtf8();
        }
    }

    static interface GitClient {
        public String callGit(String ... var1) throws GitException;
    }

    static final class GitException
    extends Exception {
        GitException(String message) {
            super(message);
        }

        GitException(Throwable cause) {
            super(cause);
        }

        GitException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @AutoValue
    static abstract class SourceContext {
        private static final Pattern CLOUD_REPO_RE = Pattern.compile("^https://(?<hostname>[^/]*)/(?<idtype>p|id)/(?<projectOrRepoId>[^/?#]+)(/r/(?<repoName>[^/?#]+))?([/#?].*)?");
        private static final Pattern SSH_PROTOCOL_SHORT_FORM_RE = Pattern.compile("^\\w+@");
        private static final Pattern SSH_PROTOCOL_RE = Pattern.compile("^ssh://");
        private static final Pattern GITHUB_RE = Pattern.compile("\\w:[^/]*github\\.com[/:]");
        private static final Pattern BITBUCKET_RE = Pattern.compile("\\w:[^/]*bitbucket\\.org[/:]");

        SourceContext() {
        }

        @Nullable
        abstract String getRepositoryUrl();

        abstract String getRevisionId();

        @Nullable
        abstract String getJson();

        @Nullable
        abstract String getProjectId();

        @Nullable
        abstract String getRepoId();

        @Nullable
        abstract String getRepoName();

        abstract RemoteType getRemoteType();

        boolean isCloudRepo() {
            return this.getRepoId() != null || this.getProjectId() != null;
        }

        static SourceContext createLocal(String revisionId) {
            return new AutoValue_RepoInfo_SourceContext(null, revisionId, null, null, null, null, RemoteType.OTHER);
        }

        static SourceContext createFromUrl(@Nullable String repoUrl, String revisionId) {
            if (repoUrl == null) {
                return SourceContext.createLocal(revisionId);
            }
            Matcher match = CLOUD_REPO_RE.matcher(repoUrl);
            if (match.matches()) {
                String projectId;
                String idType = match.group("idtype");
                if ("id".equals(idType)) {
                    String rawRepoId = match.group("projectOrRepoId");
                    if (!Strings.isNullOrEmpty(rawRepoId) && Strings.isNullOrEmpty(match.group("repoName"))) {
                        return SourceContext.createFromRepoId(repoUrl, revisionId, rawRepoId);
                    }
                } else if ("p".equals(idType) && !Strings.isNullOrEmpty(projectId = match.group("projectOrRepoId"))) {
                    String repoName = match.group("repoName");
                    if (Strings.isNullOrEmpty(repoName)) {
                        repoName = "default";
                    }
                    return SourceContext.createFromRepoName(repoUrl, revisionId, projectId, repoName);
                }
            }
            return SourceContext.createGit(repoUrl, revisionId);
        }

        static SourceContext createFromRepoId(String repoUrl, String revisionId, String repoId) {
            String json = String.format("{\"cloudRepo\": {\"repoId\": {\"uid\": \"%s\"}, \"revisionId\": \"%s\"}}", Utility.jsonEscape(repoId), Utility.jsonEscape(revisionId));
            return new AutoValue_RepoInfo_SourceContext(repoUrl, revisionId, json, null, repoId, null, RemoteType.CLOUD_REPO);
        }

        static SourceContext createFromRepoName(String repoUrl, String revisionId, String projectId, String repoName) {
            String jsonRepoId = String.format("{\"projectRepoId\": {\"projectId\": \"%s\", \"repoName\": \"%s\"}}", Utility.jsonEscape(projectId), Utility.jsonEscape(repoName));
            String json = String.format("{\"cloudRepo\": {\"repoId\": %s, \"revisionId\": \"%s\"}}", jsonRepoId, Utility.jsonEscape(revisionId));
            return new AutoValue_RepoInfo_SourceContext(repoUrl, revisionId, json, projectId, null, repoName, RemoteType.CLOUD_REPO);
        }

        static SourceContext createGit(String repoUrl, String revisionId) {
            boolean isSsh = false;
            if (SSH_PROTOCOL_SHORT_FORM_RE.matcher(repoUrl).find() || SSH_PROTOCOL_RE.matcher(repoUrl).find()) {
                isSsh = true;
            }
            RemoteType remoteType = GITHUB_RE.matcher(repoUrl).find() || BITBUCKET_RE.matcher(repoUrl).find() ? (isSsh ? RemoteType.GIT_KNOWN_HOST_SSH : RemoteType.GIT_KNOWN_HOST) : RemoteType.GIT_UNKNOWN;
            String json = String.format("{\"git\": {\"url\": \"%s\", \"revisionId\": \"%s\"}}", Utility.jsonEscape(repoUrl), Utility.jsonEscape(revisionId));
            return new AutoValue_RepoInfo_SourceContext(repoUrl, revisionId, json, null, null, null, remoteType);
        }

        static enum RemoteType {
            OTHER,
            GIT_UNKNOWN,
            GIT_KNOWN_HOST_SSH,
            GIT_KNOWN_HOST,
            CLOUD_REPO;

        }
    }
}

