/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AdminException;
import com.google.appengine.tools.admin.AppAdmin;
import com.google.appengine.tools.admin.ApplicationProcessingOptions;
import com.google.appengine.tools.admin.GenericApplication;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;

public class AppAdminImpl
implements AppAdmin {
    private final GenericApplication app;
    private final PrintWriter errorWriter;
    private final ApplicationProcessingOptions appOptions;

    protected AppAdminImpl(GenericApplication app, PrintWriter errorWriter, ApplicationProcessingOptions appOptions) {
        this.app = app;
        this.errorWriter = errorWriter;
        this.appOptions = appOptions;
    }

    @Override
    public void stageApplicationWithDefaultResourceLimits(File stagingDir) {
        this.stageApplication(stagingDir, false);
    }

    @Override
    public void stageApplicationWithRemoteResourceLimits(File stagingDir) {
        this.stageApplication(stagingDir, true);
    }

    void stageApplication(File stagingDir, boolean useRemoteResourceLimits) {
        if (stagingDir == null) {
            throw new AdminException("Staging dir is not a valid directory (it is null)");
        }
        if (stagingDir.exists()) {
            if (!stagingDir.isDirectory()) {
                throw new AdminException(String.valueOf(stagingDir.getPath()).concat(" is not a valid staging directory (it is a regular file)"));
            }
            Path path = stagingDir.toPath();
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(path);){
                if (dirStream.iterator().hasNext()) {
                    throw new AdminException(String.valueOf(stagingDir.getPath()).concat(" is not a valid staging directory (it is not empty)"));
                }
            }
            catch (IOException e) {
                throw new AdminException("Unable to stage application.", e);
            }
        }
        try {
            this.app.createStagingDirectory(this.appOptions, stagingDir);
            this.app.resetProgress();
            this.app.setDetailsWriter(new PrintWriter(System.out, true));
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to stage:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to stage app: ".concat(string) : new String("Unable to stage app: "), t);
        }
    }
}

