/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.DosXml;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.InputStream;
import org.w3c.dom.Element;

public class DosXmlReader
extends AbstractConfigXmlReader<DosXml> {
    private static final String FILENAME = "WEB-INF/dos.xml";
    private static final String DENYLISTENTRIES_TAG = "blacklistentries";
    private static final String DENYLIST_TAG = "blacklist";
    private static final String DESCRIPTION_TAG = "description";
    private static final String SUBNET_TAG = "subnet";

    public DosXmlReader(String appDir) {
        super(appDir, false);
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }

    public DosXml readDosXml() {
        return (DosXml)this.readConfigXml();
    }

    @Override
    protected DosXml processXml(InputStream is) {
        DosXml dosXml = new DosXml();
        Element root = XmlUtils.parseXml(is).getDocumentElement();
        if (!root.getTagName().equals(DENYLISTENTRIES_TAG)) {
            String string = this.getFilename();
            throw new AppEngineConfigException(new StringBuilder(36 + String.valueOf(string).length()).append(string).append(" does not contain <").append(DENYLISTENTRIES_TAG).append(">").toString());
        }
        for (Element child : XmlUtils.getChildren(root)) {
            if (child.getTagName().equals(DENYLIST_TAG)) {
                this.parseDenylist(child, dosXml.addNewBlacklistEntry());
                continue;
            }
            String string = this.getFilename();
            String string2 = child.getTagName();
            throw new AppEngineConfigException(new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" contains <").append(string2).append("> instead of <").append(DENYLIST_TAG).append("/>").toString());
        }
        dosXml.validateLastEntry();
        return dosXml;
    }

    private void parseDenylist(Element denylistElement, DosXml.BlacklistEntry denylistEntry) {
        block8: for (Element child : XmlUtils.getChildren(denylistElement)) {
            switch (child.getTagName()) {
                case "description": {
                    denylistEntry.setDescription(this.stringContents(child));
                    continue block8;
                }
                case "subnet": {
                    denylistEntry.setSubnet(this.stringContents(child));
                    continue block8;
                }
            }
            String string = this.getFilename();
            String string2 = child.getTagName();
            throw new AppEngineConfigException(new StringBuilder(40 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" contains unknown <").append(string2).append("> inside <").append(DENYLIST_TAG).append("/>").toString());
        }
    }
}

