/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtils {
    static String getText(Element node) throws AppEngineConfigException {
        String content = node.getTextContent();
        if (content == null) {
            return "";
        }
        return content.trim();
    }

    static Document parseXml(InputStream inputStream) {
        return XmlUtils.parseXml(inputStream, null);
    }

    public static Document parseXml(InputStream inputStream, String filename) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputStream);
            doc.getDocumentElement().normalize();
            return doc;
        }
        catch (IOException e) {
            String string = String.valueOf(XmlUtils.maybeFilename(filename));
            String msg = string.length() != 0 ? "Received IOException parsing the input stream".concat(string) : new String("Received IOException parsing the input stream");
            throw new AppEngineConfigException(msg, e);
        }
        catch (SAXException e) {
            String string = String.valueOf(XmlUtils.maybeFilename(filename));
            String msg = string.length() != 0 ? "Received SAXException parsing the input stream".concat(string) : new String("Received SAXException parsing the input stream");
            throw new AppEngineConfigException(msg, e);
        }
        catch (ParserConfigurationException e) {
            String string = String.valueOf(XmlUtils.maybeFilename(filename));
            String msg = string.length() != 0 ? "Received ParserConfigurationException parsing the input stream".concat(string) : new String("Received ParserConfigurationException parsing the input stream");
            throw new AppEngineConfigException(msg, e);
        }
    }

    private static String maybeFilename(String filename) {
        if (filename == null) {
            return ".";
        }
        String string = String.valueOf(filename);
        return string.length() != 0 ? " for ".concat(string) : new String(" for ");
    }

    public static void validateXml(String xmlFilename, File schema) {
        Path xml = Paths.get(xmlFilename, new String[0]);
        if (!Files.exists(xml, new LinkOption[0])) {
            String string = String.valueOf(xml);
            throw new AppEngineConfigException(new StringBuilder(26 + String.valueOf(string).length()).append("Xml file: ").append(string).append(" does not exist.").toString());
        }
        if (!schema.exists()) {
            String string = schema.getPath();
            throw new AppEngineConfigException(new StringBuilder(29 + String.valueOf(string).length()).append("Schema file: ").append(string).append(" does not exist.").toString());
        }
        try {
            XmlUtils.validateXmlContent(new String(Files.readAllBytes(xml), StandardCharsets.UTF_8), schema);
        }
        catch (IOException ex) {
            String string = schema.getPath();
            throw new AppEngineConfigException(new StringBuilder(29 + String.valueOf(xmlFilename).length() + String.valueOf(string).length()).append("IO error validating ").append(xmlFilename).append(" against ").append(string).toString(), ex);
        }
    }

    static void validateXmlContent(String content, File schema) {
        if (!schema.exists()) {
            String string = schema.getPath();
            throw new AppEngineConfigException(new StringBuilder(29 + String.valueOf(string).length()).append("Schema file: ").append(string).append(" does not exist.").toString());
        }
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                factory.newSchema(schema).newValidator().validate(new StreamSource(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8))));
            }
            catch (SAXException ex) {
                String string = schema.getPath();
                throw new AppEngineConfigException(new StringBuilder(30 + String.valueOf(content).length() + String.valueOf(string).length()).append("XML error validating ").append(content).append(" against ").append(string).toString(), ex);
            }
        }
        catch (IOException ex) {
            String string = schema.getPath();
            throw new AppEngineConfigException(new StringBuilder(29 + String.valueOf(content).length() + String.valueOf(string).length()).append("IO error validating ").append(content).append(" against ").append(string).toString(), ex);
        }
    }

    static String getRequiredChildElementBody(Element element, String tagName) {
        return XmlUtils.getChildElementBody(element, tagName, true);
    }

    static String getOptionalChildElementBody(Element element, String tagName) {
        return XmlUtils.getChildElementBody(element, tagName, false);
    }

    static String getChildElementBody(Element element, String tagName, boolean required) {
        Element elt = XmlUtils.getChildElement(element, tagName, required);
        if (elt == null) {
            return null;
        }
        String result = XmlUtils.getText(elt);
        return result.isEmpty() ? null : result;
    }

    static Element getOptionalChildElement(Element parent, String tagName) {
        return XmlUtils.getChildElement(parent, tagName, false);
    }

    static Element getChildElement(Element parent, String tagName, boolean required) {
        NodeList nodes = parent.getElementsByTagName(tagName);
        if (nodes == null || nodes.getLength() == 0) {
            if (required) {
                throw new IllegalStateException(String.format("Missing tag %s in element %s.", tagName, parent));
            }
            return null;
        }
        return (Element)nodes.item(0);
    }

    public static String getAttributeOrNull(Element element, String name) {
        if (!element.hasAttribute(name)) {
            return null;
        }
        return element.getAttribute(name);
    }

    static List<Element> getChildren(Element element) {
        return XmlUtils.getChildren(element, null);
    }

    public static List<Element> getChildren(Element element, String tagName) {
        NodeList nodes = element.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            if (!(item instanceof Element)) continue;
            Element itemElement = (Element)item;
            if (tagName != null && !tagName.equals(itemElement.getTagName())) continue;
            elements.add(itemElement);
        }
        return elements;
    }
}

