/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools;

import com.google.appengine.repackaged.com.google.common.base.Ascii;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.base.StandardSystemProperty;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.tools.development.DevAppServerMain;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KickStart {
    private static final Logger logger = Logger.getLogger(KickStart.class.getName());
    private static final String JVM_FLAG = "--jvm_flag";
    private static final String JVM_FLAG_ERROR_MESSAGE = "--jvm_flag=<flag> expected.\n--jvm_flag may be repeated to supply multiple flags";
    private static final String START_ON_FIRST_THREAD_FLAG = "--startOnFirstThread";
    private static final String START_ON_FIRST_THREAD_ERROR_MESSAGE = "--startOnFirstThread=<boolean> expected";
    private static final String SDK_ROOT_FLAG = "--sdk_root";
    private static final String SDK_ROOT_ERROR_MESSAGE = "--sdk_root=<path> expected";
    private static final String ENABLE_JACOCO_FLAG = "--enable_jacoco";
    private static final String ENABLE_JACOCO_ERROR_MESSAGE = "--enable_jacoco=true|false expected.";
    private static final String JACOCO_AGENT_JAR_FLAG = "--jacoco_agent_jar";
    private static final String JACOCO_AGENT_JAR_ERROR_MESSAGE = "--jacoco_agent_jar=<path> expected.";
    private static final String JACOCO_AGENT_ARGS_FLAG = "--jacoco_agent_args";
    private static final String JACOCO_AGENT_ARGS_ERROR_MESSAGE = "--jacoco_agent_args=<jacoco agent args> expected.";
    private static final String JACOCO_EXEC_FLAG = "--jacoco_exec";
    private static final String JACOCO_EXEC_ERROR_MESSAGE = "--jacoco_exec=<path> expected.";
    private Process serverProcess = null;

    public static void main(String[] args) {
        new KickStart(args);
    }

    @CanIgnoreReturnValue
    private KickStart(String[] args) {
        String string;
        String classpath;
        String entryClass = null;
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        String home = StandardSystemProperty.JAVA_HOME.value();
        String string2 = File.separator;
        String string3 = File.separator;
        String javaExe = new StringBuilder(7 + String.valueOf(home).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(home).append(string2).append("bin").append(string3).append("java").toString();
        ArrayList<String> jvmArgs = new ArrayList<String>();
        ArrayList<String> appServerArgs = new ArrayList<String>();
        boolean enableJacoco = false;
        String jacocoAgentJarArg = null;
        String jacocoAgentArgs = "";
        String jacocoExecArg = "jacoco.exec";
        List<String> command = builder.command();
        command.add(javaExe);
        boolean startOnFirstThread = Ascii.equalsIgnoreCase(StandardSystemProperty.OS_NAME.value(), "Mac OS X");
        boolean testMode = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith(JVM_FLAG)) {
                jvmArgs.add(KickStart.extractValue(args[i], JVM_FLAG_ERROR_MESSAGE));
                continue;
            }
            if (args[i].startsWith(SDK_ROOT_FLAG)) {
                String sdkRoot = new File(KickStart.extractValue(args[i], SDK_ROOT_ERROR_MESSAGE)).getAbsolutePath();
                System.setProperty("appengine.sdk.root", sdkRoot);
                String string4 = String.valueOf(sdkRoot);
                jvmArgs.add(string4.length() != 0 ? "-Dappengine.sdk.root=".concat(string4) : new String("-Dappengine.sdk.root="));
                continue;
            }
            if (args[i].startsWith(START_ON_FIRST_THREAD_FLAG)) {
                startOnFirstThread = Boolean.parseBoolean(KickStart.extractValue(args[i], START_ON_FIRST_THREAD_ERROR_MESSAGE));
                continue;
            }
            if (args[i].startsWith(ENABLE_JACOCO_FLAG)) {
                enableJacoco = "true".equals(KickStart.extractValue(args[i], ENABLE_JACOCO_ERROR_MESSAGE));
                continue;
            }
            if (args[i].startsWith(JACOCO_AGENT_JAR_FLAG)) {
                jacocoAgentJarArg = KickStart.extractValue(args[i], JACOCO_AGENT_JAR_ERROR_MESSAGE);
                continue;
            }
            if (args[i].startsWith(JACOCO_AGENT_ARGS_FLAG)) {
                jacocoAgentArgs = KickStart.extractValue(args[i], JACOCO_AGENT_ARGS_ERROR_MESSAGE);
                continue;
            }
            if (args[i].startsWith(JACOCO_EXEC_FLAG)) {
                jacocoExecArg = KickStart.extractValue(args[i], JACOCO_EXEC_ERROR_MESSAGE);
                continue;
            }
            if (args[i].equals("--test_mode")) {
                testMode = true;
                continue;
            }
            if (entryClass == null) {
                if (args[i].charAt(0) == '-') {
                    String string5 = String.valueOf(args[i]);
                    throw new IllegalArgumentException(string5.length() != 0 ? "This argument may not precede the classname: ".concat(string5) : new String("This argument may not precede the classname: "));
                }
                entryClass = args[i];
                if (entryClass.equals(DevAppServerMain.class.getName()) || testMode) continue;
                throw new IllegalArgumentException("KickStart only works for DevAppServerMain");
            }
            appServerArgs.add(args[i]);
        }
        if (entryClass == null) {
            throw new IllegalArgumentException("missing entry classname");
        }
        File newWorkingDir = KickStart.newWorkingDir(appServerArgs.toArray(new String[0]));
        builder.directory(newWorkingDir);
        if (startOnFirstThread) {
            jvmArgs.add("-XstartOnFirstThread");
        }
        if ((classpath = System.getProperty("java.class.path")) == null) {
            throw new IllegalArgumentException("classpath must not be null");
        }
        StringBuilder newClassPath = new StringBuilder();
        List<String> paths = Splitter.onPattern(File.pathSeparator).splitToList(classpath);
        for (int i = 0; i < paths.size(); ++i) {
            newClassPath.append(new File(paths.get(i)).getAbsolutePath());
            if (i == paths.size() - 1) continue;
            newClassPath.append(File.pathSeparator);
        }
        if (appServerArgs.isEmpty() || ((String)Iterables.getLast(appServerArgs)).startsWith("-")) {
            new DevAppServerMain().printHelp(System.out);
            System.exit(1);
        }
        Path workingDir = Paths.get((String)Iterables.getLast(appServerArgs), new String[0]);
        new DevAppServerMain().validateWarPath(workingDir.toFile());
        String appDir = null;
        ArrayList<String> absoluteAppServerArgs = new ArrayList<String>(appServerArgs.size());
        for (int i = 0; i < appServerArgs.size(); ++i) {
            File file;
            String arg = (String)appServerArgs.get(i);
            if (i == appServerArgs.size() - 1 && !arg.startsWith("-") && (file = new File(arg)).exists()) {
                appDir = arg = new File(arg).getAbsolutePath();
            }
            absoluteAppServerArgs.add(arg);
        }
        AppEnvironment appEnvironment = KickStart.readAppEnvironment(appDir);
        String encoding = appEnvironment.encoding;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        String string6 = String.valueOf(encoding);
        jvmArgs.add(string6.length() != 0 ? "-Dfile.encoding=".concat(string6) : new String("-Dfile.encoding="));
        if (enableJacoco) {
            jvmArgs.add("-D--enable_all_permissions=true");
            String jacocoAgentJar = new File(jacocoAgentJarArg).getAbsolutePath();
            if (!jacocoAgentArgs.isEmpty()) {
                jacocoAgentArgs = String.valueOf(jacocoAgentArgs).concat(",");
            }
            String string7 = String.valueOf(jacocoAgentArgs);
            string = new File(jacocoExecArg).getAbsolutePath();
            string7 = jacocoAgentArgs = new StringBuilder(9 + String.valueOf(string7).length() + String.valueOf(string).length()).append(string7).append("destfile=").append(string).toString();
            jvmArgs.add(new StringBuilder(12 + String.valueOf(jacocoAgentJar).length() + String.valueOf(string7).length()).append("-javaagent:").append(jacocoAgentJar).append("=").append(string7).toString());
        }
        command.addAll(jvmArgs);
        command.add("-classpath");
        command.add(newClassPath.toString());
        command.add(entryClass);
        String string8 = String.valueOf(System.getProperty("user.dir"));
        command.add(string8.length() != 0 ? "--property=kickstart.user.dir=".concat(string8) : new String("--property=kickstart.user.dir="));
        command.add("--no_java_agent");
        command.addAll(absoluteAppServerArgs);
        String gaeEnv = "localdev";
        String gaeRuntime = "java8";
        builder.environment().put("GAE_ENV", gaeEnv);
        builder.environment().put("GAE_RUNTIME", gaeRuntime);
        builder.environment().put("GAE_SERVICE", appEnvironment.serviceName);
        builder.environment().put("GAE_INSTANCE", UUID.randomUUID().toString());
        builder.inheritIO();
        string = String.valueOf(command);
        logger.logp(Level.FINE, "com.google.appengine.tools.KickStart", "<init>", new StringBuilder(10 + String.valueOf(string).length()).append("Executing ").append(string).toString());
        string = String.valueOf(command);
        System.out.println(new StringBuilder(10 + String.valueOf(string).length()).append("Executing ").append(string).toString());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (KickStart.this.serverProcess != null) {
                    KickStart.this.serverProcess.destroy();
                }
            }
        });
        try {
            this.serverProcess = builder.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to start the process", e);
        }
        try {
            this.serverProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.serverProcess.destroy();
        this.serverProcess = null;
    }

    private static String extractValue(String argument, String errorMessage) {
        int indexOfEqualSign = argument.indexOf(61);
        if (indexOfEqualSign == -1) {
            throw new IllegalArgumentException(errorMessage);
        }
        return argument.substring(argument.indexOf(61) + 1);
    }

    private static File newWorkingDir(String[] args) {
        if (args.length < 1 || args[args.length - 1].startsWith("-")) {
            new DevAppServerMain().printHelp(System.out);
            System.exit(1);
        }
        File workingDir = new File(args[args.length - 1]);
        new DevAppServerMain().validateWarPath(workingDir);
        return workingDir;
    }

    static AppEnvironment readAppEnvironment(String appDir) {
        if (appDir == null) {
            return AppEnvironment.DEFAULT;
        }
        ArrayList<AppEngineWebXml> configs = new ArrayList<AppEngineWebXml>();
        File config = new File(appDir, "WEB-INF/appengine-web.xml");
        if (config.exists()) {
            try {
                configs.add(new AppEngineWebXmlReader(appDir).readAppEngineWebXml());
            }
            catch (AppEngineConfigException e) {
                String string = String.valueOf(config.getAbsolutePath());
                System.err.println(string.length() != 0 ? "Error reading module: ".concat(string) : new String("Error reading module: "));
                return AppEnvironment.DEFAULT;
            }
        } else {
            File ear = new File(appDir);
            if (!ear.exists()) {
                String string = String.valueOf(ear.getAbsolutePath());
                System.err.println(string.length() != 0 ? "Application does not exist: ".concat(string) : new String("Application does not exist: "));
                return AppEnvironment.DEFAULT;
            }
            for (File war : ear.listFiles()) {
                File currConfig = new File(war, "WEB-INF/appengine-web.xml");
                if (!currConfig.exists()) continue;
                try {
                    configs.add(new AppEngineWebXmlReader(war.getAbsolutePath()).readAppEngineWebXml());
                }
                catch (AppEngineConfigException e) {
                    String string = String.valueOf(war.getAbsolutePath());
                    System.err.println(string.length() != 0 ? "Error reading module: ".concat(string) : new String("Error reading module: "));
                }
            }
        }
        String serviceName = "default";
        String encoding = null;
        for (AppEngineWebXml currConfig : configs) {
            Map<String, String> systemProperties;
            if (currConfig.getService() != null) {
                serviceName = currConfig.getService();
            } else if (currConfig.getModule() != null) {
                serviceName = currConfig.getModule();
            }
            if (!(systemProperties = currConfig.getSystemProperties()).containsKey("appengine.file.encoding")) continue;
            encoding = systemProperties.get("appengine.file.encoding");
        }
        return new AppEnvironment(serviceName, encoding);
    }

    static class AppEnvironment {
        static final AppEnvironment DEFAULT = new AppEnvironment("default", null);
        final String serviceName;
        final String encoding;

        AppEnvironment(String serviceName, String encoding) {
            this.serviceName = serviceName;
            this.encoding = encoding;
        }
    }
}

