/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.esotericsoftware.yamlbeans;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.Beans;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

class DeferredConstruction {
    private final Constructor constructor;
    private final String[] parameterNames;
    private final ParameterValue[] parameterValues;
    private final List<PropertyValue> propertyValues = new ArrayList<PropertyValue>(16);

    public DeferredConstruction(Constructor constructor, String[] parameterNames) {
        this.constructor = constructor;
        this.parameterNames = parameterNames;
        this.parameterValues = new ParameterValue[parameterNames.length];
    }

    public Object construct() throws InvocationTargetException {
        try {
            Object[] parameters = new Object[this.parameterValues.length];
            int i = 0;
            for (ParameterValue parameter : this.parameterValues) {
                if (parameter == null) {
                    throw new InvocationTargetException(new YamlException("Missing constructor property: " + this.parameterNames[i]));
                }
                parameters[i++] = parameter.value;
            }
            Object object = this.constructor.newInstance(parameters);
            for (PropertyValue propertyValue : this.propertyValues) {
                propertyValue.property.set(object, propertyValue.value);
            }
            return object;
        }
        catch (Exception ex) {
            throw new InvocationTargetException(ex, "Error constructing instance of class: " + this.constructor.getDeclaringClass().getName());
        }
    }

    public void storeProperty(Beans.Property property, Object value) {
        int index = 0;
        for (String name : this.parameterNames) {
            if (property.getName().equals(name)) {
                ParameterValue parameterValue = new ParameterValue();
                parameterValue.value = value;
                this.parameterValues[index] = parameterValue;
                return;
            }
            ++index;
        }
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.property = property;
        propertyValue.value = value;
        this.propertyValues.add(propertyValue);
    }

    public boolean hasParameter(String name) {
        for (String s : this.parameterNames) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    static class ParameterValue {
        Object value;

        ParameterValue() {
        }
    }

    static class PropertyValue {
        Beans.Property property;
        Object value;

        PropertyValue() {
        }
    }
}

