/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.appengine.tools.info.SdkImplInfo;
import com.google.appengine.tools.info.SdkInfo;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

class ClassicSdk
extends AppengineSdk {
    ClassicSdk() {
    }

    @Override
    public void includeTestingJarOnSharedPath(boolean val) {
        SdkInfo.includeTestingJarOnSharedPath(val);
    }

    @Override
    public File getToolsApiJarFile() {
        return new File(this.getSdkRoot() + "/lib/appengine-tools-api.jar");
    }

    @Override
    public List<File> getUserJspLibFiles() {
        return SdkImplInfo.getUserJspLibFiles();
    }

    @Override
    public List<File> getUserLibFiles() {
        return SdkInfo.getUserLibFiles();
    }

    @Override
    public List<URL> getWebApiToolsLibs() {
        return SdkImplInfo.getWebApiToolLibs();
    }

    @Override
    public List<File> getSharedJspLibFiles() {
        return SdkImplInfo.getSharedJspLibFiles();
    }

    @Override
    public List<URL> getImplLibs() {
        return SdkImplInfo.getImplLibs();
    }

    @Override
    public List<File> getSharedLibFiles() {
        return SdkInfo.getSharedLibFiles();
    }

    @Override
    public List<URL> getDatanucleusLibs(String version) {
        this.validateDatanucleusVersions(version);
        return SdkInfo.getOptionalToolsLib("datanucleus").getURLsForVersion(version);
    }

    @Override
    public String getQuickStartClasspath(AppengineSdk.WebDefaultXmlType jettyVersion) {
        ArrayList<String> list = new ArrayList<String>();
        File quickstart = new File(this.getSdkRoot(), "lib/tools/quickstart/quickstartgenerator.jar");
        File jettyDir = new File(this.getSdkRoot(), "jetty94/jetty-home/lib");
        for (File f : jettyDir.listFiles()) {
            if (f.isDirectory() || f.getName().startsWith("cdi-") || f.getName().startsWith("jetty-cdi-")) continue;
            list.add(f.getAbsolutePath());
        }
        list.add(this.getSdkRoot() + "/lib/impl/appengine-api.jar");
        for (String subdir : new String[]{"annotations", "jaspi"}) {
            for (File f : new File(jettyDir, subdir).listFiles()) {
                list.add(f.getAbsolutePath());
            }
        }
        list.add(quickstart.getAbsolutePath());
        return Joiner.on(System.getProperty("path.separator")).join(list);
    }

    @Override
    public String getWebDefaultXml(AppengineSdk.WebDefaultXmlType jettyVersion) {
        switch (jettyVersion) {
            case JETTY93_STANDARD: {
                return this.getSdkRoot() + "/docs/webdefault.xml";
            }
        }
        throw new IllegalArgumentException("Invalid Jetty version: " + (Object)((Object)jettyVersion));
    }

    public String getSdkRoot() {
        return SdkInfo.getSdkRoot().getAbsolutePath();
    }

    @Override
    public File getResourcesDirectory() {
        return new File(this.getSdkRoot(), "docs");
    }

    @Override
    public File getAgentJarFile() {
        return new File(this.getSdkRoot() + "/lib/agent/appengine-agent.jar");
    }

    @Override
    public List<URL> getSharedLibs() {
        return SdkInfo.getSharedLibs();
    }

    @Override
    public File getLoggingProperties() {
        return SdkImplInfo.getLoggingProperties();
    }
}

