/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlConfig;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlException;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlWriter;
import com.google.appengine.tools.info.Version;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.BackendsXml;
import com.google.apphosting.utils.config.WebXml;
import com.google.apphosting.utils.glob.ConflictResolver;
import com.google.apphosting.utils.glob.Glob;
import com.google.apphosting.utils.glob.GlobFactory;
import com.google.apphosting.utils.glob.GlobIntersector;
import com.google.apphosting.utils.glob.LongestPatternConflictResolver;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AppYamlTranslator {
    private static final String NO_API_VERSION = "none";
    private static final ConflictResolver RESOLVER = new LongestPatternConflictResolver();
    private static final String DYNAMIC_PROPERTY = "dynamic";
    private static final String STATIC_PROPERTY = "static";
    private static final String WELCOME_FILES = "welcome";
    private static final String TRANSPORT_GUARANTEE_PROPERTY = "transportGuarantee";
    private static final String REQUIRED_ROLE_PROPERTY = "requiredRole";
    private static final String EXPIRATION_PROPERTY = "expiration";
    private static final String HTTP_HEADERS_PROPERTY = "http_headers";
    private static final String API_ENDPOINT_REGEX = "/_ah/spi/*";
    private static final String[] PROPERTIES = new String[]{"dynamic", "static", "welcome", "transportGuarantee", "requiredRole", "expiration"};
    private static final int MAX_HANDLERS = 100;
    private final AppEngineWebXml appEngineWebXml;
    private final WebXml webXml;
    private final BackendsXml backendsXml;
    private final String apiVersion;
    private final Set<String> staticFiles;
    private final String runtime;

    public AppYamlTranslator(AppEngineWebXml appEngineWebXml, WebXml webXml, BackendsXml backendsXml, String apiVersion, Set<String> staticFiles, AppEngineWebXml.ApiConfig apiConfig, String runtime, Version sdkVersion) {
        this.appEngineWebXml = appEngineWebXml;
        this.webXml = webXml;
        this.backendsXml = backendsXml;
        this.apiVersion = apiVersion;
        this.staticFiles = staticFiles;
        this.runtime = runtime != null ? runtime : appEngineWebXml.getRuntime();
        if (appEngineWebXml.getUseVm() && appEngineWebXml.isFlexible()) {
            throw new AppEngineConfigException("Cannot define both <vm> and <env> entries.");
        }
    }

    public String getYaml() {
        StringBuilder builder = new StringBuilder();
        this.translateAppEngineWebXml(builder);
        if (!this.appEngineWebXml.isJava11OrAbove()) {
            this.translateApiVersion(builder);
        }
        this.translateWebXml(builder);
        return builder.toString();
    }

    private void appendIfNotNull(StringBuilder builder, String tag, Object value) {
        if (value != null) {
            builder.append(tag);
            builder.append(value);
            builder.append("\n");
        }
    }

    private void appendIfNotZero(StringBuilder builder, String tag, double value) {
        if (value != 0.0) {
            builder.append(tag);
            builder.append(value);
            builder.append("\n");
        }
    }

    private void translateAppEngineWebXml(StringBuilder builder) {
        AppEngineWebXml.ApiConfig apiConfig;
        List<AppEngineWebXml.ErrorHandler> list;
        List<AppEngineWebXml.AdminConsolePage> adminConsolePages;
        Set<String> services;
        Object settings;
        if (this.appEngineWebXml.getAppId() != null) {
            builder.append("application: '" + this.appEngineWebXml.getAppId() + "'\n");
        }
        builder.append("runtime: " + this.runtime + "\n");
        if (this.appEngineWebXml.getUseVm()) {
            builder.append("vm: True\n");
        }
        if (this.appEngineWebXml.isFlexible()) {
            builder.append("env: " + this.appEngineWebXml.getEnv() + "\n");
        }
        if (this.appEngineWebXml.getEntrypoint() != null) {
            builder.append("entrypoint: '" + this.appEngineWebXml.getEntrypoint() + "'\n");
        }
        if (this.appEngineWebXml.getRuntimeChannel() != null) {
            builder.append("runtime_channel: " + this.appEngineWebXml.getRuntimeChannel() + "\n");
        }
        if (this.appEngineWebXml.getMajorVersionId() != null) {
            builder.append("version: '" + this.appEngineWebXml.getMajorVersionId() + "'\n");
        }
        if (this.appEngineWebXml.getService() != null) {
            builder.append("service: '" + this.appEngineWebXml.getService() + "'\n");
        } else if (this.appEngineWebXml.getModule() != null) {
            builder.append("module: '" + this.appEngineWebXml.getModule() + "'\n");
        }
        if (this.appEngineWebXml.getInstanceClass() != null) {
            builder.append("instance_class: " + this.appEngineWebXml.getInstanceClass() + "\n");
        }
        if (!this.appEngineWebXml.getAutomaticScaling().isEmpty()) {
            builder.append("automatic_scaling:\n");
            settings = this.appEngineWebXml.getAutomaticScaling();
            this.appendIfNotNull(builder, "  min_pending_latency: ", ((AppEngineWebXml.AutomaticScaling)settings).getMinPendingLatency());
            this.appendIfNotNull(builder, "  max_pending_latency: ", ((AppEngineWebXml.AutomaticScaling)settings).getMaxPendingLatency());
            this.appendIfNotNull(builder, "  min_idle_instances: ", ((AppEngineWebXml.AutomaticScaling)settings).getMinIdleInstances());
            this.appendIfNotNull(builder, "  max_idle_instances: ", ((AppEngineWebXml.AutomaticScaling)settings).getMaxIdleInstances());
            this.appendIfNotNull(builder, "  max_concurrent_requests: ", ((AppEngineWebXml.AutomaticScaling)settings).getMaxConcurrentRequests());
            this.appendIfNotNull(builder, "  min_num_instances: ", ((AppEngineWebXml.AutomaticScaling)settings).getMinNumInstances());
            this.appendIfNotNull(builder, "  max_num_instances: ", ((AppEngineWebXml.AutomaticScaling)settings).getMaxNumInstances());
            this.appendIfNotNull(builder, "  cool_down_period_sec: ", ((AppEngineWebXml.AutomaticScaling)settings).getCoolDownPeriodSec());
            this.appendIfNotNull(builder, "  min_instances: ", ((AppEngineWebXml.AutomaticScaling)settings).getMinInstances());
            this.appendIfNotNull(builder, "  max_instances: ", ((AppEngineWebXml.AutomaticScaling)settings).getMaxInstances());
            this.appendIfNotNull(builder, "  target_cpu_utilization: ", ((AppEngineWebXml.AutomaticScaling)settings).getTargetCpuUtilization());
            this.appendIfNotNull(builder, "  target_throughput_utilization: ", ((AppEngineWebXml.AutomaticScaling)settings).getTargetThroughputUtilization());
            AppEngineWebXml.CpuUtilization cpuUtil = ((AppEngineWebXml.AutomaticScaling)settings).getCpuUtilization();
            if (cpuUtil != null && (cpuUtil.getTargetUtilization() != null || cpuUtil.getAggregationWindowLengthSec() != null)) {
                builder.append("  cpu_utilization:\n");
                this.appendIfNotNull(builder, "    target_utilization: ", cpuUtil.getTargetUtilization());
                this.appendIfNotNull(builder, "    aggregation_window_length_sec: ", cpuUtil.getAggregationWindowLengthSec());
            }
            this.appendIfNotNull(builder, "  target_network_sent_bytes_per_sec: ", ((AppEngineWebXml.AutomaticScaling)settings).getTargetNetworkSentBytesPerSec());
            this.appendIfNotNull(builder, "  target_network_sent_packets_per_sec: ", ((AppEngineWebXml.AutomaticScaling)settings).getTargetNetworkSentPacketsPerSec());
            this.appendIfNotNull(builder, "  target_network_received_bytes_per_sec: ", ((AppEngineWebXml.AutomaticScaling)settings).getTargetNetworkReceivedBytesPerSec());
            this.appendIfNotNull(builder, "  target_network_received_packets_per_sec: ", ((AppEngineWebXml.AutomaticScaling)settings).getTargetNetworkReceivedPacketsPerSec());
            this.appendIfNotNull(builder, "  target_disk_write_bytes_per_sec: ", ((AppEngineWebXml.AutomaticScaling)settings).getTargetDiskWriteBytesPerSec());
            this.appendIfNotNull(builder, "  target_disk_write_ops_per_sec: ", ((AppEngineWebXml.AutomaticScaling)settings).getTargetDiskWriteOpsPerSec());
            this.appendIfNotNull(builder, "  target_disk_read_bytes_per_sec: ", ((AppEngineWebXml.AutomaticScaling)settings).getTargetDiskReadBytesPerSec());
            this.appendIfNotNull(builder, "  target_disk_read_ops_per_sec: ", ((AppEngineWebXml.AutomaticScaling)settings).getTargetDiskReadOpsPerSec());
            this.appendIfNotNull(builder, "  target_request_count_per_sec: ", ((AppEngineWebXml.AutomaticScaling)settings).getTargetRequestCountPerSec());
            this.appendIfNotNull(builder, "  target_concurrent_requests: ", ((AppEngineWebXml.AutomaticScaling)settings).getTargetConcurrentRequests());
            if (!((AppEngineWebXml.AutomaticScaling)settings).getCustomMetrics().isEmpty()) {
                if (!this.appEngineWebXml.isFlexible()) {
                    throw new AppEngineConfigException("custom-metrics is only available in the AppEngine Flexible environment.");
                }
                builder.append("  custom_metrics:\n");
                for (AppEngineWebXml.CustomMetricUtilization customMetricUtilization : ((AppEngineWebXml.AutomaticScaling)settings).getCustomMetrics()) {
                    builder.append("    - metric_name: '" + customMetricUtilization.getMetricName() + "'\n");
                    builder.append("      target_type: '" + customMetricUtilization.getTargetType() + "'\n");
                    this.appendIfNotNull(builder, "      target_utilization: ", customMetricUtilization.getTargetUtilization());
                    this.appendIfNotNull(builder, "      single_instance_assignment: ", customMetricUtilization.getSingleInstanceAssignment());
                    if (customMetricUtilization.getFilter() == null) continue;
                    builder.append("      filter: '" + customMetricUtilization.getFilter() + "'\n");
                }
            }
        }
        if (!this.appEngineWebXml.getManualScaling().isEmpty()) {
            builder.append("manual_scaling:\n");
            settings = this.appEngineWebXml.getManualScaling();
            builder.append("  instances: " + ((AppEngineWebXml.ManualScaling)settings).getInstances() + "\n");
        }
        if (!this.appEngineWebXml.getBasicScaling().isEmpty()) {
            builder.append("basic_scaling:\n");
            settings = this.appEngineWebXml.getBasicScaling();
            builder.append("  max_instances: " + ((AppEngineWebXml.BasicScaling)settings).getMaxInstances() + "\n");
            this.appendIfNotNull(builder, "  idle_timeout: ", ((AppEngineWebXml.BasicScaling)settings).getIdleTimeout());
        }
        if (!(services = this.appEngineWebXml.getInboundServices()).isEmpty()) {
            builder.append("inbound_services:\n");
            for (String string : services) {
                builder.append("- " + string + "\n");
            }
        }
        if (this.appEngineWebXml.getPrecompilationEnabled() && !this.appEngineWebXml.getUseVm() && !this.appEngineWebXml.isFlexible() && !this.appEngineWebXml.isJava11OrAbove()) {
            builder.append("derived_file_type:\n");
            builder.append("- java_precompiled\n");
        }
        if (this.appEngineWebXml.getThreadsafe() && !this.appEngineWebXml.isJava11OrAbove()) {
            builder.append("threadsafe: True\n");
        }
        if (this.appEngineWebXml.getAppEngineApis() && this.appEngineWebXml.isJava11OrAbove()) {
            builder.append("app_engine_apis: True\n");
        }
        if (this.appEngineWebXml.getThreadsafeValueProvided() && this.appEngineWebXml.isJava11OrAbove()) {
            System.out.println("Warning: The " + this.appEngineWebXml.getRuntime() + " runtime does not use the <threadsafe> element in appengine-web.xml anymore");
            System.out.println("Instead, you can use the <max-concurrent-requests> element in <automatic-scaling>.");
        }
        if (this.appEngineWebXml.getAutoIdPolicy() != null) {
            builder.append("auto_id_policy: " + this.appEngineWebXml.getAutoIdPolicy() + "\n");
        } else {
            builder.append("auto_id_policy: default\n");
        }
        if (this.appEngineWebXml.getCodeLock()) {
            builder.append("code_lock: True\n");
        }
        if (this.appEngineWebXml.getVpcAccessConnector() != null) {
            AppEngineWebXml.VpcAccessConnector connector = this.appEngineWebXml.getVpcAccessConnector();
            builder.append("vpc_access_connector:\n");
            builder.append("  name: " + connector.getName() + "\n");
            if (connector.getEgressSetting().isPresent()) {
                builder.append("  egress_setting: " + connector.getEgressSetting().get() + "\n");
            }
        }
        if (this.appEngineWebXml.getServiceAccount() != null) {
            builder.append("service_account: " + this.appEngineWebXml.getServiceAccount() + "\n");
        }
        if (!(adminConsolePages = this.appEngineWebXml.getAdminConsolePages()).isEmpty()) {
            builder.append("admin_console:\n");
            builder.append("  pages:\n");
            for (AppEngineWebXml.AdminConsolePage adminConsolePage : adminConsolePages) {
                builder.append("  - name: " + adminConsolePage.getName() + "\n");
                builder.append("    url: " + adminConsolePage.getUrl() + "\n");
            }
        }
        if (!(list = this.appEngineWebXml.getErrorHandlers()).isEmpty()) {
            builder.append("error_handlers:\n");
            for (AppEngineWebXml.ErrorHandler handler : list) {
                String mimeType;
                String fileName = handler.getFile();
                if (!fileName.startsWith("/")) {
                    fileName = "/" + fileName;
                }
                if (!this.staticFiles.contains("__static__" + fileName)) {
                    throw new AppEngineConfigException("No static file found for error handler: " + fileName + ", out of " + this.staticFiles);
                }
                builder.append("- file: __static__" + fileName + "\n");
                if (handler.getErrorCode() != null) {
                    builder.append("  error_code: " + handler.getErrorCode() + "\n");
                }
                if ((mimeType = this.webXml.getMimeTypeForPath(handler.getFile())) == null) continue;
                builder.append("  mime_type: " + mimeType + "\n");
            }
        }
        if (this.backendsXml != null) {
            builder.append(this.backendsXml.toYaml());
        }
        if ((apiConfig = this.appEngineWebXml.getApiConfig()) != null) {
            builder.append("api_config:\n");
            builder.append("  url: " + apiConfig.getUrl() + "\n");
            builder.append("  script: unused\n");
        }
        this.appendBetaSettings(this.appEngineWebXml.getBetaSettings(), builder);
        this.appendEnvVariables(this.appEngineWebXml.getEnvironmentVariables(), builder);
        this.appendBuildEnvVariables(this.appEngineWebXml.getBuildEnvironmentVariables(), builder);
        if (this.appEngineWebXml.getUseVm() || this.appEngineWebXml.isFlexible()) {
            if (this.appEngineWebXml.getHealthCheck() != null) {
                this.appendHealthCheck(this.appEngineWebXml.getHealthCheck(), builder);
            }
            if (this.appEngineWebXml.getLivenessCheck() != null) {
                this.appendLivenessCheck(this.appEngineWebXml.getLivenessCheck(), builder);
            }
            if (this.appEngineWebXml.getReadinessCheck() != null) {
                this.appendReadinessCheck(this.appEngineWebXml.getReadinessCheck(), builder);
            }
            this.appendResources(this.appEngineWebXml.getResources(), builder);
            this.appendNetwork(this.appEngineWebXml.getNetwork(), builder);
        }
    }

    private void appendEnvVariables(Map<String, String> envVariables, StringBuilder builder) {
        if (envVariables.size() > 0) {
            builder.append("env_variables:\n");
            for (Map.Entry<String, String> envVariable : envVariables.entrySet()) {
                String k = envVariable.getKey();
                String v = envVariable.getValue();
                builder.append("  ").append(this.yamlQuote(k)).append(": ").append(this.yamlQuote(v)).append("\n");
            }
        }
    }

    private void appendBuildEnvVariables(Map<String, String> buildEnvVariables, StringBuilder builder) {
        if (buildEnvVariables.size() > 0) {
            builder.append("build_env_variables:\n");
            for (Map.Entry<String, String> buildEnvVariable : buildEnvVariables.entrySet()) {
                String k = buildEnvVariable.getKey();
                String v = buildEnvVariable.getValue();
                builder.append("  ").append(this.yamlQuote(k)).append(": ").append(this.yamlQuote(v)).append("\n");
            }
        }
    }

    private void appendBetaSettings(Map<String, String> betaSettings, StringBuilder builder) {
        if (betaSettings != null && !betaSettings.isEmpty()) {
            builder.append("beta_settings:\n");
            for (Map.Entry<String, String> setting : betaSettings.entrySet()) {
                builder.append("  " + this.yamlQuote(setting.getKey()) + ": " + this.yamlQuote(setting.getValue()) + "\n");
            }
        }
    }

    private void appendHealthCheck(AppEngineWebXml.HealthCheck healthCheck, StringBuilder builder) {
        builder.append("health_check:\n");
        if (healthCheck.getEnableHealthCheck()) {
            builder.append("  enable_health_check: True\n");
        } else {
            builder.append("  enable_health_check: False\n");
        }
        this.appendIfNotNull(builder, "  check_interval_sec: ", healthCheck.getCheckIntervalSec());
        this.appendIfNotNull(builder, "  timeout_sec: ", healthCheck.getTimeoutSec());
        this.appendIfNotNull(builder, "  unhealthy_threshold: ", healthCheck.getUnhealthyThreshold());
        this.appendIfNotNull(builder, "  healthy_threshold: ", healthCheck.getHealthyThreshold());
        this.appendIfNotNull(builder, "  restart_threshold: ", healthCheck.getRestartThreshold());
        this.appendIfNotNull(builder, "  host: ", healthCheck.getHost());
    }

    private void appendLivenessCheck(AppEngineWebXml.LivenessCheck livenessCheck, StringBuilder builder) {
        builder.append("liveness_check:\n");
        this.appendIfNotNull(builder, "  path: ", livenessCheck.getPath());
        this.appendIfNotNull(builder, "  check_interval_sec: ", livenessCheck.getCheckIntervalSec());
        this.appendIfNotNull(builder, "  timeout_sec: ", livenessCheck.getTimeoutSec());
        this.appendIfNotNull(builder, "  failure_threshold: ", livenessCheck.getFailureThreshold());
        this.appendIfNotNull(builder, "  success_threshold: ", livenessCheck.getSuccessThreshold());
        this.appendIfNotNull(builder, "  host: ", livenessCheck.getHost());
        this.appendIfNotNull(builder, "  initial_delay_sec: ", livenessCheck.getInitialDelaySec());
    }

    private void appendReadinessCheck(AppEngineWebXml.ReadinessCheck readinessCheck, StringBuilder builder) {
        builder.append("readiness_check:\n");
        this.appendIfNotNull(builder, "  path: ", readinessCheck.getPath());
        this.appendIfNotNull(builder, "  check_interval_sec: ", readinessCheck.getCheckIntervalSec());
        this.appendIfNotNull(builder, "  timeout_sec: ", readinessCheck.getTimeoutSec());
        this.appendIfNotNull(builder, "  failure_threshold: ", readinessCheck.getFailureThreshold());
        this.appendIfNotNull(builder, "  success_threshold: ", readinessCheck.getSuccessThreshold());
        this.appendIfNotNull(builder, "  host: ", readinessCheck.getHost());
        this.appendIfNotNull(builder, "  app_start_timeout_sec: ", readinessCheck.getAppStartTimeoutSec());
    }

    private void appendResources(AppEngineWebXml.Resources resources, StringBuilder builder) {
        if (!resources.isEmpty()) {
            builder.append("resources:\n");
            this.appendIfNotZero(builder, "  cpu: ", resources.getCpu());
            this.appendIfNotZero(builder, "  memory_gb: ", resources.getMemoryGb());
            this.appendIfNotZero(builder, "  disk_size_gb: ", resources.getDiskSizeGb());
        }
    }

    private void appendNetwork(AppEngineWebXml.Network network, StringBuilder builder) {
        if (!network.isEmpty()) {
            builder.append("network:\n");
            this.appendIfNotNull(builder, "  instance_tag: ", network.getInstanceTag());
            if (!network.getForwardedPorts().isEmpty()) {
                builder.append("  forwarded_ports:\n");
                for (String forwardedPort : network.getForwardedPorts()) {
                    builder.append("  - " + forwardedPort + "\n");
                }
            }
            this.appendIfNotNull(builder, "  name: ", network.getName());
            this.appendIfNotNull(builder, "  subnetwork_name: ", network.getSubnetworkName());
            if (network.getSessionAffinity()) {
                builder.append("  session_affinity: True\n");
            } else {
                builder.append("  session_affinity: False\n");
            }
        }
    }

    private static void appendObjectAsYaml(StringBuilder builder, Object collection, int numIndentSpaces) {
        StringBuilder prefixBuilder = new StringBuilder();
        for (int i = 0; i < numIndentSpaces; ++i) {
            prefixBuilder.append(' ');
        }
        String indentPrefix = prefixBuilder.toString();
        StringWriter stringWriter = new StringWriter();
        YamlConfig yamlConfig = new YamlConfig();
        yamlConfig.writeConfig.setIndentSize(2);
        yamlConfig.writeConfig.setWriteRootTags(false);
        YamlWriter writer = new YamlWriter(stringWriter, yamlConfig);
        try {
            writer.write(collection);
            writer.close();
        }
        catch (YamlException e) {
            throw new AppEngineConfigException("Unable to generate YAML.", e);
        }
        for (String line : stringWriter.toString().split("\n")) {
            builder.append(indentPrefix);
            builder.append(line);
            builder.append("\n");
        }
    }

    private String yamlQuote(String str) {
        return "'" + str.replace("'", "''") + "'";
    }

    private void translateApiVersion(StringBuilder builder) {
        if (this.apiVersion == null) {
            builder.append("api_version: 'none'\n");
        } else {
            builder.append("api_version: '" + this.apiVersion + "'\n");
        }
    }

    private void translateWebXml(StringBuilder builder) {
        builder.append("handlers:\n");
        AbstractHandlerGenerator staticGenerator = null;
        staticGenerator = this.staticFiles.isEmpty() ? new EmptyHandlerGenerator(this) : new StaticHandlerGenerator(this.appEngineWebXml.getPublicRoot());
        DynamicHandlerGenerator dynamicGenerator = new DynamicHandlerGenerator(this.webXml.getFallThroughToRuntime());
        if (staticGenerator.size() + dynamicGenerator.size() > 100) {
            dynamicGenerator = new DynamicHandlerGenerator(true);
        }
        staticGenerator.translate(builder);
        dynamicGenerator.translate(builder);
    }

    private static void extendMeaningOfTrailingStar(GlobIntersector intersector, String pattern, String property, Object value) {
        if (pattern.endsWith("/*") && pattern.length() > 2) {
            intersector.addGlob(GlobFactory.createGlob(pattern.substring(0, pattern.length() - 2), property, value));
        }
    }

    class EmptyHandlerGenerator
    extends AbstractHandlerGenerator {
        EmptyHandlerGenerator(AppYamlTranslator this$0) {
        }

        @Override
        protected void addPatterns(GlobIntersector intersector) {
        }

        @Override
        protected void translateGlob(StringBuilder builder, Glob glob) {
        }

        @Override
        protected Map<String, Object> getWelcomeProperties() {
            return Collections.emptyMap();
        }
    }

    class StaticHandlerGenerator
    extends AbstractHandlerGenerator {
        private final String root;

        public StaticHandlerGenerator(String root) {
            this.root = root;
        }

        @Override
        protected Map<String, Object> getWelcomeProperties() {
            ArrayList<String> staticWelcomeFiles = new ArrayList<String>();
            block0: for (String welcomeFile : AppYamlTranslator.this.webXml.getWelcomeFiles()) {
                for (String staticFile : AppYamlTranslator.this.staticFiles) {
                    if (!staticFile.endsWith("/" + welcomeFile)) continue;
                    staticWelcomeFiles.add(welcomeFile);
                    continue block0;
                }
            }
            return Collections.singletonMap(AppYamlTranslator.WELCOME_FILES, staticWelcomeFiles);
        }

        @Override
        protected void addPatterns(GlobIntersector intersector) {
            List<AppEngineWebXml.StaticFileInclude> includes = AppYamlTranslator.this.appEngineWebXml.getStaticFileIncludes();
            if (includes.isEmpty()) {
                intersector.addGlob(GlobFactory.createGlob("/*", AppYamlTranslator.STATIC_PROPERTY, true));
            } else {
                for (AppEngineWebXml.StaticFileInclude include : includes) {
                    String pattern = include.getPattern().replaceAll("\\*\\*", "*");
                    if (!pattern.startsWith("/")) {
                        pattern = "/" + pattern;
                    }
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put(AppYamlTranslator.STATIC_PROPERTY, true);
                    if (include.getExpiration() != null) {
                        props.put(AppYamlTranslator.EXPIRATION_PROPERTY, include.getExpiration());
                    }
                    if (include.getHttpHeaders() != null) {
                        props.put(AppYamlTranslator.HTTP_HEADERS_PROPERTY, include.getHttpHeaders());
                    }
                    intersector.addGlob(GlobFactory.createGlob(pattern, props));
                }
            }
        }

        @Override
        public void translateGlob(StringBuilder builder, Glob glob) {
            List welcomeFiles;
            String regex = glob.getRegularExpression().pattern();
            if (!this.root.isEmpty() && regex.startsWith(this.root)) {
                regex = regex.substring(this.root.length(), regex.length());
            }
            if ((welcomeFiles = (List)glob.getProperty(AppYamlTranslator.WELCOME_FILES, RESOLVER)) != null) {
                for (String welcomeFile : welcomeFiles) {
                    builder.append("- url: (" + regex + ")\n");
                    builder.append("  static_files: __static__" + this.root + "\\1" + welcomeFile + "\n");
                    builder.append("  upload: __NOT_USED__\n");
                    builder.append("  require_matching_file: True\n");
                    this.translateHandlerOptions(builder, glob);
                    this.translateAdditionalStaticOptions(builder, glob);
                }
            } else {
                Boolean isStatic = (Boolean)glob.getProperty(AppYamlTranslator.STATIC_PROPERTY, RESOLVER);
                if (isStatic != null && isStatic.booleanValue()) {
                    builder.append("- url: (" + regex + ")\n");
                    builder.append("  static_files: __static__" + this.root + "\\1\n");
                    builder.append("  upload: __NOT_USED__\n");
                    builder.append("  require_matching_file: True\n");
                    this.translateHandlerOptions(builder, glob);
                    this.translateAdditionalStaticOptions(builder, glob);
                }
            }
        }

        private void translateAdditionalStaticOptions(StringBuilder builder, Glob glob) throws AppEngineConfigException {
            Map httpHeaders;
            String expiration = (String)glob.getProperty(AppYamlTranslator.EXPIRATION_PROPERTY, RESOLVER);
            if (expiration != null) {
                builder.append("  expiration: " + expiration + "\n");
            }
            if ((httpHeaders = (Map)glob.getProperty(AppYamlTranslator.HTTP_HEADERS_PROPERTY, RESOLVER)) != null && !httpHeaders.isEmpty()) {
                builder.append("  http_headers:\n");
                AppYamlTranslator.appendObjectAsYaml(builder, httpHeaders, 4);
            }
        }
    }

    class DynamicHandlerGenerator
    extends AbstractHandlerGenerator {
        private final List<String> patterns;
        private boolean fallthrough;
        private boolean hasJsps;

        DynamicHandlerGenerator(boolean alwaysFallthrough) {
            this.fallthrough = alwaysFallthrough;
            this.patterns = new ArrayList<String>();
            for (String servletPattern : AppYamlTranslator.this.webXml.getServletPatterns()) {
                if (servletPattern.equals("/") || servletPattern.equals("/*")) {
                    this.fallthrough = true;
                    continue;
                }
                if (servletPattern.equals(AppYamlTranslator.API_ENDPOINT_REGEX)) {
                    this.hasApiEndpoint = true;
                    continue;
                }
                if (servletPattern.endsWith(".jsp")) {
                    this.hasJsps = true;
                    continue;
                }
                if (servletPattern.equals("")) {
                    servletPattern = "/";
                }
                this.patterns.add(servletPattern);
            }
        }

        @Override
        protected Map<String, Object> getWelcomeProperties() {
            if (this.fallthrough) {
                return null;
            }
            return Collections.singletonMap(AppYamlTranslator.DYNAMIC_PROPERTY, true);
        }

        @Override
        protected void addPatterns(GlobIntersector intersector) {
            if (this.fallthrough) {
                intersector.addGlob(GlobFactory.createGlob("/*", AppYamlTranslator.DYNAMIC_PROPERTY, true));
            } else {
                for (String servletPattern : this.patterns) {
                    intersector.addGlob(GlobFactory.createGlob(servletPattern, AppYamlTranslator.DYNAMIC_PROPERTY, true));
                    AppYamlTranslator.extendMeaningOfTrailingStar(intersector, servletPattern, AppYamlTranslator.DYNAMIC_PROPERTY, true);
                }
                if (this.hasJsps) {
                    intersector.addGlob(GlobFactory.createGlob("*.jsp", AppYamlTranslator.DYNAMIC_PROPERTY, true));
                } else if (AppYamlTranslator.this.appEngineWebXml.getUseVm() || AppYamlTranslator.this.appEngineWebXml.isFlexible()) {
                    intersector.addGlob(GlobFactory.createGlob("*.jsp", AppYamlTranslator.DYNAMIC_PROPERTY, true));
                }
                intersector.addGlob(GlobFactory.createGlob("/_ah/*", AppYamlTranslator.DYNAMIC_PROPERTY, true));
            }
        }

        @Override
        public void translateGlob(StringBuilder builder, Glob glob) {
            String regex = glob.getRegularExpression().pattern();
            Boolean isDynamic = (Boolean)glob.getProperty(AppYamlTranslator.DYNAMIC_PROPERTY, RESOLVER);
            if (isDynamic != null && isDynamic.booleanValue()) {
                builder.append("- url: " + regex + "\n");
                builder.append("  script: unused\n");
                this.translateHandlerOptions(builder, glob);
            }
        }
    }

    abstract class AbstractHandlerGenerator {
        private List<Glob> globs = null;
        protected boolean hasApiEndpoint;

        AbstractHandlerGenerator() {
        }

        public int size() {
            return this.getGlobPatterns().size();
        }

        public void translate(StringBuilder builder) {
            for (Glob glob : this.getGlobPatterns()) {
                this.translateGlob(builder, glob);
            }
        }

        protected abstract void addPatterns(GlobIntersector var1);

        protected abstract void translateGlob(StringBuilder var1, Glob var2);

        protected abstract Map<String, Object> getWelcomeProperties();

        protected List<Glob> getGlobPatterns() {
            if (this.globs == null) {
                GlobIntersector intersector = new GlobIntersector();
                this.addPatterns(intersector);
                this.addSecurityConstraints(intersector);
                this.addWelcomeFiles(intersector);
                this.globs = intersector.getIntersection();
                this.removeNearDuplicates(this.globs);
                if (this.hasApiEndpoint) {
                    this.globs.add(GlobFactory.createGlob(AppYamlTranslator.API_ENDPOINT_REGEX, AppYamlTranslator.DYNAMIC_PROPERTY, true));
                }
            }
            return this.globs;
        }

        protected void addWelcomeFiles(GlobIntersector intersector) {
            Map<String, Object> welcomeProperties = this.getWelcomeProperties();
            if (welcomeProperties != null) {
                intersector.addGlob(GlobFactory.createGlob("/", welcomeProperties));
                intersector.addGlob(GlobFactory.createGlob("/*/", welcomeProperties));
            }
        }

        protected void addSecurityConstraints(GlobIntersector intersector) {
            for (WebXml.SecurityConstraint constraint : AppYamlTranslator.this.webXml.getSecurityConstraints()) {
                for (String pattern : constraint.getUrlPatterns()) {
                    intersector.addGlob(GlobFactory.createGlob(pattern, AppYamlTranslator.TRANSPORT_GUARANTEE_PROPERTY, (Object)constraint.getTransportGuarantee()));
                    AppYamlTranslator.extendMeaningOfTrailingStar(intersector, pattern, AppYamlTranslator.TRANSPORT_GUARANTEE_PROPERTY, (Object)constraint.getTransportGuarantee());
                    intersector.addGlob(GlobFactory.createGlob(pattern, AppYamlTranslator.REQUIRED_ROLE_PROPERTY, (Object)constraint.getRequiredRole()));
                    AppYamlTranslator.extendMeaningOfTrailingStar(intersector, pattern, AppYamlTranslator.REQUIRED_ROLE_PROPERTY, (Object)constraint.getRequiredRole());
                }
            }
        }

        protected void translateHandlerOptions(StringBuilder builder, Glob glob) {
            WebXml.SecurityConstraint.RequiredRole requiredRole = (WebXml.SecurityConstraint.RequiredRole)((Object)glob.getProperty(AppYamlTranslator.REQUIRED_ROLE_PROPERTY, RESOLVER));
            if (requiredRole == null) {
                requiredRole = WebXml.SecurityConstraint.RequiredRole.NONE;
            }
            switch (requiredRole) {
                case NONE: {
                    builder.append("  login: optional\n");
                    break;
                }
                case ANY_USER: {
                    builder.append("  login: required\n");
                    break;
                }
                case ADMIN: {
                    builder.append("  login: admin\n");
                }
            }
            WebXml.SecurityConstraint.TransportGuarantee transportGuarantee = (WebXml.SecurityConstraint.TransportGuarantee)((Object)glob.getProperty(AppYamlTranslator.TRANSPORT_GUARANTEE_PROPERTY, RESOLVER));
            if (transportGuarantee == null) {
                transportGuarantee = WebXml.SecurityConstraint.TransportGuarantee.NONE;
            }
            switch (transportGuarantee) {
                case NONE: {
                    if (AppYamlTranslator.this.appEngineWebXml.getSslEnabled()) {
                        builder.append("  secure: optional\n");
                        break;
                    }
                    builder.append("  secure: never\n");
                    break;
                }
                case INTEGRAL: 
                case CONFIDENTIAL: {
                    if (!AppYamlTranslator.this.appEngineWebXml.getSslEnabled()) {
                        throw new AppEngineConfigException("SSL must be enabled in appengine-web.xml to use transport-guarantee");
                    }
                    builder.append("  secure: always\n");
                }
            }
            String pattern = glob.getRegularExpression().pattern();
            String id = AppYamlTranslator.this.webXml.getHandlerIdForPattern(pattern);
            if (id != null && AppYamlTranslator.this.appEngineWebXml.isApiEndpoint(id)) {
                builder.append("  api_endpoint: True\n");
            }
        }

        private void removeNearDuplicates(List<Glob> globs) {
            block0: for (int i = 0; i < globs.size(); ++i) {
                Glob topGlob = globs.get(i);
                for (int j = i + 1; j < globs.size(); ++j) {
                    Glob bottomGlob = globs.get(j);
                    if (!bottomGlob.matchesAll(topGlob)) continue;
                    if (!this.propertiesMatch(topGlob, bottomGlob)) continue block0;
                    globs.remove(i);
                    --i;
                    continue block0;
                }
            }
        }

        private boolean propertiesMatch(Glob glob1, Glob glob2) {
            for (String property : PROPERTIES) {
                Object value2;
                Object value1 = glob1.getProperty(property, RESOLVER);
                if (value1 == (value2 = glob2.getProperty(property, RESOLVER)) || value1 != null && value1.equals(value2)) continue;
                return false;
            }
            return true;
        }
    }
}

