/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.net.InetAddresses;
import com.google.apphosting.utils.config.AppEngineConfigException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class DosXml {
    private List<BlacklistEntry> blacklistEntries = new ArrayList<BlacklistEntry>();

    public BlacklistEntry addNewBlacklistEntry() {
        this.validateLastEntry();
        BlacklistEntry entry = new BlacklistEntry();
        this.blacklistEntries.add(entry);
        return entry;
    }

    public void addBlacklistEntry(BlacklistEntry entry) {
        this.validateLastEntry();
        this.blacklistEntries.add(entry);
        this.validateLastEntry();
    }

    public void validateLastEntry() {
        if (this.blacklistEntries.size() == 0) {
            return;
        }
        BlacklistEntry last = this.blacklistEntries.get(this.blacklistEntries.size() - 1);
        if (last.getSubnet() == null) {
            throw new AppEngineConfigException("no subnet for blacklist");
        }
    }

    public String toYaml() {
        StringBuilder builder = new StringBuilder("blacklist:\n");
        for (BlacklistEntry ent : this.blacklistEntries) {
            builder.append("- subnet: " + ent.getSubnet() + "\n");
            if (ent.getDescription().equals("")) continue;
            builder.append("  description: " + ent.getDescription() + "\n");
        }
        return builder.toString();
    }

    public static class BlacklistEntry {
        String subnet = null;
        String desc = "";

        public void setDescription(String description) {
            this.desc = description.replace('\n', ' ');
        }

        public void setSubnet(String subnet) {
            try {
                BlacklistEntry.validateSubnet(subnet);
                this.subnet = subnet;
            }
            catch (IllegalArgumentException iae) {
                this.subnet = null;
                throw new AppEngineConfigException("subnet " + subnet + " failed to parse", iae.getCause());
            }
        }

        public String getSubnet() {
            return this.subnet;
        }

        public String getDescription() {
            return this.desc;
        }

        private static void validateSubnet(String subnet) {
            int netmask;
            InetAddress inetAddress;
            int slash = subnet.indexOf(47);
            if (slash > -1) {
                String ipAddress = subnet.substring(0, slash);
                inetAddress = InetAddresses.forString(ipAddress);
                String netmaskString = subnet.substring(slash + 1);
                netmask = Integer.parseInt(netmaskString);
            } else {
                inetAddress = InetAddresses.forString(subnet);
                netmask = 0;
            }
            Preconditions.checkArgument(netmask >= 0 && netmask <= inetAddress.getAddress().length * 8);
        }
    }
}

