/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.enhancer;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.tools.enhancer.Enhancer;
import com.google.appengine.tools.info.SdkImplInfo;
import com.google.appengine.tools.util.Logging;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class Enhance {
    static final String DATANUCLEUS_VERSION_ARG = "-enhancerVersion";

    public static void main(String[] args) {
        Logging.initializeLogging();
        new Enhance(args);
    }

    public Enhance(String[] args) {
        PrintWriter writer;
        try {
            File logFile = File.createTempFile("enhance", ".log");
            writer = new PrintWriter((Writer)new FileWriter(logFile), true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to enable logging.", e);
        }
        Set<URL> targets = Enhance.getEnhanceTargets(writer);
        Enhancer enhancer = new Enhancer();
        enhancer.setTargets(targets);
        args = Enhance.processArgs(enhancer, args);
        enhancer.setArgs(args);
        enhancer.execute();
    }

    static String[] processArgs(Enhancer enhancer, String[] args) {
        ArrayList<String> processed = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-") || !args[i].equals(DATANUCLEUS_VERSION_ARG)) {
                processed.add(args[i]);
                continue;
            }
            if (++i == args.length) {
                throw new IllegalArgumentException(String.format("Missing value for option %s", DATANUCLEUS_VERSION_ARG));
            }
            enhancer.setDatanucleusVersion(args[i]);
        }
        return processed.toArray(new String[processed.size()]);
    }

    @VisibleForTesting
    static Set<URL> getEnhanceTargets(PrintWriter writer) {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        URL toolsJar = SdkImplInfo.getToolsApiJar();
        String paths = System.getProperty("java.class.path");
        for (String path : paths.split(File.pathSeparator)) {
            try {
                URL url = new File(path).toURI().toURL();
                if (url.sameFile(toolsJar)) continue;
                urls.add(url);
            }
            catch (MalformedURLException ex) {
                System.out.println("Encountered a problem: " + ex.getMessage());
                ex.printStackTrace(writer);
                System.exit(1);
            }
        }
        return urls;
    }
}

