/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.util;

import com.google.appengine.tools.util.JarMaker;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class JarSplitter
extends JarMaker {
    private static final String INDEX_FILE = "INDEX.LIST";
    private final File inputJar;
    private JarInputStream inputStream;
    private boolean replicateManifests;

    public JarSplitter(File inputJar, File outputDirectory, int maximumSize, boolean replicateManifests, int outputDigits, Set<String> excludes) {
        super(JarSplitter.stripExtension(inputJar, ".jar"), outputDigits, outputDirectory, maximumSize, JarSplitter.addIndexFile(excludes), false);
        this.inputJar = inputJar;
        this.replicateManifests = replicateManifests;
    }

    @Override
    public void run() throws IOException {
        this.inputStream = new JarInputStream(new BufferedInputStream(new FileInputStream(this.inputJar)));
        try {
            super.run();
        }
        finally {
            this.inputStream.close();
        }
    }

    private static String stripExtension(File file, String extension) {
        String name = file.getName();
        if (name.endsWith(extension)) {
            name = name.substring(0, name.length() - extension.length());
        }
        return name;
    }

    private static Set<String> addIndexFile(Set<String> excludes) {
        int numExcludes = excludes == null ? 0 : excludes.size();
        HashSet<String> newSet = new HashSet<String>(numExcludes + 1);
        if (excludes != null) {
            newSet.addAll(excludes);
        }
        newSet.add(INDEX_FILE);
        return newSet;
    }

    @Override
    protected Manifest getManifest() {
        return this.replicateManifests ? this.inputStream.getManifest() : null;
    }

    @Override
    protected JarMaker.JarEntryData getNextJarEntry() throws IOException {
        JarEntry entry = this.inputStream.getNextJarEntry();
        if (entry == null) {
            return null;
        }
        JarEntry newEntry = new JarEntry(entry.getName());
        newEntry.setTime(entry.getTime());
        return new JarMaker.JarEntryData(newEntry, this.inputStream);
    }
}

