/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger;

import com.google.appengine.repackaged.com.google.common.flogger.backend.Platform;
import com.google.appengine.repackaged.com.google.common.flogger.util.Checks;
import java.util.Iterator;

public class MetadataKey<T> {
    private static final int MAX_CUSTOM_METADATAKEY_RECURSION_DEPTH = 20;
    private final String label;
    private final Class<? extends T> clazz;
    private final boolean canRepeat;
    private final boolean isCustom;
    private final long bloomFilterMask;

    public static <T> MetadataKey<T> single(String label, Class<? extends T> clazz) {
        return new MetadataKey<T>(label, clazz, false, false);
    }

    public static <T> MetadataKey<T> repeated(String label, Class<T> clazz) {
        return new MetadataKey<T>(label, clazz, true, false);
    }

    protected MetadataKey(String label, Class<? extends T> clazz, boolean canRepeat) {
        this(label, clazz, canRepeat, true);
    }

    private MetadataKey(String label, Class<? extends T> clazz, boolean canRepeat, boolean isCustom) {
        this.label = Checks.checkMetadataIdentifier(label);
        this.clazz = Checks.checkNotNull(clazz, "class");
        this.canRepeat = canRepeat;
        this.isCustom = isCustom;
        this.bloomFilterMask = this.createBloomFilterMaskFromSystemHashcode();
    }

    public final String getLabel() {
        return this.label;
    }

    public final T cast(Object value) {
        return this.clazz.cast(value);
    }

    public final boolean canRepeat() {
        return this.canRepeat;
    }

    public final void safeEmit(T value, KeyValueHandler kvh) {
        if (this.isCustom && Platform.getCurrentRecursionDepth() > 20) {
            kvh.handle(this.getLabel(), value);
        } else {
            this.emit(value, kvh);
        }
    }

    public final void safeEmitRepeated(Iterator<T> values, KeyValueHandler kvh) {
        Checks.checkState(this.canRepeat, "non repeating key");
        if (this.isCustom && Platform.getCurrentRecursionDepth() > 20) {
            while (values.hasNext()) {
                kvh.handle(this.getLabel(), values.next());
            }
        } else {
            this.emitRepeated(values, kvh);
        }
    }

    protected void emit(T value, KeyValueHandler kvh) {
        kvh.handle(this.getLabel(), value);
    }

    protected void emitRepeated(Iterator<T> values, KeyValueHandler kvh) {
        while (values.hasNext()) {
            this.emit(values.next(), kvh);
        }
    }

    public final long getBloomFilterMask() {
        return this.bloomFilterMask;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final String toString() {
        return this.getClass().getName() + "/" + this.label + "[" + this.clazz.getName() + "]";
    }

    private long createBloomFilterMaskFromSystemHashcode() {
        int hash = System.identityHashCode(this);
        long bloom = 0L;
        for (int n = 0; n < 5; ++n) {
            bloom |= 1L << (hash & 0x3F);
            hash >>>= 6;
        }
        return bloom;
    }

    public static interface KeyValueHandler {
        public void handle(String var1, Object var2);
    }
}

