/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.Utility;
import com.google.apphosting.utils.config.StagingOptions;
import java.io.File;

public class ApplicationProcessingOptions {
    private static final String JAVA_CMD_PROP = "appengine.java";
    private static final String JAVAC_CMD_PROP = "appengine.javac";
    private File java;
    private File javac;
    private boolean compileJsps = true;
    private boolean doBatch = true;
    private boolean useAsyncQuickstart = false;
    private String runtime;
    private boolean allowAnyRuntime = false;
    private boolean failOnPrecompilationError = false;
    private boolean ignoreEndpointsFailures = true;
    private boolean quickstart = false;
    private boolean callerUploadingDispatch = false;
    private StagingOptions stagingOptions = StagingOptions.EMPTY;
    private StagingOptions defaultStagingOptions = StagingOptions.ANCIENT_DEFAULTS;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File getJavaExecutable() {
        if (this.java != null) {
            return this.java;
        }
        String javaProp = System.getProperty(JAVA_CMD_PROP);
        if (javaProp != null) {
            this.java = new File(javaProp);
            if (this.java.exists()) return this.java;
            if (!Utility.isOsWindows() || javaProp.endsWith(".exe") || !new File(javaProp + ".exe").exists()) throw new IllegalStateException("cannot find java executable \"" + javaProp + "\"");
            this.java = new File(javaProp + ".exe");
            return this.java;
        } else {
            String javaHome = System.getProperty("java.home");
            String javaCmd = javaHome + File.separator + "bin" + File.separator + "java" + (Utility.isOsWindows() ? ".exe" : "");
            this.java = new File(javaCmd);
            if (this.java.exists()) return this.java;
            this.java = null;
            throw new IllegalStateException("cannot find java executable based on java.home, tried \"" + javaCmd + "\"");
        }
    }

    void setJavaExecutable(File java) {
        this.java = java;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File getJavaCompiler() {
        if (this.javac != null) {
            return this.javac;
        }
        String javacProp = System.getProperty(JAVAC_CMD_PROP);
        if (javacProp != null) {
            this.javac = new File(javacProp);
            if (this.javac.exists()) return this.javac;
            if (!Utility.isOsWindows() || javacProp.endsWith(".exe") || !new File(javacProp + ".exe").exists()) throw new IllegalStateException("cannot find javac executable \"" + javacProp + "\"");
            this.javac = new File(javacProp + ".exe");
            return this.javac;
        } else {
            String javaHome;
            String javacDir = javaHome = System.getProperty("java.home");
            String javacCmd = javacDir + File.separator + "bin" + File.separator + "javac" + (Utility.isOsWindows() ? ".exe" : "");
            this.javac = new File(javacCmd);
            if (this.javac.exists()) return this.javac;
            this.javac = null;
            javacDir = new File(javaHome).getParentFile().getPath();
            String javacCmd2 = javacDir + File.separator + "bin" + File.separator + "javac" + (Utility.isOsWindows() ? ".exe" : "");
            this.javac = new File(javacCmd2);
            if (this.javac.exists()) return this.javac;
            this.javac = null;
            throw new IllegalStateException("cannot find javac executable based on java.home, tried \"" + javacCmd + "\" and \"" + javacCmd2 + "\"");
        }
    }

    void setJavaCompiler(File javac) {
        this.javac = javac;
    }

    public boolean isCompileJspsSet() {
        return this.compileJsps;
    }

    void setCompileJsps(boolean doJsps) {
        this.compileJsps = doJsps;
    }

    public boolean isBatchModeSet() {
        return this.doBatch;
    }

    void setBatchMode(boolean doBatch) {
        this.doBatch = doBatch;
    }

    public void setUseAsyncQuickstart(boolean b) {
        this.useAsyncQuickstart = b;
    }

    public boolean isUseAsyncQuickstart() {
        return this.useAsyncQuickstart;
    }

    public void setDefaultStagingOptions(StagingOptions opts) {
        this.defaultStagingOptions = opts;
    }

    public StagingOptions getDefaultStagingOptions() {
        return this.defaultStagingOptions;
    }

    public void setStagingOptions(StagingOptions opts) {
        this.stagingOptions = opts;
    }

    public StagingOptions getStagingOptions() {
        return this.stagingOptions;
    }

    public void setRuntime(String s) {
        this.runtime = s;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public void setAllowAnyRuntime(boolean b) {
        this.allowAnyRuntime = b;
    }

    public boolean isAllowAnyRuntime() {
        return this.allowAnyRuntime;
    }

    public void setFailOnPrecompilationError(boolean b) {
        this.failOnPrecompilationError = b;
    }

    public boolean isFailOnPrecompilationError() {
        return this.failOnPrecompilationError;
    }

    public void setIgnoreEndpointsFailures(boolean b) {
        this.ignoreEndpointsFailures = b;
    }

    public boolean isIgnoreEndpointsFailures() {
        return this.ignoreEndpointsFailures;
    }

    public void setQuickstart(boolean b) {
        this.quickstart = b;
    }

    public boolean isQuickstart() {
        return this.quickstart;
    }

    public void setCallerUploadingDispatch(boolean b) {
        this.callerUploadingDispatch = b;
    }

    boolean isCallerUploadingDispatch() {
        return this.callerUploadingDispatch;
    }
}

