package com.google.apphosting.utils.config;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_StagingOptions extends StagingOptions {

  private final Optional<Boolean> splitJarFiles;

  private final Optional<ImmutableSortedSet<String>> splitJarFilesExcludes;

  private final Optional<Boolean> jarJsps;

  private final Optional<Boolean> jarClasses;

  private final Optional<Boolean> deleteJsps;

  private final Optional<String> compileEncoding;

  private AutoValue_StagingOptions(
      Optional<Boolean> splitJarFiles,
      Optional<ImmutableSortedSet<String>> splitJarFilesExcludes,
      Optional<Boolean> jarJsps,
      Optional<Boolean> jarClasses,
      Optional<Boolean> deleteJsps,
      Optional<String> compileEncoding) {
    this.splitJarFiles = splitJarFiles;
    this.splitJarFilesExcludes = splitJarFilesExcludes;
    this.jarJsps = jarJsps;
    this.jarClasses = jarClasses;
    this.deleteJsps = deleteJsps;
    this.compileEncoding = compileEncoding;
  }

  @Override
  public Optional<Boolean> splitJarFiles() {
    return splitJarFiles;
  }

  @Override
  public Optional<ImmutableSortedSet<String>> splitJarFilesExcludes() {
    return splitJarFilesExcludes;
  }

  @Override
  public Optional<Boolean> jarJsps() {
    return jarJsps;
  }

  @Override
  public Optional<Boolean> jarClasses() {
    return jarClasses;
  }

  @Override
  public Optional<Boolean> deleteJsps() {
    return deleteJsps;
  }

  @Override
  public Optional<String> compileEncoding() {
    return compileEncoding;
  }

  @Override
  public String toString() {
    return "StagingOptions{"
        + "splitJarFiles=" + splitJarFiles + ", "
        + "splitJarFilesExcludes=" + splitJarFilesExcludes + ", "
        + "jarJsps=" + jarJsps + ", "
        + "jarClasses=" + jarClasses + ", "
        + "deleteJsps=" + deleteJsps + ", "
        + "compileEncoding=" + compileEncoding
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof StagingOptions) {
      StagingOptions that = (StagingOptions) o;
      return this.splitJarFiles.equals(that.splitJarFiles())
          && this.splitJarFilesExcludes.equals(that.splitJarFilesExcludes())
          && this.jarJsps.equals(that.jarJsps())
          && this.jarClasses.equals(that.jarClasses())
          && this.deleteJsps.equals(that.deleteJsps())
          && this.compileEncoding.equals(that.compileEncoding());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= splitJarFiles.hashCode();
    h$ *= 1000003;
    h$ ^= splitJarFilesExcludes.hashCode();
    h$ *= 1000003;
    h$ ^= jarJsps.hashCode();
    h$ *= 1000003;
    h$ ^= jarClasses.hashCode();
    h$ *= 1000003;
    h$ ^= deleteJsps.hashCode();
    h$ *= 1000003;
    h$ ^= compileEncoding.hashCode();
    return h$;
  }

  @Override
  public StagingOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends StagingOptions.Builder {
    private Optional<Boolean> splitJarFiles = Optional.empty();
    private Optional<ImmutableSortedSet<String>> splitJarFilesExcludes = Optional.empty();
    private Optional<Boolean> jarJsps = Optional.empty();
    private Optional<Boolean> jarClasses = Optional.empty();
    private Optional<Boolean> deleteJsps = Optional.empty();
    private Optional<String> compileEncoding = Optional.empty();
    Builder() {
    }
    private Builder(StagingOptions source) {
      this.splitJarFiles = source.splitJarFiles();
      this.splitJarFilesExcludes = source.splitJarFilesExcludes();
      this.jarJsps = source.jarJsps();
      this.jarClasses = source.jarClasses();
      this.deleteJsps = source.deleteJsps();
      this.compileEncoding = source.compileEncoding();
    }
    @Override
    public StagingOptions.Builder setSplitJarFiles(Optional<Boolean> splitJarFiles) {
      if (splitJarFiles == null) {
        throw new NullPointerException("Null splitJarFiles");
      }
      this.splitJarFiles = splitJarFiles;
      return this;
    }
    @Override
    public StagingOptions.Builder setSplitJarFilesExcludes(Optional<ImmutableSortedSet<String>> splitJarFilesExcludes) {
      if (splitJarFilesExcludes == null) {
        throw new NullPointerException("Null splitJarFilesExcludes");
      }
      this.splitJarFilesExcludes = splitJarFilesExcludes;
      return this;
    }
    @Override
    public StagingOptions.Builder setJarJsps(Optional<Boolean> jarJsps) {
      if (jarJsps == null) {
        throw new NullPointerException("Null jarJsps");
      }
      this.jarJsps = jarJsps;
      return this;
    }
    @Override
    public StagingOptions.Builder setJarClasses(Optional<Boolean> jarClasses) {
      if (jarClasses == null) {
        throw new NullPointerException("Null jarClasses");
      }
      this.jarClasses = jarClasses;
      return this;
    }
    @Override
    public StagingOptions.Builder setDeleteJsps(Optional<Boolean> deleteJsps) {
      if (deleteJsps == null) {
        throw new NullPointerException("Null deleteJsps");
      }
      this.deleteJsps = deleteJsps;
      return this;
    }
    @Override
    public StagingOptions.Builder setCompileEncoding(Optional<String> compileEncoding) {
      if (compileEncoding == null) {
        throw new NullPointerException("Null compileEncoding");
      }
      this.compileEncoding = compileEncoding;
      return this;
    }
    @Override
    public StagingOptions build() {
      return new AutoValue_StagingOptions(
          this.splitJarFiles,
          this.splitJarFilesExcludes,
          this.jarJsps,
          this.jarClasses,
          this.deleteJsps,
          this.compileEncoding);
    }
  }

}
