/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSortedSet;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.tools.admin.AdminException;
import com.google.appengine.tools.admin.AppAdmin;
import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.Application;
import com.google.appengine.tools.admin.UpdateFailureEvent;
import com.google.appengine.tools.admin.UpdateListener;
import com.google.appengine.tools.admin.UpdateProgressEvent;
import com.google.appengine.tools.admin.UpdateSuccessEvent;
import com.google.appengine.tools.util.Action;
import com.google.appengine.tools.util.ActionsAndOptions;
import com.google.appengine.tools.util.Logging;
import com.google.appengine.tools.util.Option;
import com.google.appengine.tools.util.Parser;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.EarHelper;
import com.google.apphosting.utils.config.EarInfo;
import com.google.apphosting.utils.config.StagingOptions;
import com.google.apphosting.utils.config.WebModule;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppCfg {
    private static final String OVERRIDE_MODULE_SHORT_ARG = "M";
    private static final String OVERRIDE_MODULE_LONG_ARG = "module";
    private AppCfgAction action;
    private String applicationDirectory;
    private String moduleName;
    private AppAdmin admin;
    private StagingOptions defaultStagingOptions = null;
    private StagingOptions.Builder stagingFlagsBuilder = null;
    private boolean disablePrompt = false;
    private File logFile = null;
    private String overrideAppId;
    private String overrideModule;
    private String overrideAppVersion;
    private boolean useAsyncQuickstart = false;
    private String runtime;
    private boolean allowAnyRuntime = false;
    private boolean disableUpdateCheck = false;
    private boolean failOnPrecompilationError = false;
    private boolean enableQuickstart = false;
    private static final List<String> generalOptionNamesInHelpOrder = ImmutableList.of("server", "application", "module", "version");
    private static final List<String> optionNamesInHelpOrder = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(generalOptionNamesInHelpOrder)).add(new String[]{"enable_new_staging_defaults", "enable_jar_splitting", "jar_splitting_excludes", "disable_jar_jsps", "enable_jar_classes", "delete_jsps", "retain_upload_dir", "compile_encoding", "num_days", "severity", "include_all", "append", "num_runs", "force", "no_usage_reporting", "use_google_application_default_credentials", "service_account_json_key_file", "auto_update_dispatch"})).build();
    private static final List<String> actionNamesInHelpOrder = ImmutableList.of("help", "download_app", "request_logs", "rollback", "start_module_version", "stop_module_version", "update", "update_indexes", "update_cron", "update_queues", "update_dispatch", "update_dos", new String[]{"version", "set_default_version", "cron_info", "resource_limits_info", "vacuum_indexes", "backends list", "backends update", "backends rollback", "backends start", "backends stop", "backends delete", "backends configure", "list_versions", "delete_version"});
    private String helpText = null;
    private final List<Option> builtInOptions = Arrays.asList(new Option("h", "help", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -h, --help            Show the help message and exit.");
        }

        @Override
        public void apply() {
            AppCfg.this.printHelp();
            System.exit(1);
        }
    }, new Option("s", "server", false){

        @Override
        public void apply() {
        }
    }, new Option("e", "email", false){

        @Override
        public void apply() {
        }
    }, new Option("H", "host", false){

        @Override
        public void apply() {
        }
    }, new Option("p", "proxy", false){

        @Override
        public void apply() {
        }
    }, new Option(null, "proxy_https", false){

        @Override
        public void apply() {
        }
    }, new Option(null, "insecure", true){

        @Override
        public void apply() {
        }
    }, new Option(null, "ignore_bad_cert", true){

        @Override
        public void apply() {
        }
    }, new Option(null, "no_cookies", true){

        @Override
        public void apply() {
        }
    }, new Option("f", "force", true){

        @Override
        public void apply() {
        }
    }, new Option("a", "append", true){

        @Override
        public void apply() {
        }
    }, new Option("n", "num_days", false){

        @Override
        public void apply() {
        }
    }, new Option(null, "num_runs", false){

        @Override
        public void apply() {
        }
    }, new Option(null, "severity", false){

        @Override
        public void apply() {
        }
    }, new Option(null, "include_all", true){

        @Override
        public void apply() {
        }
    }, new Option(null, "sdk_root", false){

        @Override
        public void apply() {
        }
    }, new Option(null, "enable_new_staging_defaults", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --enable_new_staging_defaults", "                        Use new set of staging options defaults (recommended).", "                        --enable_jar_splitting, --enable_jar_classes, and ", "                        --delete_jsps will all be set to true.");
        }

        @Override
        public void apply() {
            AppCfg.this.defaultStagingOptions = StagingOptions.SANE_DEFAULTS;
        }
    }, new Option(null, "disable_jar_jsps", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --disable_jar_jsps", "                        Do not jar the classes generated from JSPs.");
        }

        @Override
        public void apply() {
            AppCfg.this.stagingFlagsBuilder.setJarJsps(Optional.of(false));
        }
    }, new Option(null, "enable_jar_classes", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --enable_jar_classes", "                        Jar the WEB-INF/classes content.");
        }

        @Override
        public void apply() {
            AppCfg.this.stagingFlagsBuilder.setJarClasses(Optional.of(true));
        }
    }, new Option(null, "delete_jsps", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --delete_jsps", "                        Delete the JSP source files after compilation.");
        }

        @Override
        public void apply() {
            AppCfg.this.stagingFlagsBuilder.setDeleteJsps(Optional.of(true));
        }
    }, new Option(null, "use_async_quickstart", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --use_async_quickstart", "                        Use Servlet Async mode.");
        }

        @Override
        public void apply() {
            AppCfg.this.useAsyncQuickstart = true;
        }
    }, new Option(null, "enable_jar_splitting", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --enable_jar_splitting", "                        Split large jar files (> 10M) into smaller fragments.");
        }

        @Override
        public void apply() {
            AppCfg.this.stagingFlagsBuilder.setSplitJarFiles(Optional.of(true));
        }
    }, new Option(null, "jar_splitting_excludes", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --jar_splitting_excludes=SUFFIXES", "                        When --enable-jar-splitting is set, files that match", "                        the list of comma separated SUFFIXES will be excluded", "                        from all jars.");
        }

        @Override
        public void apply() {
            AppCfg.this.stagingFlagsBuilder.setSplitJarFilesExcludes(Optional.of(ImmutableSortedSet.copyOf((Comparable[])this.getValue().split(","))));
        }
    }, new Option(null, "disable_update_check", true){

        @Override
        public void apply() {
        }
    }, new Option("M", "module", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -M MODULE, --module=MODULE", "                        Override module from appengine-web.xml or app.yaml");
        }

        @Override
        public void apply() {
            AppCfg.this.overrideModule = this.getValue();
        }
    }, new Option("V", "version", false){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  -V VERSION, --version=VERSION", "                        Override (major) version from appengine-web.xml or app.yaml");
        }

        @Override
        public void apply() {
            AppCfg.this.overrideAppVersion = this.getValue();
        }
    }, new Option(null, "noisy", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --noisy", "                        Log much more information about what the tool is doing.");
        }

        @Override
        public void apply() {
            Logger rootLogger = Logger.getLogger("");
            rootLogger.getHandlers()[0].setLevel(Level.ALL);
        }
    }, new Option("r", "runtime", false){

        @Override
        public void apply() {
            AppCfg.this.runtime = this.getValue();
        }
    }, new Option("R", "allow_any_runtime", true){

        @Override
        public void apply() {
            AppCfg.this.allowAnyRuntime = true;
        }
    }, new Option(null, "fail_on_precompilation_error", true){

        @Override
        public void apply() {
            AppCfg.this.failOnPrecompilationError = true;
        }
    }, new Option(null, "enable_quickstart", true){

        @Override
        public List<String> getHelpLines() {
            return ImmutableList.of("  --enable_quickstart", "                        Use jetty quickstart to process servlet annotations");
        }

        @Override
        public void apply() {
            AppCfg.this.enableQuickstart = true;
        }
    });
    private final List<Action> builtInActions = Arrays.asList(new HelpAction(), new StagingAction());
    private Map<String, Option> builtInOptionMap;
    private final ActionsAndOptions actionsAndOptions = this.buildActionsAndOptions();

    public static void main(String[] args) {
        Logging.initializeLogging();
        new AppCfg(args);
    }

    @CanIgnoreReturnValue
    protected AppCfg(String[] cmdLineArgs) {
        this(new AppAdminFactory(), cmdLineArgs);
    }

    public AppCfg(AppAdminFactory factory, String[] cmdLineArgs) {
        PrintWriter logWriter;
        Parser parser = new Parser();
        this.defaultStagingOptions = StagingOptions.ANCIENT_DEFAULTS;
        this.stagingFlagsBuilder = StagingOptions.builder();
        try {
            this.logFile = File.createTempFile("appcfg", ".log");
            logWriter = new PrintWriter((Writer)new FileWriter(this.logFile), true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to enable logging.", e);
        }
        try {
            Parser.ParseResult result = parser.parseArgs(this.actionsAndOptions.actions, this.actionsAndOptions.options, cmdLineArgs);
            this.action = (AppCfgAction)result.getAction();
            this.validateCommandLineForEar();
            try {
                result.applyArgs();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace(logWriter);
                System.out.println("Bad argument: " + e.getMessage());
                System.out.println(this.action.getHelpString());
                System.exit(1);
            }
            if (this.applicationDirectory != null) {
                File appDirectoryFile = new File(this.applicationDirectory);
                this.validateApplicationDirectory(appDirectoryFile);
                factory.setDefaultStagingOptions(this.defaultStagingOptions);
                factory.setStagingOptions(this.stagingFlagsBuilder.build());
                factory.setUseAsyncQuickstart(this.useAsyncQuickstart);
                factory.setRuntime(this.runtime);
                factory.setAllowAnyRuntime(this.allowAnyRuntime);
                factory.setFailOnPrecompilationError(this.failOnPrecompilationError);
                factory.setQuickstart(this.enableQuickstart);
                System.out.println("Reading application configuration data...");
            }
            Iterable<Application> applications = this.readApplication();
            this.validateApplications(applications, this.action instanceof StagingAction);
            this.executeAction(factory, applications, logWriter, this.action);
            System.out.println("Success.");
            this.cleanStaging(applications);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(logWriter);
            System.out.println("Bad argument: " + e.getMessage());
            this.printHelp();
            System.exit(1);
        }
        catch (AppEngineConfigException e) {
            e.printStackTrace(logWriter);
            System.out.println("Bad configuration: " + e.getMessage());
            if (e.getCause() != null) {
                System.out.println("  Caused by: " + e.getCause().getMessage());
            }
            this.printLogLocation();
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println("Encountered a problem: " + e.getMessage());
            e.printStackTrace(logWriter);
            this.printLogLocation();
            System.exit(1);
        }
    }

    private void validateCommandLineForEar() {
        if (EarHelper.isEar(this.applicationDirectory)) {
            if (!this.action.isEarAction()) {
                throw new IllegalArgumentException("The requested action does not support EAR configurations");
            }
            if (this.overrideModule != null) {
                throw new IllegalArgumentException("With an EAR configuration -M/--module is not allowed.");
            }
        }
    }

    private Iterable<Application> readApplication() throws IOException {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        if (this.applicationDirectory != null) {
            if (EarHelper.isEar(this.applicationDirectory, false)) {
                EarInfo earInfo = EarHelper.readEarInfo(this.applicationDirectory, new File(Application.getSdkDocsDir(), "appengine-application.xsd"));
                String applicationId = this.overrideAppId != null ? this.overrideAppId : earInfo.getAppengineApplicationXml().getApplicationId();
                for (WebModule webModule : earInfo.getWebModules()) {
                    System.out.println("Processing module " + webModule.getModuleName());
                    resultBuilder.add(this.readWar(webModule.getApplicationDirectory().getAbsolutePath(), applicationId, null));
                    String contextRootWarning = "Ignoring application.xml context-root element, for details see https://developers.google.com/appengine/docs/java/modules/#config";
                    System.out.println(contextRootWarning);
                }
            } else {
                resultBuilder.add(this.readWar(this.applicationDirectory, this.overrideAppId, this.overrideModule));
            }
        }
        return resultBuilder.build();
    }

    private void validateApplications(Iterable<Application> applications, boolean isStaging) {
        for (Application application : applications) {
            if (isStaging) {
                application.validateForStaging();
                continue;
            }
            application.validate();
        }
    }

    private Application readWar(String warDirectory, String applicationIdOrNull, String moduleNameOrNull) throws IOException {
        Application application = Application.readApplication(warDirectory, applicationIdOrNull, moduleNameOrNull, this.overrideAppVersion);
        application.setListener(new UpdateListener(){

            @Override
            public void onProgress(UpdateProgressEvent event) {
                System.out.println(event.getPercentageComplete() + "% " + event.getMessage());
            }

            @Override
            public void onSuccess(UpdateSuccessEvent event) {
                System.out.println("Operation complete.");
            }

            @Override
            public void onFailure(UpdateFailureEvent event) {
                System.out.println(event.getFailureMessage());
            }
        });
        return application;
    }

    private void newAdmin(AppAdminFactory factory, Application application, PrintWriter logWriter, boolean firstModule) {
        this.admin = factory.createAppAdmin(application, logWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAction(AppAdminFactory factory, Iterable<Application> applications, PrintWriter logWriter, AppCfgAction executeMe) {
        try {
            if (applications.iterator().hasNext()) {
                Application firstApplication = null;
                for (Application application : applications) {
                    if (firstApplication == null) {
                        firstApplication = application;
                    }
                    boolean doJsps = !application.getAppEngineWebXml().getUseVm() && !application.getAppEngineWebXml().isFlexible();
                    factory.setCompileJsps(doJsps);
                    this.newAdmin(factory, application, logWriter, application.equals(firstApplication));
                    this.moduleName = WebModule.getModuleName(application.getAppEngineWebXml());
                    try {
                        System.out.printf("%n%nBeginning interaction for module %s...%n", this.moduleName);
                        executeMe.execute();
                    }
                    finally {
                        this.moduleName = null;
                    }
                }
            } else {
                this.admin = factory.createAppAdmin(null, logWriter);
                executeMe.execute();
            }
        }
        catch (AdminException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace(logWriter);
            this.printLogLocation();
            System.exit(1);
        }
        finally {
            this.admin = null;
        }
    }

    private void cleanStaging(Iterable<Application> applications) throws IOException {
        for (Application application : applications) {
            if (application == null) continue;
            String moduleName = WebModule.getModuleName(application.getAppEngineWebXml());
            File stage = application.getStagingDir();
            if (stage == null) {
                System.out.printf("Temporary staging directory was not needed, and not created for module %s%n", moduleName);
                continue;
            }
            System.out.printf("Temporary staging for module %s directory left in %s%n", moduleName, stage.getCanonicalPath());
        }
    }

    private void printLogLocation() {
        if (this.logFile != null) {
            System.out.println("Please see the logs [" + this.logFile.getAbsolutePath() + "] for further information.");
        }
    }

    private void printHelp() {
        if (this.helpText == null) {
            ArrayList<String> helpLines = new ArrayList<String>();
            helpLines.add("usage: AppCfg [options] <action> [<app-dir>] [<argument>]");
            helpLines.add("");
            helpLines.add("Action must be one of:");
            for (String actionName : this.actionsAndOptions.actionNames) {
                Action action = this.actionsAndOptions.getAction(actionName);
                if (action == null) continue;
                helpLines.add("  " + actionName + ": " + action.getShortDescription());
            }
            helpLines.add("Use 'help <action>' for a detailed description.");
            helpLines.add("");
            helpLines.add("options:");
            for (String optionName : this.actionsAndOptions.optionNames) {
                Option option = this.actionsAndOptions.getOption(optionName);
                if (option == null) continue;
                helpLines.addAll(option.getHelpLines());
            }
            this.helpText = Joiner.on("\n").join(helpLines);
        }
        System.out.println(this.helpText);
        System.out.println();
    }

    private List<Option> builtInOptions(String ... optionNames) {
        if (this.builtInOptionMap == null) {
            this.builtInOptionMap = new HashMap<String, Option>(this.builtInOptions.size());
            for (Option option : this.builtInOptions) {
                this.builtInOptionMap.put(option.getLongName(), option);
            }
        }
        ArrayList<Option> options = new ArrayList<Option>();
        for (String name : optionNames) {
            Option option = this.builtInOptionMap.get(name);
            if (option == null) continue;
            options.add(option);
        }
        return options;
    }

    private ActionsAndOptions buildActionsAndOptions() {
        ActionsAndOptions actionsAndOptions = this.getBuiltInActionsAndOptions();
        return actionsAndOptions;
    }

    private ActionsAndOptions getBuiltInActionsAndOptions() {
        ActionsAndOptions actionsAndOptions = new ActionsAndOptions();
        actionsAndOptions.actions = this.builtInActions;
        actionsAndOptions.actionNames = actionNamesInHelpOrder;
        actionsAndOptions.options = this.builtInOptions;
        actionsAndOptions.optionNames = optionNamesInHelpOrder;
        actionsAndOptions.generalOptionNames = generalOptionNamesInHelpOrder;
        return actionsAndOptions;
    }

    private void validateApplicationDirectory(File war) {
        if (!war.exists()) {
            System.out.println("Unable to find the webapp directory " + war);
            this.printHelp();
            System.exit(1);
        } else if (!war.isDirectory()) {
            System.out.println("appcfg only accepts webapp directories, not war files.");
            this.printHelp();
            System.exit(1);
        }
    }

    class StagingAction
    extends AppCfgAction {
        private File stagingDir;
        private boolean useRemoteResourceLimits;

        StagingAction() {
            super(AppCfg.this.builtInOptions(new String[]{"enable_new_staging_defaults", "enable_jar_splitting", "use_remote_resource_limits", "quickstart", "jar_splitting_excludes", "retain_upload_dir", "compile_encoding", "disable_jar_jsps", "delete_jsps", "enable_jar_classes"}), "stage");
            this.useRemoteResourceLimits = false;
            this.shortDescription = "Generate a deploy-ready application directory";
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() != 2) {
                throw new IllegalArgumentException("Expected <app-dir> <staging-dir>");
            }
            this.stagingDir = new File(this.getArgs().get(1));
        }

        @Override
        public void execute() {
            AppCfg.this.admin.stageApplicationWithDefaultResourceLimits(this.stagingDir);
        }

        @Override
        protected List<String> getInitialHelpLines() {
            return ImmutableList.of("AppCfg [options] stage <app-dir> <staging-dir>", "", "Generate a deploy-ready application directory");
        }
    }

    class HelpAction
    extends AppCfgAction {
        HelpAction() {
            super("help");
            this.shortDescription = "Print help for a specific action.";
        }

        @Override
        public void apply() {
            if (this.getArgs().isEmpty()) {
                AppCfg.this.printHelp();
            } else {
                Action foundAction = Parser.lookupAction(((AppCfg)AppCfg.this).actionsAndOptions.actions, this.getArgs().toArray(new String[0]), 0);
                if (foundAction == null) {
                    System.out.println("No such command \"" + this.getArgs().get(0) + "\"\n\n");
                    AppCfg.this.printHelp();
                } else {
                    System.out.println(foundAction.getHelpString());
                    System.out.println();
                }
            }
            System.exit(1);
        }

        @Override
        public void execute() {
        }

        @Override
        protected List<String> getHelpLines() {
            return ImmutableList.of("AppCfg help <command>", "", "Prints help about a specific command.", "");
        }
    }

    abstract class AppCfgAction
    extends Action {
        AppCfgAction(String ... names) {
            this((List<Option>)null, names);
        }

        AppCfgAction(List<Option> options, String ... names) {
            super(options, names);
        }

        @Override
        protected void setArgs(List<String> args) {
            super.setArgs(args);
        }

        @Override
        public void apply() {
            if (this.getArgs().size() < 1) {
                throw new IllegalArgumentException("Expected the application directory as an argument after the action name.");
            }
            AppCfg.this.applicationDirectory = this.getArgs().get(0);
            AppCfg.this.validateCommandLineForEar();
        }

        public abstract void execute();

        @Override
        protected List<String> getHelpLines() {
            ArrayList<String> helpLines = new ArrayList<String>();
            helpLines.addAll(this.getInitialHelpLines());
            helpLines.add("");
            helpLines.add("Options:");
            for (String optionName : ((AppCfg)AppCfg.this).actionsAndOptions.generalOptionNames) {
                Option option = AppCfg.this.actionsAndOptions.getOption(optionName);
                if (option == null) continue;
                helpLines.addAll(option.getHelpLines());
            }
            if (this.extraOptions != null) {
                for (Option option : this.extraOptions) {
                    helpLines.addAll(option.getHelpLines());
                }
            }
            return helpLines;
        }

        protected List<String> getInitialHelpLines() {
            return ImmutableList.of();
        }

        protected boolean isEarAction() {
            return false;
        }

        protected void outputBackendsMessage() {
            System.out.println("Warning: This application uses Backends, a deprecated feature that has been replaced by Modules, which offers additional functionality. Please convert your backends to modules as described at: https://developers.google.com/appengine/docs/java/modules/converting.");
        }
    }
}

