/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineApplicationXml;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.InputStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AppEngineApplicationXmlReader {
    public AppEngineApplicationXml processXml(InputStream is) throws AppEngineConfigException {
        AppEngineApplicationXml.Builder builder = new AppEngineApplicationXml.Builder();
        String applicationId = "";
        Element root = XmlUtils.parseXml(is).getDocumentElement();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element elt = (Element)node;
            if (elt.getTagName().equals("application")) {
                applicationId = XmlUtils.getText(elt);
                continue;
            }
            throw new AppEngineConfigException("Unrecognized element <" + elt.getTagName() + "> in appengine-application.xml.");
        }
        if (applicationId.isEmpty()) {
            throw new AppEngineConfigException("Missing or empty <application> element in appengine-application.xml.");
        }
        return builder.setApplicationId(applicationId).build();
    }
}

