/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib;

import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.hash.Funnel;
import com.google.appengine.repackaged.com.google.common.hash.HashCode;
import com.google.appengine.repackaged.com.google.common.hash.HashFunction;
import com.google.appengine.repackaged.com.google.common.hash.PrimitiveSink;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.common.io.ByteSource;
import com.google.appengine.repackaged.com.google.common.io.CharSource;
import com.google.appengine.repackaged.com.google.common.math.LongMath;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.ByteBuffer;

public final class ByteStrings {
    private static final Converter<ByteString, String> BYTESTRING_TO_STRING_CONVERTER = new Converter<ByteString, String>(){

        @Override
        protected String doForward(ByteString b) {
            return b.toStringUtf8();
        }

        @Override
        protected ByteString doBackward(String a) {
            return ByteString.copyFromUtf8(a);
        }
    };
    private static final Converter<ByteString, byte[]> BYTESTRING_TO_BYTES_CONVERTER = new Converter<ByteString, byte[]>(){

        @Override
        protected byte[] doForward(ByteString byteString) {
            return byteString.toByteArray();
        }

        @Override
        protected ByteString doBackward(byte[] byteArray) {
            return ByteString.copyFrom(byteArray);
        }
    };
    private static final Funnel<ByteString> BYTE_STRING_FUNNEL = new Funnel<ByteString>(){

        @Override
        public void funnel(ByteString from, PrimitiveSink into) {
            for (ByteBuffer buf : from.asReadOnlyByteBufferList()) {
                into.putBytes(buf);
            }
        }
    };

    private ByteStrings() {
    }

    public static Converter<ByteString, String> stringConverter() {
        return BYTESTRING_TO_STRING_CONVERTER;
    }

    public static Converter<ByteString, byte[]> bytesConverter() {
        return BYTESTRING_TO_BYTES_CONVERTER;
    }

    public static ByteString toByteString(ByteSource byteSource) throws IOException {
        if (byteSource instanceof ByteStringSource) {
            return ((ByteStringSource)byteSource).byteString;
        }
        long size = byteSource.size();
        if (size > Integer.MAX_VALUE) {
            throw new IOException("Too big");
        }
        ByteString.Output out = ByteString.newOutput((int)size);
        byteSource.copyTo(out);
        return out.toByteString();
    }

    public static ByteSource asByteSource(ByteString byteString) {
        return new ByteStringSource(byteString);
    }

    public static ImmutableList<ByteString> partition(ByteString bytes, int limit) {
        Preconditions.checkArgument(limit > 0, "limit is non-positive: %s", limit);
        if (bytes.size() <= limit) {
            return ImmutableList.of(bytes);
        }
        int offset = 0;
        ImmutableList.Builder builder = ImmutableList.builder();
        while (offset < bytes.size()) {
            int nextOffset = Math.min(offset + limit, bytes.size());
            builder.add(bytes.substring(offset, nextOffset));
            offset = nextOffset;
        }
        return builder.build();
    }

    public static Funnel<ByteString> funnel() {
        return BYTE_STRING_FUNNEL;
    }

    public static HashCode hash(ByteString bytes, HashFunction fn) {
        return fn.hashObject(bytes, ByteStrings.funnel());
    }

    public static String encode(ByteString bytes, BaseEncoding encoding) {
        StringWriter writer = new StringWriter();
        try (OutputStream out = encoding.encodingStream(writer);){
            bytes.writeTo(out);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return writer.toString();
    }

    public static ByteString decode(CharSequence encoded, BaseEncoding encoding) {
        try {
            return ByteStrings.decodeChecked(encoded, encoding);
        }
        catch (BaseEncoding.DecodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ByteString decodeChecked(CharSequence encoded, BaseEncoding encoding) throws BaseEncoding.DecodingException {
        ByteString.Output out = ByteString.newOutput(encoded.length());
        try {
            encoding.decodingSource(CharSource.wrap(encoded)).copyTo(out);
        }
        catch (BaseEncoding.DecodingException e) {
            throw e;
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return out.toByteString();
    }

    private static final class ByteStringSource
    extends ByteSource {
        final ByteString byteString;

        ByteStringSource(ByteString byteString) {
            this.byteString = Preconditions.checkNotNull(byteString);
        }

        @Override
        public InputStream openStream() {
            return this.byteString.newInput();
        }

        @Override
        public InputStream openBufferedStream() {
            return this.openStream();
        }

        @Override
        public boolean isEmpty() {
            return this.byteString.isEmpty();
        }

        @Override
        public long size() {
            return this.byteString.size();
        }

        @Override
        public Optional<Long> sizeIfKnown() {
            return Optional.of(this.size());
        }

        @Override
        public byte[] read() {
            return this.byteString.toByteArray();
        }

        @Override
        public long copyTo(OutputStream output) throws IOException {
            this.byteString.writeTo(output);
            return this.size();
        }

        @Override
        public ByteSource slice(long offset, long length) {
            Preconditions.checkArgument(offset >= 0L, "offset is negative: %s", offset);
            Preconditions.checkArgument(length >= 0L, "length is negative: %s", length);
            int size = this.byteString.size();
            return ByteStrings.asByteSource(this.byteString.substring(Math.min(size, Ints.saturatedCast(offset)), Math.min(size, Ints.saturatedCast(LongMath.saturatedAdd(offset, length)))));
        }

        @Override
        public boolean contentEquals(ByteSource other) throws IOException {
            if (other instanceof ByteStringSource) {
                return this.byteString.equals(((ByteStringSource)other).byteString);
            }
            return super.contentEquals(other);
        }
    }
}

