/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.resource;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;

public final class ResourceExtractor {
    private ResourceExtractor() {
    }

    public static void toFile(String resourcePath, String dstPath) {
        try {
            ResourceExtractor.toFileThrow(resourcePath, dstPath);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static void toFileThrow(String resourcePath, String dstPath) throws IOException, URISyntaxException {
        URL resourceUrl = Resources.getResource(resourcePath);
        switch (resourceUrl.getProtocol()) {
            case "jar": {
                ResourceExtractor.toFileFromJar(resourceUrl, dstPath);
                break;
            }
            case "file": {
                ResourceExtractor.toFileFromFile(resourceUrl, dstPath);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unimplemented URL protocol: %s", resourceUrl.getProtocol()));
            }
        }
    }

    private static void toFileFromFile(URL resourceUrl, String dstPath) throws IOException, URISyntaxException {
        File root = new File(resourceUrl.getPath());
        if (root.isFile()) {
            try (InputStream inputStream = resourceUrl.openStream();){
                Files.copy(inputStream, Paths.get(dstPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                return;
            }
        }
        Path rootPath = Paths.get(resourceUrl.toURI());
        try (Stream<Path> stream = Files.walk(rootPath, new FileVisitOption[0]);){
            stream.forEach(p -> {
                String suffix = p.toString().substring(root.toString().length());
                Path dst = Paths.get(dstPath, suffix);
                if (p.toFile().isDirectory()) {
                    dst.toFile().mkdirs();
                } else {
                    ResourceExtractor.copy(p, dst);
                }
            });
        }
    }

    private static void toFileFromJar(URL resourceUrl, String dstPath) throws IOException, URISyntaxException {
        JarURLConnection jarConnection = (JarURLConnection)resourceUrl.openConnection();
        jarConnection.connect();
        String resourcePath = jarConnection.getEntryName();
        try (FileSystem fileSystem = FileSystems.newFileSystem(resourceUrl.toURI(), ImmutableMap.of());
             JarFile jarFile = jarConnection.getJarFile();){
            Path rootPath = fileSystem.getPath(resourcePath, new String[0]);
            try (Stream<Path> stream = Files.walk(rootPath, new FileVisitOption[0]);){
                stream.forEach(p -> {
                    String pathString = p.toString();
                    if (pathString.startsWith("/")) {
                        pathString = pathString.substring(1);
                    }
                    String suffix = pathString.substring(resourcePath.length());
                    Path dst = Paths.get(dstPath, suffix);
                    JarEntry jarEntry = jarFile.getJarEntry(pathString);
                    if (jarEntry.isDirectory()) {
                        dst.toFile().mkdirs();
                    } else {
                        ResourceExtractor.copy(p, dst);
                    }
                });
            }
        }
    }

    private static void copy(Path p, Path dst) {
        try (InputStream inputStream = Files.newInputStream(p, new OpenOption[0]);){
            Files.copy(inputStream, dst, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

