/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlException;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.DispatchXml;
import com.google.apphosting.utils.config.YamlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;

public class DispatchYamlReader {
    private static final String DISPATCH_FILENAME = "dispatch.yaml";
    private final String parentDirectory;

    public DispatchYamlReader(String parentDirectory) {
        if (parentDirectory.length() > 0 && parentDirectory.charAt(parentDirectory.length() - 1) != File.separatorChar) {
            parentDirectory = parentDirectory + File.separatorChar;
        }
        this.parentDirectory = parentDirectory;
    }

    public String getFilename() {
        return this.parentDirectory + DISPATCH_FILENAME;
    }

    public DispatchXml parse() {
        try {
            return DispatchYamlReader.parseImpl(new FileReader(this.getFilename()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @VisibleForTesting
    static DispatchXml parseImpl(Reader yaml) {
        try {
            DispatchYaml dispatchYaml = YamlUtils.parse(yaml, DispatchYaml.class);
            if (dispatchYaml == null) {
                throw new AppEngineConfigException("Empty dispatch.yaml configuration.");
            }
            return dispatchYaml.toXml();
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage(), ex);
        }
    }

    public static class DispatchYamlEntry {
        private String url;
        private String module;
        private String service;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        @Deprecated
        public String getModule() {
            return this.module;
        }

        @Deprecated
        public void setModule(String module) {
            this.module = module;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        DispatchXml.DispatchEntry asDispatchEntry() {
            Preconditions.checkState(this.service != null ^ this.module != null, "Only one of service: or module: should be set in a dispatch entry.");
            return new DispatchXml.DispatchEntry(this.url, this.module != null ? this.module : this.service);
        }
    }

    public static class DispatchYaml {
        private List<DispatchYamlEntry> dispatchEntries;

        public List<DispatchYamlEntry> getDispatch() {
            return this.dispatchEntries;
        }

        public void setDispatch(List<DispatchYamlEntry> entries) {
            this.dispatchEntries = entries;
        }

        public DispatchXml toXml() {
            DispatchXml.Builder builder = DispatchXml.builder();
            if (this.dispatchEntries != null) {
                for (DispatchYamlEntry entry : this.dispatchEntries) {
                    builder.addDispatchEntry(entry.asDispatchEntry());
                }
            }
            return builder.build();
        }
    }
}

