/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlException;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.IndexesXml;
import com.google.apphosting.utils.config.YamlUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class IndexYamlReader {
    public static final String INDEX_DEFINITIONS_TAG = "!!python/object:google.appengine.datastore.datastore_index.IndexDefinitions";
    public static final String INDEX_TAG = "!!python/object:google.appengine.datastore.datastore_index.Index";
    public static final String PROPERTY_TAG = "!!python/object:google.appengine.datastore.datastore_index.Property";

    static IndexesXml parse(Reader yaml, IndexesXml xml) {
        List<IndexesXml> list;
        try {
            list = IndexYamlReader.parseMultiple(yaml, xml);
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage(), ex);
        }
        if (list.isEmpty()) {
            throw new AppEngineConfigException("Empty index configuration. The index.yaml file should at least have an empty 'indexes:' block.");
        }
        if (list.size() > 1) {
            throw new AppEngineConfigException("yaml unexepectedly contains more than one document: " + list.size());
        }
        return list.get(0);
    }

    public static IndexesXml parse(String yaml) {
        return IndexYamlReader.parse(new StringReader(IndexYamlReader.clean(yaml)), null);
    }

    private static String clean(String yaml) {
        return yaml.replaceAll(INDEX_DEFINITIONS_TAG, "").replaceAll(INDEX_TAG, "").replaceAll(PROPERTY_TAG, "").trim();
    }

    private static List<IndexesXml> parseMultiple(Reader yaml, IndexesXml xml) throws YamlException {
        IndexYaml indexYaml;
        ArrayList<IndexesXml> list = new ArrayList<IndexesXml>();
        while (null != (indexYaml = YamlUtils.parse(yaml, IndexYaml.class))) {
            list.add(indexYaml.toXml(xml));
        }
        return list;
    }

    public static class IndexYaml {
        private String application;
        private List<Index> indexes;

        public String getApplication() {
            return this.application;
        }

        public void setApplication(String application) {
            this.application = application;
        }

        public List<Index> getIndexes() {
            return this.indexes;
        }

        public void setIndexes(List<Index> indexes) {
            this.indexes = indexes;
        }

        public IndexesXml toXml(IndexesXml xml) {
            if (xml == null) {
                xml = new IndexesXml();
            }
            if (this.indexes != null) {
                for (Index yamlIndex : this.indexes) {
                    if (yamlIndex.kind == null) {
                        throw new AppEngineConfigException("Index missing required element 'kind'");
                    }
                    IndexesXml.Index xmlIndex = xml.addNewIndex(yamlIndex.kind, Boolean.valueOf(yamlIndex.ancestor));
                    if (yamlIndex.properties == null) continue;
                    for (Property property : yamlIndex.properties) {
                        if (property.getName() == null) {
                            throw new AppEngineConfigException("Property is missing required element 'name'.");
                        }
                        xmlIndex.addNewProperty(property.getName(), property.getDirection(), property.getMode());
                    }
                }
            }
            return xml;
        }

        public static class Property {
            private String name = null;
            private String direction = null;
            private String mode = null;

            public void setDirection(String direction) {
                if (!"desc".equals(direction) && !"asc".equals(direction)) {
                    throw new AppEngineConfigException("Invalid direction '" + direction + "': expected '" + "asc" + "' or '" + "desc" + "'.");
                }
                this.direction = direction;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getDirection() {
                return this.direction;
            }

            public void setMode(String mode) {
                if ("null".equals(mode)) {
                    mode = null;
                }
                if (mode != null && !mode.equals("geospatial")) {
                    throw new AppEngineConfigException("Invalid mode: '" + mode);
                }
                this.mode = mode;
            }

            public String getMode() {
                return this.mode;
            }
        }

        public static class Index {
            private String kind;
            private String ancestor;
            private List<Property> properties;

            public String getKind() {
                return this.kind;
            }

            public void setKind(String kind) {
                this.kind = kind;
            }

            public void setAncestor(String ancestor) {
                this.ancestor = String.valueOf(YamlUtils.parseBoolean(ancestor));
            }

            public String getAncestor() {
                return "" + this.ancestor;
            }

            public List<Property> getProperties() {
                return this.properties;
            }

            public void setProperties(List<Property> properties) {
                this.properties = properties;
            }
        }
    }
}

