/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IndexesXml
implements Iterable<Index> {
    public static final String DIRECTION_VALUE_ASC = "asc";
    public static final String DIRECTION_VALUE_DESC = "desc";
    public static final String MODE_VALUE_GEOSPATIAL = "geospatial";
    private final List<Index> indexes = new ArrayList<Index>();

    @Override
    public Iterator<Index> iterator() {
        return this.indexes.iterator();
    }

    public int size() {
        return this.indexes.size();
    }

    public Index addNewIndex(String kind, Boolean ancestors) {
        Index index = new Index(kind, ancestors);
        this.indexes.add(index);
        return index;
    }

    public void addNewIndex(Index index) {
        this.indexes.add(index);
    }

    public String toYaml() {
        return this.toYaml(false);
    }

    public String toYaml(boolean serverStyle) {
        int numIndexes;
        StringBuilder builder = new StringBuilder(1024);
        if (serverStyle) {
            builder.append("!!python/object:google.appengine.datastore.datastore_index.IndexDefinitions").append("\n");
        }
        builder.append("indexes:");
        int n = numIndexes = null == this.indexes ? 0 : this.indexes.size();
        if (0 == numIndexes && serverStyle) {
            builder.append(" []");
        }
        builder.append("\n");
        for (Index index : this.indexes) {
            String indexYaml = serverStyle ? index.toServerStyleYaml() : index.toLocalStyleYaml();
            builder.append(indexYaml);
        }
        return builder.toString();
    }

    public static class Index {
        private final String kind;
        private final Boolean ancestors;
        private final List<PropertySort> properties;

        public Index(String kind, Boolean ancestors) {
            this.kind = kind;
            this.ancestors = ancestors;
            this.properties = new ArrayList<PropertySort>();
        }

        public void addNewProperty(String name, String direction, String mode) {
            this.properties.add(new PropertySort(name, direction, mode));
        }

        public String getKind() {
            return this.kind;
        }

        public boolean doIndexAncestors() {
            return this.ancestors;
        }

        public List<PropertySort> getProperties() {
            return this.properties;
        }

        public String toYaml() {
            return this.toLocalStyleYaml();
        }

        private String toLocalStyleYaml() {
            StringBuilder builder = new StringBuilder(50 * (1 + this.properties.size()));
            builder.append("- kind: \"" + this.kind + "\"\n");
            if (Boolean.TRUE.equals(this.ancestors)) {
                builder.append("  ancestor: yes\n");
            }
            if (!this.properties.isEmpty()) {
                builder.append("  properties:\n");
                for (PropertySort prop : this.properties) {
                    builder.append("  - name: \"" + prop.getPropertyName() + "\"\n");
                    if (prop.getDirection() != null) {
                        builder.append("    direction: " + prop.getDirection() + "\n");
                    }
                    if (prop.getMode() == null) continue;
                    builder.append("    mode: " + prop.getMode() + "\n");
                }
            }
            return builder.toString();
        }

        private String toServerStyleYaml() {
            StringBuilder builder = new StringBuilder(50 * (1 + this.properties.size()));
            builder.append("- ").append("!!python/object:google.appengine.datastore.datastore_index.Index").append("\n");
            builder.append("  kind: " + this.kind + "\n");
            if (Boolean.TRUE.equals(this.ancestors)) {
                builder.append("  ancestor: yes\n");
            }
            if (!this.properties.isEmpty()) {
                builder.append("  properties:\n");
                for (PropertySort prop : this.properties) {
                    builder.append("  - ");
                    builder.append("!!python/object:google.appengine.datastore.datastore_index.Property");
                    builder.append(" {");
                    if (prop.getDirection() != null) {
                        builder.append("direction: ");
                        builder.append(prop.getDirection());
                        builder.append(",\n");
                    }
                    if (prop.getMode() != null) {
                        builder.append("mode: ");
                        builder.append(prop.getMode());
                        builder.append(",\n");
                    }
                    builder.append("    ");
                    builder.append("name: " + prop.getPropertyName());
                    builder.append("}\n");
                }
            }
            return builder.toString();
        }

        public String toXmlString() {
            StringBuilder builder = new StringBuilder(100 * (1 + this.properties.size()));
            String ancestorAttribute = this.ancestors == null ? "" : String.format(" ancestor=\"%s\"", this.ancestors);
            builder.append("<datastore-index kind=\"" + this.kind + "\"" + ancestorAttribute + ">\n");
            for (PropertySort prop : this.properties) {
                builder.append("    <property name=\"" + prop.getPropertyName() + "\"");
                if (prop.getDirection() != null) {
                    builder.append(" direction=\"" + prop.getDirection() + "\"");
                }
                if (prop.getMode() != null) {
                    builder.append(" mode=\"" + prop.getMode() + "\"");
                }
                builder.append("/>\n");
            }
            builder.append("</datastore-index>\n");
            return builder.toString();
        }
    }

    public static enum Type {
        ORDERED,
        GEO_SPATIAL;

    }

    public static class PropertySort {
        private final String propName;
        private final String direction;
        private final String mode;

        public PropertySort(String propName, String direction, String mode) {
            this.propName = propName;
            this.direction = direction;
            this.mode = mode;
        }

        public String getPropertyName() {
            return this.propName;
        }

        public String getDirection() {
            return this.direction;
        }

        public String getMode() {
            return this.mode;
        }
    }
}

