/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RetryParametersXml {
    private static final String AGE_LIMIT_REGEX = "([0-9]+(?:\\.?[0-9]*(?:[eE][\\-+]?[0-9]+)?)?)([smhd])";
    private static final Pattern AGE_LIMIT_PATTERN = Pattern.compile("([0-9]+(?:\\.?[0-9]*(?:[eE][\\-+]?[0-9]+)?)?)([smhd])");
    private Integer retryLimit = null;
    private Integer ageLimitSec = null;
    private Double minBackoffSec = null;
    private Double maxBackoffSec = null;
    private Integer maxDoublings = null;

    public Integer getRetryLimit() {
        return this.retryLimit;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public void setRetryLimit(String retryLimit) {
        try {
            this.retryLimit = Integer.valueOf(retryLimit);
        }
        catch (NumberFormatException exc) {
            throw new AppEngineConfigException("Illegal retry limit '" + retryLimit + "'.");
        }
    }

    public Integer getAgeLimitSec() {
        return this.ageLimitSec;
    }

    public void setAgeLimitSec(String ageLimitString) {
        Matcher matcher = AGE_LIMIT_PATTERN.matcher(ageLimitString);
        if (!matcher.matches() || matcher.groupCount() != 2) {
            throw new AppEngineConfigException("Invalid age limit ('" + ageLimitString + "') was specified.");
        }
        try {
            double rateUnitSec = AgeLimitUnit.valueOf(matcher.group(2).charAt(0)).getSeconds();
            Double ageLimit = Double.parseDouble(matcher.group(1)) * rateUnitSec;
            this.ageLimitSec = ageLimit.intValue();
        }
        catch (NumberFormatException exc) {
            throw new AppEngineConfigException("Invalid age limit ('" + ageLimitString + "') was specified.");
        }
    }

    public Double getMinBackoffSec() {
        return this.minBackoffSec;
    }

    public void setMinBackoffSec(double minBackoffSec) {
        this.minBackoffSec = minBackoffSec;
    }

    public void setMinBackoffSec(String minBackoffSec) {
        try {
            this.minBackoffSec = Double.valueOf(minBackoffSec);
        }
        catch (NumberFormatException exc) {
            throw new AppEngineConfigException("Illegal min backoff '" + minBackoffSec + "'.");
        }
    }

    public Double getMaxBackoffSec() {
        return this.maxBackoffSec;
    }

    public void setMaxBackoffSec(double maxBackoffSec) {
        this.maxBackoffSec = maxBackoffSec;
    }

    public void setMaxBackoffSec(String maxBackoffSec) {
        try {
            this.maxBackoffSec = Double.valueOf(maxBackoffSec);
        }
        catch (NumberFormatException exc) {
            throw new AppEngineConfigException("Illegal max backoff '" + maxBackoffSec + "'.");
        }
    }

    public Integer getMaxDoublings() {
        return this.maxDoublings;
    }

    public void setMaxDoublings(int maxDoublings) {
        this.maxDoublings = maxDoublings;
    }

    public void setMaxDoublings(String maxDoublings) {
        try {
            this.maxDoublings = Integer.valueOf(maxDoublings);
        }
        catch (NumberFormatException exc) {
            throw new AppEngineConfigException("Illegal max doublings value '" + maxDoublings + "'.");
        }
    }

    public String toYaml(String label) {
        StringBuilder builder = new StringBuilder();
        builder.append("  retry_parameters:\n");
        if (this.getRetryLimit() != null) {
            builder.append("    " + label + "_retry_limit: " + this.getRetryLimit() + "\n");
        }
        if (this.getAgeLimitSec() != null) {
            builder.append("    " + label + "_age_limit: " + this.getAgeLimitSec() + "s\n");
        }
        if (this.getMinBackoffSec() != null) {
            builder.append("    min_backoff_seconds: " + this.getMinBackoffSec() + "\n");
        }
        if (this.getMaxBackoffSec() != null) {
            builder.append("    max_backoff_seconds: " + this.getMaxBackoffSec() + "\n");
        }
        if (this.getMaxDoublings() != null) {
            builder.append("    max_doublings: " + this.getMaxDoublings() + "\n");
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ageLimitSec == null ? 0 : this.ageLimitSec.hashCode());
        result = 31 * result + (this.maxBackoffSec == null ? 0 : this.maxBackoffSec.hashCode());
        result = 31 * result + (this.maxDoublings == null ? 0 : this.maxDoublings.hashCode());
        result = 31 * result + (this.minBackoffSec == null ? 0 : this.minBackoffSec.hashCode());
        result = 31 * result + (this.retryLimit == null ? 0 : this.retryLimit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RetryParametersXml other = (RetryParametersXml)obj;
        if (this.ageLimitSec == null ? other.ageLimitSec != null : !this.ageLimitSec.equals(other.ageLimitSec)) {
            return false;
        }
        if (this.maxBackoffSec == null ? other.maxBackoffSec != null : !this.maxBackoffSec.equals(other.maxBackoffSec)) {
            return false;
        }
        if (this.maxDoublings == null ? other.maxDoublings != null : !this.maxDoublings.equals(other.maxDoublings)) {
            return false;
        }
        if (this.minBackoffSec == null ? other.minBackoffSec != null : !this.minBackoffSec.equals(other.minBackoffSec)) {
            return false;
        }
        return !(this.retryLimit == null ? other.retryLimit != null : !this.retryLimit.equals(other.retryLimit));
    }

    public static enum AgeLimitUnit {
        SECOND('s', 1),
        MINUTE('m', SECOND.getSeconds() * 60),
        HOUR('h', MINUTE.getSeconds() * 60),
        DAY('d', HOUR.getSeconds() * 24);

        final char ident;
        final int seconds;

        private AgeLimitUnit(char ident, int seconds) {
            this.ident = ident;
            this.seconds = seconds;
        }

        static AgeLimitUnit valueOf(char unit) {
            switch (unit) {
                case 's': {
                    return SECOND;
                }
                case 'm': {
                    return MINUTE;
                }
                case 'h': {
                    return HOUR;
                }
                case 'd': {
                    return DAY;
                }
            }
            throw new AppEngineConfigException("Invalid age limit '" + unit + "' was specified.");
        }

        public char getIdent() {
            return this.ident;
        }

        public int getSeconds() {
            return this.seconds;
        }
    }
}

