/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.common.io.FileWriteMode;
import com.google.appengine.repackaged.org.eclispe.jetty.http.MimeTypes;
import com.google.appengine.tools.admin.AppYamlTranslator;
import com.google.appengine.tools.admin.ApplicationProcessingOptions;
import com.google.appengine.tools.admin.GenericApplication;
import com.google.appengine.tools.admin.JspCompilationException;
import com.google.appengine.tools.admin.RepoInfo;
import com.google.appengine.tools.admin.UpdateListener;
import com.google.appengine.tools.admin.UpdateProgressEvent;
import com.google.appengine.tools.admin.Utility;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.appengine.tools.util.ApiVersionFinder;
import com.google.appengine.tools.util.FileIterator;
import com.google.appengine.tools.util.JarSplitter;
import com.google.appengine.tools.util.JarTool;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import com.google.apphosting.utils.config.AppYamlProcessor;
import com.google.apphosting.utils.config.BackendsXml;
import com.google.apphosting.utils.config.BackendsXmlReader;
import com.google.apphosting.utils.config.BackendsYamlReader;
import com.google.apphosting.utils.config.CronXml;
import com.google.apphosting.utils.config.CronXmlReader;
import com.google.apphosting.utils.config.CronYamlReader;
import com.google.apphosting.utils.config.DispatchXml;
import com.google.apphosting.utils.config.DispatchXmlReader;
import com.google.apphosting.utils.config.DispatchYamlReader;
import com.google.apphosting.utils.config.DosXml;
import com.google.apphosting.utils.config.DosXmlReader;
import com.google.apphosting.utils.config.DosYamlReader;
import com.google.apphosting.utils.config.GenerationDirectory;
import com.google.apphosting.utils.config.IndexesXml;
import com.google.apphosting.utils.config.IndexesXmlReader;
import com.google.apphosting.utils.config.QueueXml;
import com.google.apphosting.utils.config.QueueXmlReader;
import com.google.apphosting.utils.config.QueueYamlReader;
import com.google.apphosting.utils.config.StagingOptions;
import com.google.apphosting.utils.config.WebXml;
import com.google.apphosting.utils.config.WebXmlReader;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Application
implements GenericApplication {
    private static final int MAX_COMPILED_JSP_JAR_SIZE = 0x500000;
    private static final String COMPILED_JSP_JAR_NAME_PREFIX = "_ah_compiled_jsps";
    private static final int MAX_CLASSES_JAR_SIZE = 0x500000;
    private static final String CLASSES_JAR_NAME_PREFIX = "_ah_webinf_classes";
    private static final String JAVA_8_RUNTIME_ID = "java8";
    private static final String GOOGLE_RUNTIME_ID = "google";
    private static final String GOOGLE_LEGACY_RUNTIME_ID = "googlelegacy";
    private static final String JAVA_11_RUNTIME_ID = "java11";
    private static final String JAVA_17_RUNTIME_ID = "java17";
    private static final String JAVA_21_RUNTIME_ID = "java21";
    private static final ImmutableSet<String> ALLOWED_RUNTIME_IDS = ImmutableSet.of("java8", "java11", "java17", "java21", "google", "googlelegacy", new String[0]);
    private static final String BETA_SOURCE_REFERENCE_KEY = "source_reference";
    private static final Pattern JSP_REGEX = Pattern.compile(".*\\.jspx?");
    private static final Pattern CONTAINER_INITIALIZER_PATTERN = Pattern.compile("ContainerInitializer\\{(.*),interested=(.*),applicable=(.*),annotated=(.*)\\}");
    private static final Pattern HAS_PROTOCOL_RE = Pattern.compile("^\\w+:");
    private static final int SUGGEST_JAR_THRESHOLD = 100;
    static final String DEFAULT_WEB_XML_CONTENT = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<web-app version=\"3.1\" xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd\"></web-app>";
    private static boolean shouldAttemptSymlink = Utility.isOsUnix();
    private static File sdkDocsDir;
    private static final String STAGEDIR_PREFIX = "appcfg";
    private static final Logger logger;
    private static final MimeTypes mimeTypes;
    private final CronXml cronXml;
    private final DispatchXml dispatchXml;
    private final DosXml dosXml;
    private final QueueXml queueXml;
    private final IndexesXml indexesXml;
    private final BackendsXml backendsXml;
    private final File baseDir;
    private final RepoInfo.SourceContext sourceContext;
    private AppEngineWebXml appEngineWebXml;
    private WebXml webXml;
    private String servletVersion;
    private File stageDir;
    private File externalResourceDir;
    private String apiVersion;
    private String calculatedRuntime;
    private String appYaml;
    private UpdateListener listener;
    private PrintWriter detailsWriter;
    private int updateProgress = 0;
    private int progressAmount = 0;
    private File jspJavaFilesGeneratedTempDirectory;
    private static final Pattern SKIP_FILES;

    public static synchronized File getSdkDocsDir() {
        if (null == sdkDocsDir) {
            sdkDocsDir = AppengineSdk.getSdk().getResourcesDirectory();
        }
        return sdkDocsDir;
    }

    protected Application() {
        this.backendsXml = null;
        this.cronXml = null;
        this.dispatchXml = null;
        this.dosXml = null;
        this.indexesXml = null;
        this.queueXml = null;
        this.baseDir = null;
        this.sourceContext = null;
    }

    private Application(String explodedPath, String appId, String module, String appVersion, RepoInfo.SourceContext sourceContext) {
        BackendsXml parsedBackendsXml;
        DosXml parsedDosXml;
        DispatchXml parsedDispatchXml;
        QueueXml parsedQueueXml;
        CronXml parsedCronXml;
        this.baseDir = new File(explodedPath);
        explodedPath = Application.buildNormalizedPath(this.baseDir);
        File webinf = new File(this.baseDir, "WEB-INF");
        if (!webinf.getName().equals("WEB-INF")) {
            throw new AppEngineConfigException("WEB-INF directory must be capitalized.");
        }
        String webinfPath = webinf.getPath();
        AppEngineWebXmlReader aewebReader = new AppEngineWebXmlReader(explodedPath);
        WebXmlReader webXmlReader = new WebXmlReader(explodedPath);
        AppYamlProcessor.convert(webinf, aewebReader.getFilename(), webXmlReader.getFilename());
        File webXmlFile = new File(webinfPath, "web.xml");
        if (!webXmlFile.exists()) {
            this.writeDefaultWebXml(webXmlFile);
        }
        if (new File(aewebReader.getFilename()).exists()) {
            XmlUtils.validateXml(aewebReader.getFilename(), new File(Application.getSdkDocsDir(), "appengine-web.xsd"));
        }
        this.appEngineWebXml = aewebReader.readAppEngineWebXml();
        if (JAVA_21_RUNTIME_ID.equals(this.appEngineWebXml.getRuntime())) {
            System.setProperty("appengine.use.jetty12", "true");
            AppengineSdk.resetSdk();
        }
        this.appEngineWebXml.setSourcePrefix(explodedPath);
        if (appId != null) {
            this.appEngineWebXml.setAppId(appId);
        }
        if (appVersion != null) {
            this.appEngineWebXml.setMajorVersionId(appVersion);
        }
        if (module != null) {
            this.appEngineWebXml.setModule(module);
        }
        if (sourceContext == null && (sourceContext = new RepoInfo(this.baseDir).getSourceContext()) != null) {
            String sourceRef = sourceContext.getRevisionId();
            if (sourceContext.getRepositoryUrl() != null && HAS_PROTOCOL_RE.matcher(sourceContext.getRepositoryUrl()).find()) {
                sourceRef = sourceContext.getRepositoryUrl() + "#" + sourceRef;
            }
            this.appEngineWebXml.addBetaSetting(BETA_SOURCE_REFERENCE_KEY, sourceRef);
        }
        this.sourceContext = sourceContext;
        this.webXml = webXmlReader.readWebXml();
        this.webXml.validate();
        this.servletVersion = webXmlReader.getServletVersion();
        this.validateFilterClasses();
        this.validateRuntime();
        CronXmlReader cronReader = new CronXmlReader(explodedPath);
        if (new File(cronReader.getFilename()).exists()) {
            XmlUtils.validateXml(cronReader.getFilename(), new File(Application.getSdkDocsDir(), "cron.xsd"));
        }
        if ((parsedCronXml = cronReader.readCronXml()) == null) {
            CronYamlReader cronYaml = new CronYamlReader(webinfPath);
            parsedCronXml = cronYaml.parse();
        }
        this.cronXml = parsedCronXml;
        QueueXmlReader queueReader = new QueueXmlReader(explodedPath);
        if (new File(queueReader.getFilename()).exists()) {
            XmlUtils.validateXml(queueReader.getFilename(), new File(Application.getSdkDocsDir(), "queue.xsd"));
        }
        if ((parsedQueueXml = queueReader.readQueueXml()) == null) {
            QueueYamlReader queueYaml = new QueueYamlReader(webinfPath);
            parsedQueueXml = queueYaml.parse();
        }
        this.queueXml = parsedQueueXml;
        DispatchXmlReader dispatchXmlReader = new DispatchXmlReader(explodedPath, DispatchXmlReader.DEFAULT_RELATIVE_FILENAME);
        if (new File(dispatchXmlReader.getFilename()).exists()) {
            XmlUtils.validateXml(dispatchXmlReader.getFilename(), new File(Application.getSdkDocsDir(), "dispatch.xsd"));
        }
        if ((parsedDispatchXml = dispatchXmlReader.readDispatchXml()) == null) {
            DispatchYamlReader dispatchYamlReader = new DispatchYamlReader(webinfPath);
            parsedDispatchXml = dispatchYamlReader.parse();
        }
        this.dispatchXml = parsedDispatchXml;
        DosXmlReader dosReader = new DosXmlReader(explodedPath);
        if (new File(dosReader.getFilename()).exists()) {
            XmlUtils.validateXml(dosReader.getFilename(), new File(Application.getSdkDocsDir(), "dos.xsd"));
        }
        if ((parsedDosXml = dosReader.readDosXml()) == null) {
            DosYamlReader dosYaml = new DosYamlReader(webinfPath);
            parsedDosXml = dosYaml.parse();
        }
        this.dosXml = parsedDosXml;
        IndexesXmlReader indexReader = new IndexesXmlReader(explodedPath);
        File datastoreSchema = new File(Application.getSdkDocsDir(), "datastore-indexes.xsd");
        if (new File(indexReader.getFilename()).exists()) {
            XmlUtils.validateXml(indexReader.getFilename(), datastoreSchema);
        }
        this.indexesXml = indexReader.readIndexesXml();
        BackendsXmlReader backendsReader = new BackendsXmlReader(explodedPath);
        if (new File(backendsReader.getFilename()).exists()) {
            XmlUtils.validateXml(backendsReader.getFilename(), new File(Application.getSdkDocsDir(), "backends.xsd"));
        }
        if ((parsedBackendsXml = backendsReader.readBackendsXml()) == null) {
            BackendsYamlReader backendsYaml = new BackendsYamlReader(webinfPath);
            parsedBackendsXml = backendsYaml.parse();
        }
        this.backendsXml = parsedBackendsXml;
    }

    private static String buildNormalizedPath(File dir) {
        String normalizedPath = dir.getPath();
        if (File.separatorChar == '\\') {
            normalizedPath = normalizedPath.replace('\\', '/');
        }
        return normalizedPath;
    }

    public static Application readApplication(String path) throws IOException {
        return Application.readApplication(path, null);
    }

    public static Application readApplication(String path, RepoInfo.SourceContext sourceContext) throws IOException {
        return new Application(path, null, null, null, sourceContext);
    }

    void validate() {
        if (this.appEngineWebXml.getAppId() == null) {
            throw new AppEngineConfigException("No app id supplied and XML files have no <application> element");
        }
    }

    void validateForStaging() {
    }

    void validateRuntime() {
        if (!this.appEngineWebXml.isFlexible() && this.appEngineWebXml.getNetwork() != null) {
            if (this.appEngineWebXml.getNetwork().getSessionAffinity()) {
                throw new AppEngineConfigException("'session-affinity' is an <env>flex</env> specific field.");
            }
            if (this.appEngineWebXml.getNetwork().getSubnetworkName() != null && !this.appEngineWebXml.getNetwork().getSubnetworkName().isEmpty()) {
                throw new AppEngineConfigException("'subnetwork-name' is an <env>flex</env> specific field.");
            }
            if (this.appEngineWebXml.getLivenessCheck() != null) {
                throw new AppEngineConfigException("'liveness-check' is an <env>flex</env> specific field.");
            }
            if (this.appEngineWebXml.getReadinessCheck() != null) {
                throw new AppEngineConfigException("'readiness-check' is an <env>flex</env> specific field.");
            }
        }
        if (!this.appEngineWebXml.isJava11OrAbove()) {
            if (this.appEngineWebXml.getRuntimeChannel() != null) {
                throw new AppEngineConfigException("'runtime-channel' is not valid with this runtime.");
            }
            if (this.appEngineWebXml.getEntrypoint() != null) {
                throw new AppEngineConfigException("'entrypoint' is not valid with this runtime.");
            }
        }
    }

    private void validateFilterClasses() {
        if (!this.isJava8OrAbove()) {
            return;
        }
        for (String filter : this.webXml.getFilterClasses()) {
            if (!"com.google.appengine.tools.appstats.AppstatsFilter".equals(filter)) continue;
            throw new AppEngineConfigException("AppStats is not supported anymore, please do not include appengine-api-labs.jar in your app, and remove the " + filter + " filter in web.xml.");
        }
    }

    public void setExternalResourceDir(String path) {
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        if (this.stageDir != null) {
            throw new IllegalStateException("This method must be invoked prior to createStagingDirectory()");
        }
        File dir = new File(path);
        if (!dir.exists()) {
            throw new IllegalArgumentException("path does not exist: " + path);
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(path + " is not a directory.");
        }
        this.externalResourceDir = dir;
    }

    public static Application readApplication(String path, String appId, String module, String appVersion) throws IOException {
        return new Application(path, appId, module, appVersion, null);
    }

    @Override
    public String getAppId() {
        return this.appEngineWebXml.getAppId();
    }

    @Override
    public String getVersion() {
        return this.appEngineWebXml.getMajorVersionId();
    }

    @Override
    public String getModule() {
        if (this.appEngineWebXml.getModule() != null) {
            return this.appEngineWebXml.getModule();
        }
        return this.appEngineWebXml.getService();
    }

    @Override
    public String getInstanceClass() {
        return this.appEngineWebXml.getInstanceClass();
    }

    @Override
    public boolean isPrecompilationEnabled() {
        return this.appEngineWebXml.getPrecompilationEnabled();
    }

    @Override
    public List<GenericApplication.ErrorHandler> getErrorHandlers() {
        ArrayList<GenericApplication.ErrorHandler> errorHandlers = new ArrayList<GenericApplication.ErrorHandler>();
        for (AppEngineWebXml.ErrorHandler errorHandler : this.appEngineWebXml.getErrorHandlers()) {
            class ErrorHandlerImpl
            implements GenericApplication.ErrorHandler {
                private final AppEngineWebXml.ErrorHandler errorHandler;

                public ErrorHandlerImpl(AppEngineWebXml.ErrorHandler errorHandler) {
                    this.errorHandler = errorHandler;
                }

                @Override
                public String getFile() {
                    return "__static__/" + this.errorHandler.getFile();
                }

                @Override
                public String getErrorCode() {
                    return this.errorHandler.getErrorCode();
                }

                @Override
                public String getMimeType() {
                    return Application.this.getMimeTypeIfStatic(this.getFile());
                }
            }
            errorHandlers.add(new ErrorHandlerImpl(errorHandler));
        }
        return errorHandlers;
    }

    @Override
    public String getMimeTypeIfStatic(String path) {
        if (!path.contains("__static__/")) {
            return null;
        }
        String mimeType = this.webXml.getMimeTypeForPath(path);
        if (mimeType != null) {
            return mimeType;
        }
        return Application.guessContentTypeFromName(path);
    }

    public static String guessContentTypeFromName(String fileName) {
        String defaultValue = "application/octet-stream";
        try {
            String buffer = mimeTypes.getMimeByExtension(fileName);
            if (buffer != null) {
                return buffer;
            }
            String lowerName = fileName.toLowerCase();
            if (lowerName.endsWith(".json")) {
                return "application/json";
            }
            if (lowerName.endsWith(".wasm")) {
                return "application/wasm";
            }
            String ret = URLConnection.guessContentTypeFromName(fileName);
            if (ret != null) {
                return ret;
            }
            return defaultValue;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Error identify mimetype for " + fileName, t);
            return defaultValue;
        }
    }

    public AppEngineWebXml getAppEngineWebXml() {
        return this.appEngineWebXml;
    }

    public AppEngineWebXml getScrubbedAppEngineWebXml() {
        AppEngineWebXml scrubbedAppEngineWebXml = this.appEngineWebXml.clone();
        scrubbedAppEngineWebXml.setAppId(null);
        scrubbedAppEngineWebXml.setMajorVersionId(null);
        if (this.appEngineWebXml.getModule() != null) {
            this.appEngineWebXml.setService(this.appEngineWebXml.getModule());
            this.appEngineWebXml.setModule(null);
        }
        return scrubbedAppEngineWebXml;
    }

    @Override
    public CronXml getCronXml() {
        return this.cronXml;
    }

    @Override
    public QueueXml getQueueXml() {
        return this.queueXml;
    }

    @Override
    public DispatchXml getDispatchXml() {
        return this.dispatchXml;
    }

    @Override
    public DosXml getDosXml() {
        return this.dosXml;
    }

    @Override
    public IndexesXml getIndexesXml() {
        return this.indexesXml;
    }

    public WebXml getWebXml() {
        return this.webXml;
    }

    @Override
    public BackendsXml getBackendsXml() {
        return this.backendsXml;
    }

    @Override
    public String getApiVersion() {
        if (this.apiVersion == null) {
            throw new IllegalStateException("Must call createStagingDirectory first.");
        }
        return this.apiVersion;
    }

    @Override
    public String getRuntime() {
        if (this.calculatedRuntime == null) {
            throw new IllegalStateException("Null runtime. Must call createStagingDirectory first.");
        }
        return this.calculatedRuntime;
    }

    @Override
    public String getPath() {
        return this.baseDir.getAbsolutePath();
    }

    @Override
    public File getStagingDir() {
        return this.stageDir;
    }

    @Override
    public void resetProgress() {
        this.updateProgress = 0;
        this.progressAmount = 0;
    }

    public StagingOptions getStagingOptions(ApplicationProcessingOptions opts) {
        return StagingOptions.merge(opts.getDefaultStagingOptions(), this.appEngineWebXml.getStagingOptions(), opts.getStagingOptions());
    }

    @Override
    public File createStagingDirectory(ApplicationProcessingOptions opts) throws IOException {
        if (this.stageDir != null) {
            return this.stageDir;
        }
        int i = 0;
        while (this.stageDir == null && i++ < 3) {
            try {
                this.stageDir = File.createTempFile(STAGEDIR_PREFIX, null);
            }
            catch (IOException ex) {
                continue;
            }
            this.stageDir.delete();
            if (this.stageDir.mkdir()) continue;
            this.stageDir = null;
        }
        if (i == 3) {
            throw new IOException("Couldn't create a temporary directory in 3 tries.");
        }
        this.calculatedRuntime = this.determineRuntime(opts);
        return this.populateStagingDirectory(opts, false, this.calculatedRuntime);
    }

    @Override
    public File createStagingDirectory(ApplicationProcessingOptions opts, File stagingDir) throws IOException {
        if (!stagingDir.exists() && !stagingDir.mkdir()) {
            throw new IOException("Could not create staging directory at " + stagingDir.getPath());
        }
        this.stageDir = stagingDir;
        shouldAttemptSymlink = false;
        this.calculatedRuntime = this.determineRuntime(opts);
        this.populateStagingDirectory(opts, true, this.calculatedRuntime);
        this.copyAppYamlToRoot();
        try {
            File classesDir = new File(stagingDir, "WEB-INF/classes");
            if (classesDir.exists() && Application.countClasses(classesDir) > 100) {
                logger.info("We detected that you have a large number of .class files in WEB-INF/classes. You may be able to reduce request latency by packaging your .class files into jars. To do this, supply <enable-jar-classes>true</enable-jar-classes> in the <staging> tag in appengine-web.xml or one of the following methods: You can supply the --enable_jar_classes flag when using appcfg on command line. If you're using the Cloud SDK based app-maven-plugin, add <stage.enableJarClasses>true</stage.enableJarClasses> in the plugin's <configuration> tag. If you are using the AppCfg based appengine-maven-plugin, supply <enableJarClasses>true</enableJarClasses> in the plugin's <configuration> tag. Note that this flag will put the jar in WEB-INF/lib rather than WEB-INF/classes. The classloader first looks in WEB-INF/classes and then WEB-INF/lib when loading a class. As a result, this flag could change classloading order, which may affect the behavior of your app.");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.stageDir;
    }

    private void copyAppYamlToRoot() throws IOException {
        File destinationAppYaml = new File(this.stageDir, "app.yaml");
        this.copyOrLinkFile(new File(GenerationDirectory.getGenerationDirectory(this.stageDir), "app.yaml"), destinationAppYaml);
        if (this.appEngineWebXml.getRuntime().startsWith(JAVA_8_RUNTIME_ID) || this.appEngineWebXml.getRuntime().startsWith(GOOGLE_LEGACY_RUNTIME_ID)) {
            com.google.appengine.repackaged.com.google.common.io.Files.asCharSink(destinationAppYaml, StandardCharsets.UTF_8, FileWriteMode.APPEND).write("\nskip_files: app.yaml\n");
        }
    }

    @VisibleForTesting
    static int countClasses(File classesDir) throws IOException {
        ClassCounterVisitor classCounterVisitor = new ClassCounterVisitor();
        Files.walkFileTree(classesDir.toPath(), ImmutableSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, classCounterVisitor);
        return classCounterVisitor.classCount();
    }

    private boolean isJava8OrAbove() {
        return this.appEngineWebXml.getRuntime().startsWith(JAVA_8_RUNTIME_ID) || this.appEngineWebXml.getRuntime().equals(JAVA_11_RUNTIME_ID) || this.appEngineWebXml.getRuntime().equals(JAVA_17_RUNTIME_ID) || this.appEngineWebXml.getRuntime().equals(JAVA_21_RUNTIME_ID) || this.appEngineWebXml.getRuntime().startsWith(GOOGLE_LEGACY_RUNTIME_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File populateStagingDirectory(ApplicationProcessingOptions opts, boolean isStaging, String runtime) throws IOException {
        boolean vm;
        if (runtime.equals("java7")) {
            throw new AppEngineConfigException("GAE Java7 is not supported anymore.");
        }
        File staticDir = new File(this.stageDir, "__static__");
        staticDir.mkdir();
        this.copyOrLink(this.baseDir, this.stageDir, staticDir, false, opts, runtime);
        if (this.externalResourceDir != null) {
            String previousPrefix = this.appEngineWebXml.getSourcePrefix();
            String newPrefix = Application.buildNormalizedPath(this.externalResourceDir);
            try {
                this.appEngineWebXml.setSourcePrefix(newPrefix);
                this.copyOrLink(this.externalResourceDir, this.stageDir, staticDir, false, opts, runtime);
            }
            finally {
                this.appEngineWebXml.setSourcePrefix(previousPrefix);
            }
        }
        this.apiVersion = this.findApiVersion(this.stageDir);
        StagingOptions staging = this.getStagingOptions(opts);
        if (opts.isCompileJspsSet()) {
            this.compileJsps(this.stageDir, opts, runtime);
        }
        if (staging.jarClasses().get().booleanValue() && new File(this.stageDir, "WEB-INF/classes").isDirectory()) {
            this.zipWebInfClassesFiles(new File(this.stageDir, "WEB-INF"));
        }
        int maxJarSize = 32000000;
        if (staging.splitJarFiles().get().booleanValue()) {
            Application.splitJars(new File(new File(this.stageDir, "WEB-INF"), "lib"), maxJarSize, (Set<String>)staging.splitJarFilesExcludes().get());
        }
        boolean bl = vm = this.appEngineWebXml.getUseVm() || this.appEngineWebXml.isFlexible();
        if (vm) {
            this.statusUpdate("Warning: Google App Engine Java compat Flexible product is deprecated.");
            this.statusUpdate("Warning: See https://cloud.google.com/appengine/docs/flexible/java/upgrading");
        }
        boolean isServlet31 = "3.1".equals(this.servletVersion);
        if (!this.isJava8OrAbove() && !vm && isServlet31) {
            this.statusUpdate("Warning: you are using the Java7 runtime with a Servlet 3.1 web.xml file.");
            this.statusUpdate("The Servlet 3.1 annotations will be ignored and not processed.");
        } else if (opts.isQuickstart() || isServlet31) {
            try {
                this.createQuickstartWebXml(opts);
                this.webXml = new WebXmlReader(this.stageDir.getAbsolutePath(), "/WEB-INF/min-quickstart-web.xml").readWebXml();
            }
            catch (ParserConfigurationException | TransformerException | SAXException e) {
                throw new IOException(e);
            }
            if (!this.webXml.getContextParams().isEmpty()) {
                this.fallThroughToRuntimeOnContextInitializers();
            }
        }
        this.appYaml = this.generateAppYaml(this.stageDir, runtime, this.appEngineWebXml);
        if (GenerationDirectory.getGenerationDirectory(this.stageDir).mkdirs()) {
            this.writePreparedYamlFile("app", isStaging ? this.generateAppYaml(this.stageDir, runtime, this.getScrubbedAppEngineWebXml()) : this.appYaml);
            this.writePreparedYamlFile("backends", this.backendsXml == null ? null : this.backendsXml.toYaml());
            this.writePreparedYamlFile("index", this.indexesXml.size() == 0 ? null : this.indexesXml.toYaml());
            this.writePreparedYamlFile("cron", this.cronXml == null ? null : this.cronXml.toYaml());
            this.writePreparedYamlFile("queue", this.queueXml == null ? null : this.queueXml.toYaml());
            this.writePreparedYamlFile("dos", this.dosXml == null ? null : this.dosXml.toYaml());
            if (isStaging && this.dispatchXml != null) {
                this.writePreparedYamlFile("dispatch", this.dispatchXml.toYaml());
            }
        }
        this.exportRepoInfoFile();
        return this.stageDir;
    }

    private void fallThroughToRuntimeOnContextInitializers() {
        String value = this.webXml.getContextParams().get("com.google.appengine.repackaged.org.eclispe.jetty.containerInitializers");
        if (value == null) {
            return;
        }
        HashSet<String> initializers = new HashSet<String>();
        Matcher matcher = CONTAINER_INITIALIZER_PATTERN.matcher(value);
        boolean foundJasperInitializer = false;
        while (matcher.find()) {
            String containerInitializer = matcher.group(1);
            if ("com.google.appengine.repackaged.org.eclispe.jetty.apache.jsp.JettyJasperInitializer".equals(containerInitializer) || "com.google.appengine.repackaged.org.eclispe.jetty.ee8.apache.jsp.JettyJasperInitializer".equals(containerInitializer)) {
                foundJasperInitializer = true;
            }
            initializers.add(containerInitializer);
        }
        if (initializers.isEmpty()) {
            return;
        }
        if (initializers.size() == 1 && foundJasperInitializer) {
            return;
        }
        this.webXml.setFallThroughToRuntime(true);
    }

    @Override
    public void exportRepoInfoFile() {
        File target = new File(this.stageDir, "WEB-INF/classes/source-context.json");
        if (target.exists()) {
            return;
        }
        if (this.sourceContext == null || this.sourceContext.getJson() == null) {
            return;
        }
        try {
            target.getParentFile().mkdirs();
            com.google.appengine.repackaged.com.google.common.io.Files.asCharSink(target, StandardCharsets.UTF_8, new FileWriteMode[0]).write(this.sourceContext.getJson());
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Failed to write git repository information file.", ex);
            return;
        }
        this.statusUpdate("Generated git repository information file.");
    }

    private void writePreparedYamlFile(String yamlName, String yamlString) throws IOException {
        File f = new File(GenerationDirectory.getGenerationDirectory(this.stageDir), yamlName + ".yaml");
        if (yamlString != null && f.createNewFile()) {
            BufferedWriter fw = com.google.appengine.repackaged.com.google.common.io.Files.newWriter(f, StandardCharsets.UTF_8);
            fw.write(yamlString);
            ((Writer)fw).close();
        }
    }

    private String findApiVersion(File baseDir) {
        ApiVersionFinder finder = new ApiVersionFinder();
        if (this.appEngineWebXml.isJava11OrAbove()) {
            return "none";
        }
        if (!this.appEngineWebXml.isFlexible()) {
            return "user_defined";
        }
        String foundApiVersion = null;
        File webInf = new File(baseDir, "WEB-INF");
        File libDir = new File(webInf, "lib");
        for (File file : new FileIterator(libDir)) {
            if (!file.getPath().endsWith(".jar")) continue;
            try {
                String apiVersion = finder.findApiVersion(file);
                if (apiVersion == null) continue;
                if (foundApiVersion == null) {
                    foundApiVersion = apiVersion;
                    continue;
                }
                if (foundApiVersion.equals(apiVersion)) continue;
                logger.warning("Warning: found duplicate API version: " + foundApiVersion + ", using " + apiVersion);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Could not identify API version in " + file, ex);
            }
        }
        if (foundApiVersion == null) {
            foundApiVersion = "none";
            if (!Boolean.getBoolean("com.google.appengine.allow_missing_api_jar")) {
                throw new AppEngineConfigException("GAE Flex compat applications need to depend on the GAE API jar, but it was not found in the WEB-INF/lib directory.");
            }
            logger.log(Level.WARNING, "Could not find the GAE API jar in the WEB-INF/lib directory.");
        }
        return foundApiVersion;
    }

    private String determineRuntime(ApplicationProcessingOptions opts) {
        boolean vm;
        boolean bl = vm = this.appEngineWebXml.getUseVm() || this.appEngineWebXml.isFlexible();
        if (vm && new File(this.baseDir, "Dockerfile").exists()) {
            return "custom";
        }
        String runtime = opts.getRuntime();
        if (runtime != null) {
            if (!opts.isAllowAnyRuntime() && !ALLOWED_RUNTIME_IDS.contains(runtime)) {
                throw new AppEngineConfigException("Invalid runtime id: " + runtime);
            }
            return runtime;
        }
        return this.appEngineWebXml.getRuntime();
    }

    @VisibleForTesting
    String getJSPCClassName() {
        return AppengineSdk.getSdk().getJSPCompilerClassName();
    }

    private void compileJsps(File stage, ApplicationProcessingOptions opts, String runtime) throws IOException {
        this.statusUpdate("Scanning for jsp files.");
        StagingOptions staging = this.getStagingOptions(opts);
        if (Application.matchingFileExists(new File(stage.getPath()), JSP_REGEX)) {
            this.statusUpdate("Compiling jsp files.");
            File webInf = new File(stage, "WEB-INF");
            for (File file : AppengineSdk.getSdk().getUserJspLibFiles()) {
                this.copyOrLinkFile(file, new File(new File(webInf, "lib"), file.getName()));
            }
            for (File file : AppengineSdk.getSdk().getSharedJspLibFiles()) {
                this.copyOrLinkFile(file, new File(new File(webInf, "lib"), file.getName()));
            }
            File classes = new File(webInf, "classes");
            File generatedWebXml = new File(webInf, "generated_web.xml");
            this.jspJavaFilesGeneratedTempDirectory = com.google.appengine.repackaged.com.google.common.io.Files.createTempDir();
            String classpath = this.getJspClasspath(classes, this.getJspJavaFilesGeneratedTempDirectory());
            String[] args = new String[]{"-classpath", classpath, "-uriroot", stage.getPath(), "-p", "org.apache.jsp", "-l", "-v", "-webinc", generatedWebXml.getPath(), "-d", this.getJspJavaFilesGeneratedTempDirectory().getPath(), "-javaEncoding", staging.compileEncoding().get()};
            if (this.detailsWriter == null) {
                this.detailsWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset())), true);
            }
            URL[] classLoaderUrls = this.getJspClassPathURLs(classes, this.getJspJavaFilesGeneratedTempDirectory());
            ClassLoader platformLoader = ClassLoader.getSystemClassLoader().getParent();
            try (URLClassLoader urlClassLoader = new URLClassLoader(classLoaderUrls, platformLoader);){
                Class<?> jspCompiler = urlClassLoader.loadClass(this.getJSPCClassName());
                Method main = jspCompiler.getMethod("main", String[].class);
                main.invoke(null, new Object[]{args});
            }
            catch (InvocationTargetException e) {
                this.detailsWriter.println("Error while executing: " + this.formatCommand(Arrays.asList(args)));
                throw new JspCompilationException("Failed to compile jsp files.", JspCompilationException.Source.JASPER, e.getCause());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to compile jsp files.", e);
            }
            this.compileJspJavaFiles(classpath, webInf, this.getJspJavaFilesGeneratedTempDirectory(), opts, runtime);
            this.webXml = new WebXmlReader(stage.getPath()).readWebXml();
        }
    }

    File getJspJavaFilesGeneratedTempDirectory() {
        return this.jspJavaFilesGeneratedTempDirectory;
    }

    private void compileJspJavaFiles(String classpath, File webInf, File jspClassDir, ApplicationProcessingOptions opts, String runtime) throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new RuntimeException("Cannot get the System Java Compiler. Please use a JDK, not a JRE.");
        }
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        ArrayList<File> files = new ArrayList<File>();
        for (File f : new FileIterator(jspClassDir)) {
            if (!f.getPath().toLowerCase().endsWith(".java")) continue;
            files.add(f);
        }
        if (files.isEmpty()) {
            return;
        }
        StagingOptions staging = this.getStagingOptions(opts);
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.addAll(Arrays.asList("-classpath", classpath.toString()));
        optionList.addAll(Arrays.asList("-d", jspClassDir.getPath()));
        optionList.addAll(Arrays.asList("-encoding", staging.compileEncoding().get()));
        if (runtime.startsWith(JAVA_8_RUNTIME_ID)) {
            optionList.addAll(Arrays.asList("-source", "8"));
            optionList.addAll(Arrays.asList("-target", "8"));
        } else if (runtime.startsWith(GOOGLE_LEGACY_RUNTIME_ID) || runtime.equals(JAVA_11_RUNTIME_ID) || runtime.equals(JAVA_17_RUNTIME_ID) || runtime.equals(JAVA_21_RUNTIME_ID)) {
            optionList.addAll(Arrays.asList("-source", "8"));
            optionList.addAll(Arrays.asList("-target", "8"));
        }
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(files);
        boolean success = compiler.getTask(null, fileManager, null, optionList, null, compilationUnits).call();
        fileManager.close();
        if (!success) {
            throw new JspCompilationException("Failed to compile the generated JSP java files.", JspCompilationException.Source.JSPC);
        }
        if (staging.jarJsps().get().booleanValue()) {
            this.zipJasperGeneratedFiles(webInf, jspClassDir);
        } else {
            this.copyOrLinkDirectories(jspClassDir, new File(webInf, "classes"));
        }
        if (staging.deleteJsps().get().booleanValue()) {
            for (File f : new FileIterator(webInf.getParentFile())) {
                if (!f.getPath().toLowerCase().endsWith(".jsp")) continue;
                f.delete();
            }
        }
    }

    private void zipJasperGeneratedFiles(File webInfDir, File jspClassDir) throws IOException {
        ImmutableSet<String> fileTypesToExclude = ImmutableSet.of(".java");
        File libDir = new File(webInfDir, "lib");
        JarTool jarTool = new JarTool(COMPILED_JSP_JAR_NAME_PREFIX, jspClassDir, libDir, 0x500000, fileTypesToExclude);
        jarTool.run();
        Application.recursiveDelete(jspClassDir);
    }

    private void zipWebInfClassesFiles(File webInfDir) throws IOException {
        File libDir = new File(webInfDir, "lib");
        File classesDir = new File(webInfDir, "classes");
        JarTool jarTool = new JarTool(CLASSES_JAR_NAME_PREFIX, classesDir, libDir, 0x500000, null);
        jarTool.run();
        Application.recursiveDelete(classesDir);
        classesDir.mkdir();
    }

    private String getJspClasspath(File classDir, File genDir) {
        StringBuilder classpath = new StringBuilder();
        for (URL uRL : AppengineSdk.getSdk().getImplLibs()) {
            try {
                classpath.append(Paths.get(uRL.toURI()));
            }
            catch (URISyntaxException e) {
                classpath.append(uRL.getPath());
            }
            classpath.append(File.pathSeparatorChar);
        }
        for (File file : AppengineSdk.getSdk().getSharedLibFiles()) {
            classpath.append(file.getPath());
            classpath.append(File.pathSeparatorChar);
        }
        classpath.append(AppengineSdk.getSdk().getToolsApiJarFile().getAbsolutePath());
        classpath.append(File.pathSeparatorChar);
        classpath.append(classDir.getPath());
        classpath.append(File.pathSeparatorChar);
        classpath.append(genDir.getPath());
        classpath.append(File.pathSeparatorChar);
        for (File file : new FileIterator(new File(classDir.getParentFile(), "lib"))) {
            String filename = file.getPath().toLowerCase();
            if (!filename.endsWith(".jar") && !filename.endsWith(".zip")) continue;
            classpath.append(file.getPath());
            classpath.append(File.pathSeparatorChar);
        }
        return classpath.toString();
    }

    private URL[] getJspClassPathURLs(File classDir, File genDir) {
        try {
            ArrayList<URL> urls = new ArrayList<URL>(AppengineSdk.getSdk().getImplLibs());
            for (File lib : AppengineSdk.getSdk().getSharedLibFiles()) {
                urls.add(lib.toURI().toURL());
            }
            urls.add(AppengineSdk.getSdk().getToolsApiJarFile().toURI().toURL());
            urls.add(classDir.toURI().toURL());
            urls.add(genDir.toURI().toURL());
            for (File f : new FileIterator(new File(classDir.getParentFile(), "lib"))) {
                String filename = f.getPath().toLowerCase();
                if (!filename.endsWith(".jar") && !filename.endsWith(".zip")) continue;
                urls.add(f.toURI().toURL());
            }
            return urls.toArray(new URL[urls.size()]);
        }
        catch (MalformedURLException e) {
            throw new AppEngineConfigException("Failure while creating the JSP compiler classloader URLs.", e);
        }
    }

    private String formatCommand(Iterable<String> args) {
        StringBuilder command = new StringBuilder();
        for (String chunk : args) {
            command.append(chunk);
            command.append(" ");
        }
        return command.toString();
    }

    private static boolean matchingFileExists(File dir, Pattern regex) {
        for (File file : dir.listFiles()) {
            if (!(file.isDirectory() ? Application.matchingFileExists(file, regex) : regex.matcher(file.getName()).matches())) continue;
            return true;
        }
        return false;
    }

    private static void splitJars(File dir, int max, Set<String> excludes) throws IOException {
        String[] children = dir.list();
        if (children == null) {
            return;
        }
        for (String name : children) {
            File subfile = new File(dir, name);
            if (subfile.isDirectory()) {
                Application.splitJars(subfile, max, excludes);
                continue;
            }
            if (!name.endsWith(".jar") || subfile.length() <= (long)max) continue;
            new JarSplitter(subfile, dir, max, false, 4, excludes).run();
            subfile.delete();
        }
    }

    private void copyOrLink(File sourceDir, File resDir, File staticDir, boolean forceResource, ApplicationProcessingOptions opts, String runtime) throws IOException {
        for (String name : sourceDir.list()) {
            File file = new File(sourceDir, name);
            String path = file.getPath();
            if (File.separatorChar == '\\') {
                path = path.replace('\\', '/');
            }
            if (file.getName().startsWith(".") || file.equals(GenerationDirectory.getGenerationDirectory(this.baseDir))) continue;
            if (file.isDirectory()) {
                if (file.getName().equals("WEB-INF")) {
                    this.copyOrLink(file, new File(resDir, name), new File(staticDir, name), true, opts, runtime);
                    continue;
                }
                this.copyOrLink(file, new File(resDir, name), new File(staticDir, name), forceResource, opts, runtime);
                continue;
            }
            if (SKIP_FILES.matcher(path).matches()) continue;
            if (forceResource || this.appEngineWebXml.includesResource(path) || opts.isCompileJspsSet() && name.toLowerCase().endsWith(".jsp")) {
                this.copyOrLinkFile(file, new File(resDir, name));
            }
            if (forceResource || !this.appEngineWebXml.includesStatic(path)) continue;
            this.copyOrLinkFile(file, new File(staticDir, name));
        }
    }

    private void copyOrLinkFile(File source, File dest) throws IOException {
        block16: {
            dest.getParentFile().mkdirs();
            if (shouldAttemptSymlink && !source.getName().endsWith("web.xml")) {
                try {
                    dest.delete();
                }
                catch (Exception e) {
                    System.err.println("Warning: We tried to delete " + dest.getPath());
                    System.err.println("in order to create a symlink from " + source.getPath());
                    System.err.println("but the delete failed with message: " + e.getMessage());
                }
                try {
                    Files.createSymbolicLink(dest.toPath(), source.toPath().toAbsolutePath(), new FileAttribute[0]);
                    return;
                }
                catch (IOException e) {
                    System.err.println("Failed to create symlink: " + e.getMessage());
                    if (!dest.delete()) break block16;
                    System.err.println("createSymbolicLink failed but symlink was created, removed: " + dest.getAbsolutePath());
                }
            }
        }
        try (FileInputStream inStream = new FileInputStream(source);
             FileOutputStream outStream = new FileOutputStream(dest);){
            byte[] buffer = new byte[1024];
            int readlen = inStream.read(buffer);
            while (readlen > -1) {
                outStream.write(buffer, 0, readlen);
                readlen = inStream.read(buffer);
            }
        }
    }

    private void copyOrLinkDirectories(File sourceDir, File destination) throws IOException {
        for (String name : sourceDir.list()) {
            File file = new File(sourceDir, name);
            if (file.isDirectory()) {
                this.copyOrLinkDirectories(file, new File(destination, name));
                continue;
            }
            this.copyOrLinkFile(file, new File(destination, name));
        }
    }

    @Override
    public void cleanStagingDirectory() {
        if (this.stageDir != null) {
            Application.recursiveDelete(this.stageDir);
        }
    }

    public static void recursiveDelete(File dead) {
        String[] files = dead.list();
        if (files != null) {
            for (String name : files) {
                Application.recursiveDelete(new File(dead, name));
            }
        }
        dead.delete();
    }

    @Override
    public void setListener(UpdateListener l) {
        this.listener = l;
    }

    @Override
    public void setDetailsWriter(PrintWriter detailsWriter) {
        this.detailsWriter = detailsWriter;
    }

    @Override
    public void statusUpdate(String message, int amount) {
        this.updateProgress += this.progressAmount;
        if (this.updateProgress > 99) {
            this.updateProgress = 99;
        }
        this.progressAmount = amount;
        if (this.listener != null) {
            this.listener.onProgress(new UpdateProgressEvent(Thread.currentThread(), message, this.updateProgress));
        }
    }

    @Override
    public void statusUpdate(String message) {
        int amount = this.progressAmount / 4;
        this.updateProgress += amount;
        if (this.updateProgress > 99) {
            this.updateProgress = 99;
        }
        this.progressAmount -= amount;
        if (this.listener != null) {
            this.listener.onProgress(new UpdateProgressEvent(Thread.currentThread(), message, this.updateProgress));
        }
    }

    private String generateAppYaml(File stageDir, String runtime, AppEngineWebXml aeWebXml) {
        HashSet<String> staticFiles = new HashSet<String>();
        for (File f : new FileIterator(new File(stageDir, "__static__"))) {
            staticFiles.add(Utility.calculatePath(f, stageDir));
        }
        AppYamlTranslator translator = new AppYamlTranslator(aeWebXml, this.getWebXml(), this.getBackendsXml(), this.getApiVersion(), staticFiles, null, runtime);
        String yaml = translator.getYaml();
        logger.fine("Generated app.yaml file:\n" + yaml);
        return yaml;
    }

    @Override
    public String getAppYaml() {
        if (this.appYaml == null) {
            throw new IllegalStateException("Must call createStagingDirectory first.");
        }
        return this.appYaml;
    }

    private void writeDefaultWebXml(File webXmlFile) {
        try {
            com.google.appengine.repackaged.com.google.common.io.Files.asCharSink(webXmlFile, StandardCharsets.UTF_8, new FileWriteMode[0]).write(DEFAULT_WEB_XML_CONTENT);
        }
        catch (IOException e) {
            String message = "Error encountered when attempting to generate file " + webXmlFile.getAbsolutePath();
            if (!webXmlFile.getParentFile().exists()) {
                message = "Could not find the WEB-INF directory in " + webXmlFile.getParent() + ". The given application file path must point to an exploded WAR directory that contains a WEB-INF directory.";
            }
            throw new AppEngineConfigException(message, e);
        }
    }

    private void createQuickstartWebXml(ApplicationProcessingOptions opts) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        int status;
        boolean notGAEStandard;
        String javaCmd = opts.getJavaExecutable().getPath();
        boolean bl = notGAEStandard = this.appEngineWebXml.getUseVm() || this.appEngineWebXml.isFlexible();
        if (notGAEStandard) {
            throw new AppEngineConfigException("Google App Engine Flex or Managed VM runtime is not supported anymore.");
        }
        if (!this.isJava8OrAbove()) {
            throw new AppEngineConfigException("Servlet 3.1 annotations processing is only supported with Java8 runtime. Please downgrade the servlet version to 2.5 in the web.xml file.");
        }
        String quickstartClassPath = AppengineSdk.getSdk().getQuickStartClasspath();
        File webDefaultXml = new File(AppengineSdk.getSdk().getWebDefaultXml());
        String[] args = new String[]{javaCmd, "-cp", quickstartClassPath, "com.google.appengine.tools.development.jetty.QuickStartGenerator", this.stageDir.getAbsolutePath(), webDefaultXml.getAbsolutePath()};
        Process quickstartProcess = Utility.startProcess(this.detailsWriter, args);
        try {
            status = quickstartProcess.waitFor();
        }
        catch (InterruptedException ex) {
            status = 1;
        }
        if (status != 0) {
            this.detailsWriter.println("Error while executing: " + this.formatCommand(Arrays.asList(args)));
            throw new RuntimeException("Failed to generate quickstart-web.xml.");
        }
        File quickstartXml = new File(this.stageDir, "/WEB-INF/quickstart-web.xml");
        File minimizedQuickstartXml = new File(this.stageDir, "/WEB-INF/min-quickstart-web.xml");
        Document quickstartDoc = Application.getFilteredQuickstartDoc(!notGAEStandard, quickstartXml, webDefaultXml);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(com.google.appengine.repackaged.com.google.common.io.Files.newWriter(minimizedQuickstartXml, StandardCharsets.UTF_8));
        DOMSource source = new DOMSource(quickstartDoc);
        transformer.transform(source, result);
    }

    static Document getFilteredQuickstartDoc(boolean isGAEStandard, File quickstartXml, File webDefaultXml) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder webDefaultDocBuilder = docBuilderFactory.newDocumentBuilder();
        Document webDefaultDoc = webDefaultDocBuilder.parse(webDefaultXml);
        DocumentBuilder quickstartDocBuilder = docBuilderFactory.newDocumentBuilder();
        Document quickstartDoc = quickstartDocBuilder.parse(quickstartXml);
        if (isGAEStandard) {
            Application.removeNodes(webDefaultDoc, quickstartDoc, "welcome-file", 0);
            Application.removeNodes(webDefaultDoc, quickstartDoc, "servlet-name", 1);
            Application.removeNodes(webDefaultDoc, quickstartDoc, "filter-name", 1);
            Application.removeNodes(webDefaultDoc, quickstartDoc, "web-resource-name", 2);
            return quickstartDoc;
        }
        ImmutableSet<String> tagsToExamine = ImmutableSet.of("filter-mapping", "servlet-mapping");
        String urlPatternTag = "url-pattern";
        HashSet<String> defaultRoots = Sets.newHashSet();
        ArrayList<Node> nodesToRemove = Lists.newArrayList();
        webDefaultDoc.getDocumentElement().normalize();
        NodeList webDefaultChildren = webDefaultDoc.getDocumentElement().getElementsByTagName("url-pattern");
        for (int i = 0; i < webDefaultChildren.getLength(); ++i) {
            String url;
            Node child = webDefaultChildren.item(i);
            if (!tagsToExamine.contains(child.getParentNode().getNodeName()) || !(url = child.getTextContent().trim()).startsWith("/")) continue;
            defaultRoots.add(url);
        }
        quickstartDoc.getDocumentElement().normalize();
        NodeList quickstartChildren = quickstartDoc.getDocumentElement().getElementsByTagName("url-pattern");
        for (int i = 0; i < quickstartChildren.getLength(); ++i) {
            String url;
            Node child = quickstartChildren.item(i);
            if (!tagsToExamine.contains(child.getParentNode().getNodeName()) || !defaultRoots.contains(url = child.getTextContent().trim())) continue;
            nodesToRemove.add(child.getParentNode());
        }
        for (Node node : nodesToRemove) {
            quickstartDoc.getDocumentElement().removeChild(node);
        }
        return quickstartDoc;
    }

    private static void removeNodes(Document webDefaultDoc, Document quickstartDoc, String tagName, int parentLevel) {
        NodeList nodes = webDefaultDoc.getDocumentElement().getElementsByTagName(tagName);
        HashSet<String> namesToDelete = Sets.newHashSet();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            namesToDelete.add(child.getTextContent().trim());
        }
        NodeList nodesResult = quickstartDoc.getDocumentElement().getElementsByTagName(tagName);
        ArrayList<Node> nodesToRemove = Lists.newArrayList();
        for (int i = 0; i < nodesResult.getLength(); ++i) {
            Node child = nodesResult.item(i);
            if (!namesToDelete.contains(child.getTextContent().trim())) continue;
            Node nodeToRemove = child;
            for (int p = 0; p < parentLevel; ++p) {
                nodeToRemove = nodeToRemove.getParentNode();
            }
            nodesToRemove.add(nodeToRemove);
        }
        for (Node node : nodesToRemove) {
            node.getParentNode().removeChild(node);
        }
    }

    static {
        logger = Logger.getLogger(Application.class.getName());
        mimeTypes = new MimeTypes();
        SKIP_FILES = Pattern.compile("^(.*/)?((#.*#)|(.*~)|(.*/RCS/.*)|)$");
    }

    private static class ClassCounterVisitor
    extends SimpleFileVisitor<Path> {
        private int classCount = 0;

        private ClassCounterVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            if (file.getFileName().toString().endsWith(".class")) {
                ++this.classCount;
            }
            return FileVisitResult.CONTINUE;
        }

        private int classCount() {
            return this.classCount;
        }
    }
}

