/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.apphosting.runtime;

import java.util.List;

/**
 * A Factory for creating {@link SessionStore SessionStores}.
 *
 */
public interface SessionStoreFactory {

  /**
   * Returns a list of {@code SessionStores}, in write order. The session will be
   * written to the stores in the order returned from this method.
   */
  public List<SessionStore> createSessionStores(SessionsConfig sessionsConfig);
}
