/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.tools.admin.OutputPump;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;

public class Utility {
    private static final Logger logger = Logger.getLogger(Utility.class.getCanonicalName());
    private static final String FORWARD_SLASH = "/";

    public static boolean isOsUnix() {
        return File.separator.equals(FORWARD_SLASH);
    }

    public static boolean isOsWindows() {
        return !Utility.isOsUnix();
    }

    public static String calculatePath(File f, File base) {
        int offset = base.getPath().length();
        String path = f.getPath().substring(offset);
        if (File.separatorChar == '\\') {
            path = path.replace('\\', '/');
        }
        offset = 0;
        while (path.charAt(offset) == '/') {
            ++offset;
        }
        if (offset > 0) {
            path = path.substring(offset);
        }
        return path;
    }

    public static String jsonEscape(String s) {
        StringBuilder stringBuilder = new StringBuilder();
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '/': {
                    stringBuilder.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= ' ' && ch < '\u007f') {
                        stringBuilder.append(ch);
                        continue block10;
                    }
                    stringBuilder.append(String.format("\\u%04x", ch));
                }
            }
        }
        return stringBuilder.toString();
    }

    private Utility() {
    }

    static Process startProcess(PrintWriter detailsWriter, String ... args) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(args);
        Process proc = builder.redirectErrorStream(true).start();
        logger.fine(Joiner.on(" ").join(builder.command()));
        new Thread(new OutputPump(proc.getInputStream(), detailsWriter)).start();
        return proc;
    }
}

