/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.tools.info.ClassicSdk;
import com.google.appengine.tools.info.Jetty12Sdk;
import com.google.appengine.tools.info.OptionalLib;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class AppengineSdk {
    public static final String DEFAULT_SERVER = "appengine.google.com";
    private static AppengineSdk currentSdk;
    public static final String SDK_ROOT_PROPERTY = "appengine.sdk.root";
    static File sdkRoot;
    static boolean isDevAppServerTest;
    private static final FileFilter NO_HIDDEN_FILES;

    AppengineSdk() {
        sdkRoot = AppengineSdk.findSdkRoot();
    }

    List<File> getLibs(File sdkRoot, String libSubDir) {
        return AppengineSdk.getLibs(sdkRoot, libSubDir, false);
    }

    static List<File> getLibsRecursive(File sdkRoot, String libSubDir) {
        return AppengineSdk.getLibs(sdkRoot, libSubDir, true);
    }

    private static List<File> getLibs(File sdkRoot, String libSubDir, boolean recursive) {
        File subDir = new File(sdkRoot, "lib" + File.separator + libSubDir);
        if (!subDir.exists()) {
            throw new IllegalArgumentException("Unable to find " + subDir.getAbsolutePath());
        }
        ArrayList<File> libs = new ArrayList<File>();
        AppengineSdk.getLibs(subDir, libs, recursive);
        return libs;
    }

    private static void getLibs(File dir, List<File> list, boolean recursive) {
        for (File f : AppengineSdk.listFiles(dir)) {
            if (f.isDirectory() && recursive) {
                AppengineSdk.getLibs(f, list, recursive);
                continue;
            }
            if (!f.getName().endsWith(".jar")) continue;
            list.add(f);
        }
    }

    private static File findSdkRoot() {
        File libDir;
        String explicitRootString = System.getProperty(SDK_ROOT_PROPERTY);
        if (explicitRootString != null) {
            return new File(explicitRootString);
        }
        URL codeLocation = AppengineSdk.class.getProtectionDomain().getCodeSource().getLocation();
        String msg = "Unable to discover the Google App Engine SDK root. This code should be loaded from the SDK directory, but was instead loaded from " + codeLocation + ".  Specify -Dappengine.sdk.root to override the SDK location.";
        try {
            libDir = new File(codeLocation.toURI());
        }
        catch (URISyntaxException e) {
            libDir = new File(codeLocation.getFile());
        }
        while (!libDir.getName().equals("lib")) {
            if ((libDir = libDir.getParentFile()) != null) continue;
        }
        return libDir.getParentFile();
    }

    public abstract List<URL> getSharedLibs();

    @Deprecated
    public List<URL> getUserLibs() {
        return Collections.unmodifiableList(AppengineSdk.toURLs(this.getUserLibFiles()));
    }

    @Deprecated
    public List<File> getUserLibFiles() {
        List<File> userLibFiles = new File(sdkRoot, "lib" + File.separator + "user").isDirectory() ? Collections.unmodifiableList(AppengineSdk.getLibsRecursive(sdkRoot, "user")) : Collections.emptyList();
        return userLibFiles;
    }

    public static File getSdkRoot() {
        return sdkRoot;
    }

    public static void resetSdk() {
        currentSdk = null;
    }

    public synchronized void setSdkRoot(File root) {
        if (!sdkRoot.equals(root)) {
            throw new IllegalStateException("Cannot set SDK root after initialization has occurred.");
        }
        sdkRoot = root;
        currentSdk = null;
    }

    public static void includeTestingJarOnSharedPath(boolean val) {
        isDevAppServerTest = val;
    }

    private SortedMap<String, OptionalLib> determineOptionalUserLibs() {
        return this.determineOptionalLibs(new File(sdkRoot, "lib/opt/user"));
    }

    private SortedMap<String, OptionalLib> determineOptionalToolsLibs() {
        return this.determineOptionalLibs(new File(sdkRoot, "lib/opt/tools"));
    }

    private SortedMap<String, OptionalLib> determineOptionalLibs(File root) {
        TreeMap<String, OptionalLib> map = new TreeMap<String, OptionalLib>();
        for (File libDir : AppengineSdk.listFiles(root)) {
            TreeMap<String, List<File>> filesByVersion = new TreeMap<String, List<File>>();
            for (File version : AppengineSdk.listFiles(libDir)) {
                ArrayList<File> filesForVersion = new ArrayList<File>();
                AppengineSdk.getLibs(version, filesForVersion, true);
                filesByVersion.put(version.getName(), filesForVersion);
            }
            String description = "";
            OptionalLib userLib = new OptionalLib(libDir.getName(), description, filesByVersion);
            map.put(userLib.getName(), userLib);
        }
        return map;
    }

    public File getLoggingProperties() {
        return new File(AppengineSdk.getSdkRoot() + File.separator + "config" + File.separator + "sdk" + File.separator + "logging.properties");
    }

    public File getToolsApiJarFile() {
        return new File(AppengineSdk.getSdkRoot() + "/lib/appengine-tools-api.jar");
    }

    public URL getToolsApiJar() {
        File f = new File(AppengineSdk.getSdkRoot() + File.separator + "lib" + File.separator + "appengine-tools-api.jar");
        return AppengineSdk.toURL(f);
    }

    static File[] listFiles(File dir) {
        File[] files = dir.listFiles(NO_HIDDEN_FILES);
        if (files == null) {
            return new File[0];
        }
        return files;
    }

    public static AppengineSdk getSdk() {
        if (currentSdk != null) {
            return currentSdk;
        }
        if (Boolean.getBoolean("appengine.use.jetty12")) {
            currentSdk = new Jetty12Sdk();
            return currentSdk;
        }
        currentSdk = new ClassicSdk();
        return currentSdk;
    }

    public static void setSdk(AppengineSdk sdk) {
        currentSdk = Preconditions.checkNotNull(sdk);
    }

    public List<URL> getDatanucleusLibs(String version) {
        this.validateDatanucleusVersions(version);
        return ((OptionalLib)this.determineOptionalToolsLibs().get("datanucleus")).getURLsForVersion(version);
    }

    public abstract List<URL> getUserJspLibs();

    public abstract List<URL> getImplLibs();

    public abstract String getQuickStartClasspath();

    public abstract String getWebDefaultXml();

    public abstract File getResourcesDirectory();

    public abstract String getWebDefaultLocation();

    public abstract String getJSPCompilerClassName();

    public String getDefaultServer() {
        return DEFAULT_SERVER;
    }

    public void validateDatanucleusVersions(String version) {
        if (!version.equals("v1") && !version.equals("v2")) {
            throw new IllegalArgumentException("Invalid Datanucleus version: " + version);
        }
    }

    static List<URL> toURLs(List<File> files) {
        ArrayList<URL> urls = new ArrayList<URL>(files.size());
        for (File file : files) {
            urls.add(AppengineSdk.toURL(file));
        }
        return urls;
    }

    private static URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable get a URL from " + file, e);
        }
    }

    public abstract Iterable<File> getUserJspLibFiles();

    public abstract Iterable<File> getSharedJspLibFiles();

    public abstract Iterable<File> getSharedLibFiles();

    static {
        sdkRoot = null;
        NO_HIDDEN_FILES = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isHidden();
            }
        };
    }
}

