/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.document;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.Version;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlException;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.document.YamlAlias;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.document.YamlDocument;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.document.YamlElement;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.document.YamlEntry;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.document.YamlMapping;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.document.YamlScalar;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.document.YamlSequence;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.parser.AliasEvent;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.parser.Event;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.parser.EventType;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.parser.MappingStartEvent;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.parser.Parser;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.parser.ScalarEvent;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.parser.SequenceStartEvent;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.tokenizer.Tokenizer;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlDocumentReader {
    Parser parser;

    public YamlDocumentReader(String yaml) {
        this(new StringReader(yaml));
    }

    public YamlDocumentReader(String yaml, Version version) {
        this(new StringReader(yaml), version);
    }

    public YamlDocumentReader(Reader reader) {
        this(reader, null);
    }

    public YamlDocumentReader(Reader reader, Version version) {
        if (version == null) {
            version = Version.DEFAULT_VERSION;
        }
        this.parser = new Parser(reader, version);
    }

    public YamlDocument read() throws YamlException {
        return this.read(YamlDocument.class);
    }

    public <T> T read(Class<T> type) throws YamlException {
        try {
            block8: while (true) {
                Event event;
                if ((event = this.parser.peekNextEvent()) == null) {
                    return null;
                }
                switch (event.type) {
                    case STREAM_START: {
                        this.parser.getNextEvent();
                        continue block8;
                    }
                    case STREAM_END: {
                        this.parser.getNextEvent();
                        return null;
                    }
                    case DOCUMENT_START: {
                        this.parser.getNextEvent();
                        return (T)this.readDocument();
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (Parser.ParserException ex) {
            throw new YamlException("Error parsing YAML.", ex);
        }
        catch (Tokenizer.TokenizerException ex) {
            throw new YamlException("Error tokenizing YAML.", ex);
        }
    }

    public <T> Iterator<T> readAll(final Class<T> type) {
        Iterator iterator2 = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                Event event = YamlDocumentReader.this.parser.peekNextEvent();
                return event != null && event.type != EventType.STREAM_END;
            }

            @Override
            public T next() {
                try {
                    return YamlDocumentReader.this.read(type);
                }
                catch (YamlException e) {
                    throw new RuntimeException("Iterative reading documents exception", e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return iterator2;
    }

    private YamlElement readDocument() {
        YamlElement yamlElement = null;
        Event event = this.parser.peekNextEvent();
        switch (event.type) {
            case SCALAR: {
                yamlElement = this.readScalar();
                break;
            }
            case ALIAS: {
                yamlElement = this.readAlias();
                break;
            }
            case MAPPING_START: {
                yamlElement = this.readMapping();
                break;
            }
            case SEQUENCE_START: {
                yamlElement = this.readSequence();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.parser.getNextEvent();
        return yamlElement;
    }

    private YamlMapping readMapping() {
        Event event = this.parser.getNextEvent();
        if (event.type != EventType.MAPPING_START) {
            throw new IllegalStateException();
        }
        YamlMapping element = new YamlMapping();
        MappingStartEvent mapping = (MappingStartEvent)event;
        element.setTag(mapping.tag);
        element.setAnchor(mapping.anchor);
        this.readMappingElements(element);
        return element;
    }

    private void readMappingElements(YamlMapping mapping) {
        while (true) {
            Event event = this.parser.peekNextEvent();
            if (event.type == EventType.MAPPING_END) {
                this.parser.getNextEvent();
                return;
            }
            YamlEntry entry = this.readEntry();
            mapping.addEntry(entry);
        }
    }

    private YamlEntry readEntry() {
        YamlScalar scalar = this.readScalar();
        YamlElement value = this.readValue();
        return new YamlEntry(scalar, value);
    }

    private YamlElement readValue() {
        Event event = this.parser.peekNextEvent();
        switch (event.type) {
            case SCALAR: {
                return this.readScalar();
            }
            case ALIAS: {
                return this.readAlias();
            }
            case MAPPING_START: {
                return this.readMapping();
            }
            case SEQUENCE_START: {
                return this.readSequence();
            }
        }
        throw new IllegalStateException();
    }

    private YamlAlias readAlias() {
        Event event = this.parser.getNextEvent();
        if (event.type != EventType.ALIAS) {
            throw new IllegalStateException();
        }
        YamlAlias element = new YamlAlias();
        AliasEvent alias = (AliasEvent)event;
        element.setAnchor(alias.anchor);
        return element;
    }

    private YamlSequence readSequence() {
        Event event = this.parser.getNextEvent();
        if (event.type != EventType.SEQUENCE_START) {
            throw new IllegalStateException();
        }
        YamlSequence element = new YamlSequence();
        SequenceStartEvent sequence = (SequenceStartEvent)event;
        element.setTag(sequence.tag);
        element.setAnchor(sequence.anchor);
        this.readSequenceElements(element);
        return element;
    }

    private void readSequenceElements(YamlSequence sequence) {
        while (true) {
            Event event = this.parser.peekNextEvent();
            if (event.type == EventType.SEQUENCE_END) {
                this.parser.getNextEvent();
                return;
            }
            YamlElement element = this.readValue();
            sequence.addElement(element);
        }
    }

    private YamlScalar readScalar() {
        Event event = this.parser.getNextEvent();
        if (event.type != EventType.SCALAR) {
            throw new IllegalStateException();
        }
        ScalarEvent scalar = (ScalarEvent)event;
        YamlScalar element = new YamlScalar();
        element.setTag(scalar.tag);
        element.setAnchor(scalar.anchor);
        element.setValue(scalar.value);
        return element;
    }
}

