/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.context;

import com.google.appengine.repackaged.com.google.common.flogger.FluentLogger;
import com.google.appengine.repackaged.com.google.common.flogger.MetadataKey;
import com.google.appengine.repackaged.com.google.common.flogger.StackSize;
import com.google.appengine.repackaged.com.google.common.flogger.context.ContextDataProvider;
import com.google.appengine.repackaged.com.google.common.flogger.context.LogLevelMap;
import com.google.appengine.repackaged.com.google.common.flogger.context.ScopeType;
import com.google.appengine.repackaged.com.google.common.flogger.context.ScopedLoggingContext;
import com.google.appengine.repackaged.com.google.common.flogger.context.Tags;
import java.util.concurrent.atomic.AtomicBoolean;

final class NoOpContextDataProvider
extends ContextDataProvider {
    private static final ContextDataProvider NO_OP_INSTANCE = new NoOpContextDataProvider();
    private final ScopedLoggingContext noOpContext = new NoOpScopedLoggingContext();

    NoOpContextDataProvider() {
    }

    static final ContextDataProvider getNoOpInstance() {
        return NO_OP_INSTANCE;
    }

    @Override
    public ScopedLoggingContext getContextApiSingleton() {
        return this.noOpContext;
    }

    public String toString() {
        return "No-op Provider";
    }

    private static final class NoOpScopedLoggingContext
    extends ScopedLoggingContext
    implements ScopedLoggingContext.LoggingContextCloseable {
        private final AtomicBoolean haveWarned = new AtomicBoolean();

        private NoOpScopedLoggingContext() {
        }

        private void logWarningOnceOnly() {
            if (this.haveWarned.compareAndSet(false, true)) {
                ((FluentLogger.Api)((FluentLogger.Api)LazyLogger.logger.atWarning()).withStackTrace(StackSize.SMALL)).log("Scoped logging contexts are disabled; no context data provider was installed.\nTo enable scoped logging contexts in your application, see the site-specific Platform class used to configure logging behaviour.\nDefault Platform: com.google.common.flogger.backend.system.DefaultPlatform");
            }
        }

        @Override
        public ScopedLoggingContext.Builder newContext() {
            return new ScopedLoggingContext.Builder(){

                @Override
                public ScopedLoggingContext.LoggingContextCloseable install() {
                    NoOpScopedLoggingContext.this.logWarningOnceOnly();
                    return NoOpScopedLoggingContext.this;
                }
            };
        }

        @Override
        public ScopedLoggingContext.Builder newContext(ScopeType scopeType) {
            return this.newContext();
        }

        @Override
        public boolean addTags(Tags tags) {
            this.logWarningOnceOnly();
            return super.addTags(tags);
        }

        @Override
        public <T> boolean addMetadata(MetadataKey<T> key, T value) {
            this.logWarningOnceOnly();
            return super.addMetadata(key, value);
        }

        @Override
        public boolean applyLogLevelMap(LogLevelMap logLevelMap) {
            this.logWarningOnceOnly();
            return super.applyLogLevelMap(logLevelMap);
        }

        @Override
        public void close() {
        }

        @Override
        boolean isNoOp() {
            return true;
        }

        private static final class LazyLogger {
            private static final FluentLogger logger = FluentLogger.forEnclosingClass();

            private LazyLogger() {
            }
        }
    }
}

