/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools;

import com.google.appengine.repackaged.com.google.common.base.Ascii;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.base.StandardSystemProperty;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.tools.development.DevAppServerMain;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;

public class KickStart {
    private static final Logger logger = Logger.getLogger(KickStart.class.getName());
    private static final String JVM_FLAG = "--jvm_flag";
    private static final String JVM_FLAG_ERROR_MESSAGE = "--jvm_flag=<flag> expected.\n--jvm_flag may be repeated to supply multiple flags";
    private static final String START_ON_FIRST_THREAD_FLAG = "--startOnFirstThread";
    private static final String START_ON_FIRST_THREAD_ERROR_MESSAGE = "--startOnFirstThread=<boolean> expected";
    private static final String SDK_ROOT_FLAG = "--sdk_root";
    private static final String SDK_ROOT_ERROR_MESSAGE = "--sdk_root=<path> expected";
    private Process serverProcess = null;
    private static String gaeRuntime = null;

    public static void main(String[] args) {
        new KickStart(args);
    }

    @CanIgnoreReturnValue
    private KickStart(String[] args) {
        String classpath;
        String entryClass = null;
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        String home = StandardSystemProperty.JAVA_HOME.value();
        String javaExe = home + File.separator + "bin" + File.separator + "java";
        ArrayList<String> jvmArgs = new ArrayList<String>();
        ArrayList<String> appServerArgs = new ArrayList<String>();
        List<String> command = builder.command();
        command.add(javaExe);
        boolean startOnFirstThread = Ascii.equalsIgnoreCase(StandardSystemProperty.OS_NAME.value(), "Mac OS X");
        boolean testMode = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith(JVM_FLAG)) {
                jvmArgs.add(KickStart.extractValue(args[i], JVM_FLAG_ERROR_MESSAGE));
                continue;
            }
            if (args[i].startsWith(SDK_ROOT_FLAG)) {
                String sdkRoot = new File(KickStart.extractValue(args[i], SDK_ROOT_ERROR_MESSAGE)).getAbsolutePath();
                System.setProperty("appengine.sdk.root", sdkRoot);
                jvmArgs.add("-Dappengine.sdk.root=" + sdkRoot);
                continue;
            }
            if (args[i].startsWith(START_ON_FIRST_THREAD_FLAG)) {
                startOnFirstThread = Boolean.parseBoolean(KickStart.extractValue(args[i], START_ON_FIRST_THREAD_ERROR_MESSAGE));
                continue;
            }
            if (args[i].equals("--test_mode")) {
                testMode = true;
                continue;
            }
            if (entryClass == null) {
                if (args[i].charAt(0) == '-') {
                    throw new IllegalArgumentException("This argument may not precede the classname: " + args[i]);
                }
                entryClass = args[i];
                if (entryClass.equals(DevAppServerMain.class.getName()) || testMode) continue;
                throw new IllegalArgumentException("KickStart only works for DevAppServerMain");
            }
            appServerArgs.add(args[i]);
        }
        if (entryClass == null) {
            throw new IllegalArgumentException("missing entry classname");
        }
        File newWorkingDir = KickStart.newWorkingDir(appServerArgs.toArray(new String[0]));
        builder.directory(newWorkingDir);
        if (startOnFirstThread) {
            jvmArgs.add("-XstartOnFirstThread");
        }
        if (!StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value().equals("1.8")) {
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.base/java.net=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.base/sun.net.www.protocol.http=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.base/sun.net.www.protocol.https=ALL-UNNAMED");
        }
        if ((classpath = StandardSystemProperty.JAVA_CLASS_PATH.value()) == null) {
            throw new IllegalArgumentException("classpath must not be null");
        }
        StringBuilder newClassPath = new StringBuilder();
        List<String> paths = Splitter.onPattern(File.pathSeparator).splitToList(classpath);
        for (int i = 0; i < paths.size(); ++i) {
            newClassPath.append(new File(paths.get(i)).getAbsolutePath());
            if (i == paths.size() - 1) continue;
            newClassPath.append(File.pathSeparator);
        }
        if (appServerArgs.isEmpty() || ((String)Iterables.getLast(appServerArgs)).startsWith("-")) {
            new DevAppServerMain().printHelp(System.out);
            System.exit(1);
        }
        Path workingDir = Paths.get((String)Iterables.getLast(appServerArgs), new String[0]);
        new DevAppServerMain().validateWarPath(workingDir.toFile());
        String appDir = null;
        ArrayList<String> absoluteAppServerArgs = new ArrayList<String>(appServerArgs.size());
        for (int i = 0; i < appServerArgs.size(); ++i) {
            File file;
            String arg = (String)appServerArgs.get(i);
            if (i == appServerArgs.size() - 1 && !arg.startsWith("-") && (file = new File(arg)).exists()) {
                appDir = arg = new File(arg).getAbsolutePath();
            }
            absoluteAppServerArgs.add(arg);
        }
        AppEnvironment appEnvironment = KickStart.readAppEnvironment(appDir);
        String encoding = appEnvironment.encoding;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        jvmArgs.add("-Dfile.encoding=" + encoding);
        command.addAll(jvmArgs);
        command.add("-classpath");
        command.add(newClassPath.toString());
        command.add(entryClass);
        command.add("--property=kickstart.user.dir=" + StandardSystemProperty.USER_DIR.value());
        command.addAll(absoluteAppServerArgs);
        String gaeEnv = "localdev";
        builder.environment().put("GAE_ENV", gaeEnv);
        builder.environment().put("GAE_RUNTIME", gaeRuntime);
        builder.environment().put("GAE_SERVICE", appEnvironment.serviceName);
        builder.environment().put("GAE_INSTANCE", UUID.randomUUID().toString());
        builder.inheritIO();
        logger.fine("Executing " + command);
        System.out.println("Executing " + command);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (KickStart.this.serverProcess != null) {
                    KickStart.this.serverProcess.destroy();
                }
            }
        });
        try {
            this.serverProcess = builder.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to start the process", e);
        }
        try {
            this.serverProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.serverProcess.destroy();
        this.serverProcess = null;
    }

    private static String extractValue(String argument, String errorMessage) {
        int indexOfEqualSign = argument.indexOf(61);
        if (indexOfEqualSign == -1) {
            throw new IllegalArgumentException(errorMessage);
        }
        return argument.substring(argument.indexOf(61) + 1);
    }

    private static File newWorkingDir(String[] args) {
        if (args.length < 1 || args[args.length - 1].startsWith("-")) {
            new DevAppServerMain().printHelp(System.out);
            System.exit(1);
        }
        File workingDir = new File(args[args.length - 1]);
        new DevAppServerMain().validateWarPath(workingDir);
        return workingDir;
    }

    static AppEnvironment readAppEnvironment(String appDir) {
        if (appDir == null) {
            return AppEnvironment.DEFAULT;
        }
        ArrayList<AppEngineWebXml> configs = new ArrayList<AppEngineWebXml>();
        File config = new File(appDir, "WEB-INF/appengine-web.xml");
        if (config.exists()) {
            try {
                AppEngineWebXml xml = new AppEngineWebXmlReader(appDir).readAppEngineWebXml();
                gaeRuntime = xml.getRuntime();
                if (gaeRuntime == null) {
                    gaeRuntime = "java8";
                }
                configs.add(xml);
            }
            catch (AppEngineConfigException e) {
                System.err.println("Error reading module: " + config.getAbsolutePath());
                return AppEnvironment.DEFAULT;
            }
        } else {
            File ear = new File(appDir);
            if (!ear.exists()) {
                System.err.println("Application does not exist: " + ear.getAbsolutePath());
                return AppEnvironment.DEFAULT;
            }
            for (File war : ear.listFiles()) {
                File currConfig = new File(war, "WEB-INF/appengine-web.xml");
                if (!currConfig.exists()) continue;
                try {
                    configs.add(new AppEngineWebXmlReader(war.getAbsolutePath()).readAppEngineWebXml());
                }
                catch (AppEngineConfigException e) {
                    System.err.println("Error reading module: " + war.getAbsolutePath());
                }
            }
        }
        String serviceName = "default";
        String encoding = null;
        for (AppEngineWebXml currConfig : configs) {
            Map<String, String> systemProperties;
            if (currConfig.getService() != null) {
                serviceName = currConfig.getService();
            } else if (currConfig.getModule() != null) {
                serviceName = currConfig.getModule();
            }
            if (!(systemProperties = currConfig.getSystemProperties()).containsKey("appengine.file.encoding")) continue;
            encoding = systemProperties.get("appengine.file.encoding");
        }
        return new AppEnvironment(serviceName, encoding);
    }

    static class AppEnvironment {
        static final AppEnvironment DEFAULT = new AppEnvironment("default", null);
        final String serviceName;
        final String encoding;

        AppEnvironment(String serviceName, String encoding) {
            this.serviceName = serviceName;
            this.encoding = encoding;
        }
    }
}

