/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlException;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.DosXml;
import com.google.apphosting.utils.config.YamlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;

public class DosYamlReader {
    private static final String FILENAME = "dos.yaml";
    private String appDir;

    public DosYamlReader(String appDir) {
        if (appDir.length() > 0 && appDir.charAt(appDir.length() - 1) != File.separatorChar) {
            appDir = appDir + File.separatorChar;
        }
        this.appDir = appDir;
    }

    public String getFilename() {
        return this.appDir + FILENAME;
    }

    public DosXml parse() {
        if (new File(this.getFilename()).exists()) {
            try {
                return DosYamlReader.parse(new FileReader(this.getFilename()));
            }
            catch (FileNotFoundException ex) {
                throw new AppEngineConfigException("Cannot find file " + this.getFilename(), ex);
            }
        }
        return null;
    }

    public static DosXml parse(Reader yaml) {
        try {
            DosYaml dosYaml = YamlUtils.parse(yaml, DosYaml.class);
            if (dosYaml == null) {
                throw new AppEngineConfigException("Empty dos configuration.");
            }
            return dosYaml.toXml();
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage(), ex);
        }
    }

    public static DosXml parse(String yaml) {
        return DosYamlReader.parse(new StringReader(yaml));
    }

    public static class DosYaml {
        private List<DosXml.BlacklistEntry> entries;

        public List<DosXml.BlacklistEntry> getBlacklist() {
            return this.entries;
        }

        public void setBlacklist(List<DosXml.BlacklistEntry> entries) {
            this.entries = entries;
        }

        public DosXml toXml() {
            DosXml xml = new DosXml();
            if (this.entries != null) {
                for (DosXml.BlacklistEntry entry : this.entries) {
                    xml.addBlacklistEntry(entry);
                }
            }
            return xml;
        }
    }
}

