/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.tools.info.AppengineSdk;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class Jetty12Sdk
extends AppengineSdk {
    static final String JETTY12_HOME_LIB_PATH = "jetty12/jetty-home/lib";
    private static final String WEB_DEFAULT_LOCATION_DEVAPPSERVERJETTY12 = "com/google/appengine/tools/development/jetty/webdefault.xml";
    private static final String WEB_DEFAULT_LOCATION_DEVAPPSERVERJETTY12EE10 = "com/google/appengine/tools/development/jetty/ee10/webdefault.xml";

    Jetty12Sdk() {
    }

    public List<File> getUserJspLibFiles() {
        return Collections.unmodifiableList(this.getJetty12JspJars());
    }

    @Override
    public String getWebDefaultLocation() {
        if (Boolean.getBoolean("appengine.use.EE10")) {
            return WEB_DEFAULT_LOCATION_DEVAPPSERVERJETTY12EE10;
        }
        return WEB_DEFAULT_LOCATION_DEVAPPSERVERJETTY12;
    }

    @Override
    public String getJettyContainerService() {
        if (Boolean.getBoolean("appengine.use.EE10")) {
            return "com.google.appengine.tools.development.jetty.ee10.JettyContainerService";
        }
        return "com.google.appengine.tools.development.jetty.JettyContainerService";
    }

    @Override
    public String getBackendServersClassName() {
        if (Boolean.getBoolean("appengine.use.EE10")) {
            return "com.google.appengine.tools.development.ee10.BackendServersEE10";
        }
        return "com.google.appengine.tools.development.BackendServersEE8";
    }

    @Override
    public String getModulesClassName() {
        if (Boolean.getBoolean("appengine.use.EE10")) {
            return "com.google.appengine.tools.development.ee10.ModulesEE10";
        }
        return "com.google.appengine.tools.development.ModulesEE8";
    }

    @Override
    public String getDelegatingModulesFilterHelperClassName() {
        if (Boolean.getBoolean("appengine.use.EE10")) {
            return "com.google.appengine.tools.development.ee10.DelegatingModulesFilterHelperEE10";
        }
        return "com.google.appengine.tools.development.DelegatingModulesFilterHelperEE8";
    }

    @Override
    public String getWebDefaultXml() {
        if (Boolean.getBoolean("appengine.use.EE10")) {
            return Jetty12Sdk.getSdkRoot() + "/docs/jetty12EE10/webdefault.xml";
        }
        return Jetty12Sdk.getSdkRoot() + "/docs/jetty12/webdefault.xml";
    }

    public List<File> getSharedJspLibFiles() {
        return Collections.unmodifiableList(this.getJetty12JspJars());
    }

    @Override
    public List<URL> getImplLibs() {
        return Collections.unmodifiableList(Jetty12Sdk.toURLs(this.getImplLibFiles()));
    }

    @Override
    public String getQuickStartClasspath() {
        ArrayList<String> list = new ArrayList<String>();
        File quickstart = Boolean.getBoolean("appengine.use.EE10") ? new File(Jetty12Sdk.getSdkRoot(), "lib/tools/quickstart/quickstartgenerator-jetty12-ee10.jar") : new File(Jetty12Sdk.getSdkRoot(), "lib/tools/quickstart/quickstartgenerator-jetty12.jar");
        String avoidJars = Boolean.getBoolean("appengine.use.EE10") ? "ee8" : "ee10";
        File jettyDir = new File(Jetty12Sdk.getSdkRoot(), JETTY12_HOME_LIB_PATH);
        for (File file : jettyDir.listFiles()) {
            if (file.isDirectory() || file.getName().contains("cdi-") || file.getName().contains("ee9") || file.getName().contains(avoidJars)) continue;
            list.add(file.getAbsolutePath());
        }
        list.add(Jetty12Sdk.getSdkRoot() + "/lib/impl/appengine-api.jar");
        if (Boolean.getBoolean("appengine.use.EE10")) {
            for (String string : new String[]{"ee10-annotations"}) {
                for (File f : new File(jettyDir, string).listFiles()) {
                    list.add(f.getAbsolutePath());
                }
            }
            for (String string : new String[]{"ee10-jaspi"}) {
                for (File f : new File(jettyDir, string).listFiles()) {
                    list.add(f.getAbsolutePath());
                }
            }
        } else {
            for (String string : new String[]{"ee8-annotations"}) {
                for (File f : new File(jettyDir, string).listFiles()) {
                    list.add(f.getAbsolutePath());
                }
            }
        }
        list.add(quickstart.getAbsolutePath());
        for (File file : new File(jettyDir, "logging").listFiles()) {
            list.add(file.getAbsolutePath());
        }
        return Joiner.on(System.getProperty("path.separator")).join(list);
    }

    @Override
    public File getResourcesDirectory() {
        return new File(Jetty12Sdk.getSdkRoot(), "docs");
    }

    private List<File> getImplLibFiles() {
        List<File> lf = this.getJetty12Jars("");
        lf.addAll(this.getJetty12JspJars());
        lf.addAll(this.getJetty12Jars("logging"));
        if (Boolean.getBoolean("appengine.use.EE10")) {
            lf.addAll(this.getJetty12Jars("ee10-annotations"));
            lf.addAll(this.getJetty12Jars("ee10-apache-jsp"));
            lf.addAll(this.getJetty12Jars("ee10-glassfish-jstl"));
        } else {
            lf.addAll(this.getJetty12Jars("ee8-annotations"));
            lf.addAll(this.getJetty12Jars("ee8-apache-jsp"));
            lf.addAll(this.getJetty12Jars("ee8-glassfish-jstl"));
        }
        lf.addAll(this.getLibs(sdkRoot, "impl"));
        lf.addAll(this.getLibs(sdkRoot, "impl/jetty12"));
        return Collections.unmodifiableList(lf);
    }

    public List<URL> getSharedJspLibs() {
        return Collections.unmodifiableList(Jetty12Sdk.toURLs((List<File>)this.getSharedJspLibFiles()));
    }

    private List<File> getJetty12Jars(String subDir) {
        File path = new File(sdkRoot, JETTY12_HOME_LIB_PATH + File.separator + subDir);
        if (!path.exists()) {
            throw new IllegalArgumentException("Unable to find " + path.getAbsolutePath());
        }
        ArrayList<File> jars = new ArrayList<File>();
        for (File f : Jetty12Sdk.listFiles(path)) {
            if (!f.getName().endsWith(".jar") || f.getName().contains("-cdi-") || f.getName().contains("jetty-servlet-api-") || f.getName().contains("ee9") || f.getName().contains("jetty-jakarta-servlet-api")) continue;
            jars.add(f);
        }
        return jars;
    }

    List<File> getJetty12JspJars() {
        if (Boolean.getBoolean("appengine.use.EE10")) {
            List<File> lf = this.getJetty12Jars("ee10-apache-jsp");
            lf.addAll(this.getJetty12Jars("ee10-glassfish-jstl"));
            return lf;
        }
        List<File> lf = this.getJetty12Jars("ee8-apache-jsp");
        lf.addAll(this.getJetty12Jars("ee8-glassfish-jstl"));
        return lf;
    }

    List<File> getJetty12SharedLibFiles() {
        ArrayList<File> sharedLibs = new ArrayList<File>();
        sharedLibs.add(new File(sdkRoot, "lib/shared/jetty12/appengine-local-runtime-shared.jar"));
        File jettyHomeLib = new File(sdkRoot, JETTY12_HOME_LIB_PATH);
        sharedLibs.add(new File(jettyHomeLib, "jetty-servlet-api-4.0.6.jar"));
        sharedLibs.add(new File(jettyHomeLib, "jakarta.servlet-api-6.0.0.jar"));
        class JettyVersionFilter
        implements FileFilter {
            JettyVersionFilter() {
            }

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith("jetty-util-");
            }
        }
        File[] files = jettyHomeLib.listFiles(new JettyVersionFilter());
        sharedLibs.addAll(Arrays.asList(files));
        sharedLibs.addAll(this.getJetty12JspJars());
        return sharedLibs;
    }

    @Override
    public List<URL> getSharedLibs() {
        return Collections.unmodifiableList(Jetty12Sdk.toURLs((List<File>)this.getSharedLibFiles()));
    }

    @Override
    public List<URL> getUserJspLibs() {
        return Collections.unmodifiableList(Jetty12Sdk.toURLs(this.getJetty12JspJars()));
    }

    public List<File> getSharedLibFiles() {
        List<File> sharedLibs = this.getJetty12SharedLibFiles();
        if (isDevAppServerTest) {
            sharedLibs.addAll(Jetty12Sdk.getLibsRecursive(sdkRoot, "testing"));
        }
        return Collections.unmodifiableList(sharedLibs);
    }

    @Override
    public String getJSPCompilerClassName() {
        if (Boolean.getBoolean("appengine.use.EE10")) {
            return "com.google.appengine.tools.development.jetty.ee10.LocalJspC";
        }
        return "com.google.appengine.tools.development.jetty.LocalJspC";
    }
}

