/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib;

import com.google.appengine.repackaged.com.google.protobuf.DescriptorProtos;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.contrib.ProtoFlavor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class JavaQualifiedNames {
    private static final String[] forbiddenWords = new String[]{"InitializationErrorString", "CachedSize", "Class", "SerializedSize", "DefaultInstanceForType", "ParserForType", "AllFields", "DescriptorForType", "UnknownFields"};
    private static final Set<String> specialCases = new HashSet<String>(Arrays.asList(forbiddenWords));

    private JavaQualifiedNames() {
    }

    public static String getPackage(Descriptors.FileDescriptor fileDescriptor) {
        return JavaQualifiedNames.getPackage(fileDescriptor, ProtoFlavor.PROTO2);
    }

    public static String getOuterClassname(Descriptors.FileDescriptor fileDescriptor) {
        return JavaQualifiedNames.getFileClassName(fileDescriptor, ProtoFlavor.PROTO2);
    }

    public static String getQualifiedName(Descriptors.Descriptor msg) {
        return JavaQualifiedNames.getClassName(msg).replace('$', '.');
    }

    public static String getQualifiedName(Descriptors.ServiceDescriptor msg) {
        return JavaQualifiedNames.getClassName(msg).replace('$', '.');
    }

    public static String getQualifiedName(Descriptors.EnumDescriptor enumType) {
        return JavaQualifiedNames.getClassName(enumType).replace('$', '.');
    }

    public static String getQualifiedName(Descriptors.Descriptor msg, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(msg, flavor).replace('$', '.');
    }

    public static String getQualifiedName(Descriptors.ServiceDescriptor msg, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(msg, flavor).replace('$', '.');
    }

    public static String getQualifiedName(Descriptors.EnumDescriptor enumType, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(enumType, flavor).replace('$', '.');
    }

    public static String getClassName(Descriptors.Descriptor msg) {
        return JavaQualifiedNames.getClassName(msg, ProtoFlavor.PROTO2);
    }

    public static String getClassName(Descriptors.ServiceDescriptor service) {
        return JavaQualifiedNames.getClassName(service, ProtoFlavor.PROTO2);
    }

    public static String getClassName(Descriptors.EnumDescriptor enumType) {
        return JavaQualifiedNames.getClassName(enumType, ProtoFlavor.PROTO2);
    }

    public static String getClassName(Descriptors.Descriptor descriptor, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(JavaQualifiedNames.classNameWithoutPackage(descriptor, flavor), descriptor.getFile(), flavor, JavaQualifiedNames.multipleJavaFiles(descriptor.getFile(), flavor));
    }

    public static String getClassName(Descriptors.ServiceDescriptor descriptor, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(JavaQualifiedNames.classNameWithoutPackage(descriptor, flavor), descriptor.getFile(), flavor, JavaQualifiedNames.multipleJavaFiles(descriptor.getFile(), flavor) || JavaQualifiedNames.useJavaStubbyLibrary(descriptor.getFile(), flavor));
    }

    public static String getClassName(Descriptors.EnumDescriptor descriptor, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(JavaQualifiedNames.classNameWithoutPackage(descriptor, flavor), descriptor.getFile(), flavor, JavaQualifiedNames.multipleJavaFiles(descriptor.getFile(), flavor));
    }

    private static String getClassName(String nameWithoutPackage, Descriptors.FileDescriptor file, ProtoFlavor flavor, boolean isOwnFile) {
        StringBuilder sb = new StringBuilder();
        if (isOwnFile) {
            sb.append(JavaQualifiedNames.getPackage(file, flavor));
            if (sb.length() > 0) {
                sb.append('.');
            }
        } else {
            sb.append(JavaQualifiedNames.getClassName(file, flavor));
            if (sb.length() > 0) {
                sb.append('$');
            }
        }
        sb.append(nameWithoutPackage.replace('.', '$'));
        return sb.toString();
    }

    private static String getClassName(Descriptors.FileDescriptor file, ProtoFlavor flavor) {
        StringBuilder sb = new StringBuilder();
        sb.append(JavaQualifiedNames.getPackage(file, flavor));
        if (sb.length() > 0) {
            sb.append('.');
        }
        sb.append(JavaQualifiedNames.getFileClassName(file, flavor));
        return sb.toString();
    }

    public static String getFieldName(Descriptors.FieldDescriptor field, boolean capitalizeFirstLetter) {
        String javaName;
        String fieldName = field.getName();
        if (JavaQualifiedNames.fieldConflict(field)) {
            fieldName = fieldName + field.getNumber();
        }
        if (specialCases.contains(javaName = JavaQualifiedNames.underscoresToCamelCase(fieldName, capitalizeFirstLetter))) {
            return javaName + '_';
        }
        return javaName;
    }

    private static boolean fieldConflict(Descriptors.FieldDescriptor field) {
        Descriptors.FieldDescriptor conflictField;
        Descriptors.Descriptor message = field.getContainingType();
        return field.isRepeated() ? (conflictField = message.findFieldByName(field.getName() + "_count")) != null && !conflictField.isRepeated() : field.getName().endsWith("_count") && (conflictField = message.findFieldByName(field.getName().substring(0, field.getName().length() - "_count".length()))) != null && conflictField.isRepeated();
    }

    public static String underscoresToCamelCase(String input, boolean capitalizeNextLetter) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                if (capitalizeNextLetter) {
                    result.append((char)(ch + -32));
                } else {
                    result.append(ch);
                }
                capitalizeNextLetter = false;
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                if (i == 0 && !capitalizeNextLetter) {
                    result.append((char)(ch + 32));
                } else {
                    result.append(ch);
                }
                capitalizeNextLetter = false;
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                result.append(ch);
                capitalizeNextLetter = true;
                continue;
            }
            capitalizeNextLetter = true;
        }
        return result.toString();
    }

    public static String getPackage(Descriptors.FileDescriptor file, ProtoFlavor flavor) {
        return JavaQualifiedNames.getPackage(file.toProto(), flavor);
    }

    public static String getPackage(DescriptorProtos.FileDescriptorProto file, ProtoFlavor flavor) {
        DescriptorProtos.FileOptions fileOptions = file.getOptions();
        StringBuilder sb = new StringBuilder();
        if (fileOptions.hasJavaPackage()) {
            sb.append(fileOptions.getJavaPackage());
        } else {
            sb.append("com.google.protos");
            if (!file.getPackage().isEmpty()) {
                sb.append('.').append(file.getPackage());
            }
        }
        int javaApiVersion = fileOptions.getJavaApiVersion();
        if (javaApiVersion == 1 && flavor != ProtoFlavor.PROTO1) {
            if (fileOptions.hasJavaAltApiPackage()) {
                return fileOptions.getJavaAltApiPackage();
            }
            sb.append(".proto2api");
        } else if (javaApiVersion == 2 && flavor == ProtoFlavor.PROTO1) {
            if (fileOptions.hasJavaAltApiPackage()) {
                return fileOptions.getJavaAltApiPackage();
            }
            sb.append(".proto1api");
        }
        if (flavor == ProtoFlavor.PROTO2_MUTABLE && JavaQualifiedNames.multipleJavaFiles(file, flavor)) {
            return fileOptions.getJavaMultipleFilesMutablePackage();
        }
        return sb.toString();
    }

    private static String classNameWithoutPackage(Descriptors.Descriptor descriptor, ProtoFlavor flavor) {
        String name = JavaQualifiedNames.stripPackageName(descriptor.getFullName(), descriptor.getFile());
        if (flavor == ProtoFlavor.PROTO1) {
            name = name.replace('.', '_');
        }
        return name;
    }

    private static String classNameWithoutPackage(Descriptors.EnumDescriptor descriptor, ProtoFlavor flavor) {
        Descriptors.Descriptor messageDescriptor = descriptor.getContainingType();
        if (messageDescriptor == null) {
            return descriptor.getName();
        }
        return JavaQualifiedNames.classNameWithoutPackage(messageDescriptor, flavor) + '.' + descriptor.getName();
    }

    private static String classNameWithoutPackage(Descriptors.ServiceDescriptor descriptor, ProtoFlavor flavor) {
        String name = JavaQualifiedNames.stripPackageName(descriptor.getFullName(), descriptor.getFile());
        if (flavor == ProtoFlavor.PROTO1) {
            name = name.replace('.', '_');
        }
        if (descriptor.getFile().getOptions().getJavaGenericServices()) {
            return name + "_3";
        }
        return name;
    }

    private static String stripPackageName(String fullName, Descriptors.FileDescriptor file) {
        if (file.getPackage().isEmpty()) {
            return fullName;
        }
        return fullName.substring(file.getPackage().length() + 1);
    }

    private static boolean multipleJavaFiles(Descriptors.FileDescriptor fd, ProtoFlavor flavor) {
        return JavaQualifiedNames.multipleJavaFiles(fd.toProto(), flavor);
    }

    private static boolean multipleJavaFiles(DescriptorProtos.FileDescriptorProto fd, ProtoFlavor flavor) {
        DescriptorProtos.FileOptions options = fd.getOptions();
        switch (flavor) {
            case PROTO1: {
                return options.getJavaMultipleFiles() || !options.hasJavaOuterClassname();
            }
            case PROTO2: {
                return options.getJavaMultipleFiles();
            }
            case PROTO2_MUTABLE: {
                return options.getJavaMultipleFiles() && options.hasJavaMultipleFilesMutablePackage();
            }
        }
        throw new AssertionError();
    }

    private static boolean useJavaStubbyLibrary(Descriptors.FileDescriptor fd, ProtoFlavor flavor) {
        return JavaQualifiedNames.useJavaStubbyLibrary(fd.toProto(), flavor);
    }

    private static boolean useJavaStubbyLibrary(DescriptorProtos.FileDescriptorProto fd, ProtoFlavor flavor) {
        DescriptorProtos.FileOptions options = fd.getOptions();
        switch (flavor) {
            case PROTO1: {
                return false;
            }
            case PROTO2: {
                return options.getUseJavaStubbyLibrary();
            }
            case PROTO2_MUTABLE: {
                return false;
            }
        }
        throw new AssertionError();
    }

    public static String getFileClassName(Descriptors.FileDescriptor file, ProtoFlavor flavor) {
        return JavaQualifiedNames.getFileClassName(file.toProto(), flavor);
    }

    public static String getFileClassName(DescriptorProtos.FileDescriptorProto file, ProtoFlavor flavor) {
        switch (flavor) {
            case PROTO1: {
                return file.getOptions().getJavaOuterClassname();
            }
            case PROTO2: {
                return JavaQualifiedNames.getFileImmutableClassName(file);
            }
            case PROTO2_MUTABLE: {
                return "Mutable" + JavaQualifiedNames.getFileImmutableClassName(file);
            }
        }
        throw new AssertionError();
    }

    private static String getFileImmutableClassName(DescriptorProtos.FileDescriptorProto file) {
        if (file.getOptions().hasJavaOuterClassname()) {
            return file.getOptions().getJavaOuterClassname();
        }
        String className = JavaQualifiedNames.getFileDefaultImmutableClassName(file);
        if (JavaQualifiedNames.hasConflictingClassName(file, className)) {
            return className + "OuterClass";
        }
        return className;
    }

    private static String getFileDefaultImmutableClassName(DescriptorProtos.FileDescriptorProto file) {
        String name = file.getName();
        int lastSlash = name.lastIndexOf(47);
        String basename = lastSlash < 0 ? name : name.substring(lastSlash + 1);
        return JavaQualifiedNames.underscoresToCamelCase(JavaQualifiedNames.stripProto(basename), true);
    }

    private static String stripProto(String filename) {
        int lastDot = filename.lastIndexOf(46);
        if (lastDot >= 0) {
            switch (filename.substring(lastDot)) {
                case ".protodevel": 
                case ".proto": {
                    return filename.substring(0, lastDot);
                }
            }
        }
        return filename;
    }

    private static boolean hasConflictingClassName(DescriptorProtos.DescriptorProto messageDesc, String name) {
        if (name.equals(messageDesc.getName())) {
            return true;
        }
        for (DescriptorProtos.EnumDescriptorProto enumDesc : messageDesc.getEnumTypeList()) {
            if (!name.equals(enumDesc.getName())) continue;
            return true;
        }
        for (DescriptorProtos.DescriptorProto nestedMessageDesc : messageDesc.getNestedTypeList()) {
            if (!JavaQualifiedNames.hasConflictingClassName(nestedMessageDesc, name)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasConflictingClassName(DescriptorProtos.FileDescriptorProto file, String name) {
        for (DescriptorProtos.EnumDescriptorProto enumDesc : file.getEnumTypeList()) {
            if (!name.equals(enumDesc.getName())) continue;
            return true;
        }
        for (DescriptorProtos.ServiceDescriptorProto serviceDesc : file.getServiceList()) {
            if (!name.equals(serviceDesc.getName())) continue;
            return true;
        }
        for (DescriptorProtos.DescriptorProto messageDesc : file.getMessageTypeList()) {
            if (!JavaQualifiedNames.hasConflictingClassName(messageDesc, name)) continue;
            return true;
        }
        return false;
    }

    static {
        for (String word : forbiddenWords) {
            String lowerCase = word.toLowerCase(Locale.US).charAt(0) + word.substring(1);
            specialCases.add(lowerCase);
        }
    }
}

