/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.eclispe.jetty.util.compression;

import com.google.appengine.repackaged.org.eclispe.jetty.util.component.Container;
import com.google.appengine.repackaged.org.eclispe.jetty.util.compression.CompressionPool;
import com.google.appengine.repackaged.org.eclispe.jetty.util.thread.ThreadPool;
import java.util.zip.Deflater;

public class DeflaterPool
extends CompressionPool<Deflater> {
    private final int compressionLevel;
    private final boolean nowrap;

    public DeflaterPool(int capacity, int compressionLevel, boolean nowrap) {
        super(capacity);
        this.compressionLevel = compressionLevel;
        this.nowrap = nowrap;
    }

    @Override
    protected Deflater newObject() {
        return new Deflater(this.compressionLevel, this.nowrap);
    }

    @Override
    protected void end(Deflater deflater) {
        deflater.end();
    }

    @Override
    protected void reset(Deflater deflater) {
        deflater.reset();
    }

    public static DeflaterPool ensurePool(Container container) {
        DeflaterPool pool = container.getBean(DeflaterPool.class);
        if (pool != null) {
            return pool;
        }
        int capacity = -1;
        ThreadPool.SizedThreadPool threadPool = container.getBean(ThreadPool.SizedThreadPool.class);
        if (threadPool != null) {
            capacity = threadPool.getMaxThreads();
        }
        pool = new DeflaterPool(capacity, -1, true);
        container.addBean(pool, true);
        return pool;
    }
}

