/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools;

import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.FlagSpec;
import com.google.appengine.repackaged.com.google.common.flags.Flags;
import com.google.appengine.tools.util.JarSplitter;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public class JarSplitterMain {
    @FlagSpec(help="The maximum file for each output jar file.", name="max_file_size", altName="MAX_FILE_SIZE")
    public static final Flag<Integer> MAX_FILE_SIZE = Flag.value(0xA00000);
    @FlagSpec(help="The input jar file.", name="input_jar", altName="INPUT_JAR")
    public static final Flag<String> INPUT_JAR = Flag.value("input.jar");
    @FlagSpec(help="The directory where output jars will be written.", name="output_directory", altName="OUTPUT_DIRECTORY")
    public static final Flag<String> OUTPUT_DIRECTORY = Flag.value(".");
    @FlagSpec(help="The number of digits used for the output files.", name="output_digits", altName="OUTPUT_DIGITS")
    public static final Flag<Integer> OUTPUT_DIGITS = Flag.value(4);
    @FlagSpec(help="Whether or not manifests are replicated across all split jars.  If false, manifests are ignored.", name="replicate_manifests", altName="REPLICATE_MANIFESTS")
    public static final Flag<Boolean> REPLICATE_MANIFESTS = Flag.value(Boolean.FALSE.booleanValue());
    @FlagSpec(help="A set of filename suffixes that will be excluded from all jars", name="exclude_suffixes", altName="EXCLUDE_SUFFIXES")
    public static final Flag<Set<String>> EXCLUDE_SUFFIXES = Flag.stringSet(new String[0]);

    public static void main(String[] args) throws IOException {
        args = Flags.parseAndReturnLeftovers(args);
        JarSplitter splitter = new JarSplitter(new File(INPUT_JAR.get()), new File(OUTPUT_DIRECTORY.get()), MAX_FILE_SIZE.get(), REPLICATE_MANIFESTS.get(), OUTPUT_DIGITS.get(), EXCLUDE_SUFFIXES.get());
        splitter.run();
    }
}

