/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.repackaged.com.google.cron.GrocTimeSpecification;
import com.google.appengine.tools.admin.CronEntry;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;

public class CronEntryImpl
implements CronEntry {
    private final DateFormat formatter;
    private final String url;
    private final String description;
    private final String schedule;
    private final String tz;

    public CronEntryImpl(String url, String description, String schedule, String tz) {
        this.url = url;
        this.description = description;
        this.schedule = schedule;
        this.tz = tz == null ? "UTC" : tz;
        this.formatter = new SimpleDateFormat("EEE MMM dd, yyyy HH:mm z (Z)");
        this.formatter.setTimeZone(TimeZone.getTimeZone(this.tz));
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Iterator<String> getNextTimesIterator() {
        return new TimeIterator(new Date(), GrocTimeSpecification.create(this.schedule, TimeZone.getTimeZone(this.tz)));
    }

    Iterator<String> getNextTimesIterator(Date start) {
        return new TimeIterator(start, GrocTimeSpecification.create(this.schedule, TimeZone.getTimeZone(this.tz)));
    }

    @Override
    public String getSchedule() {
        return this.schedule;
    }

    @Override
    public String getTimezone() {
        return this.tz;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String toXml() {
        String result = "<cron>\n  <url>" + this.url + "</url>\n  <schedule>" + this.schedule + "</schedule>\n  <timezone>" + this.tz + "</timezone>\n";
        if (this.description != null) {
            result = result + "  <description>" + this.description + "</description>\n";
        }
        return result + "</cron>";
    }

    public class TimeIterator
    implements Iterator<String> {
        private Date lastRun;
        private GrocTimeSpecification groc;

        public TimeIterator(Date seedTime, GrocTimeSpecification groc) {
            this.lastRun = seedTime;
            this.groc = groc;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public String next() {
            this.lastRun = this.groc.getMatch(this.lastRun);
            String result = CronEntryImpl.this.formatter.format(this.lastRun);
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cron execution times cannot be removed");
        }
    }
}

