/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.util;

import com.google.appengine.tools.util.ClientCookie;
import com.google.appengine.tools.util.HttpHeaderParseException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Logger;

public class ClientCookieManager
implements Serializable {
    private static Logger logger = Logger.getLogger(ClientCookieManager.class.getName());
    private int maxCookies_;
    private int maxCookieSize_;
    private LinkedList<ClientCookie> cookies_ = new LinkedList();

    public ClientCookieManager() {
        this.maxCookies_ = 300;
        this.maxCookieSize_ = 4096;
    }

    public ClientCookieManager(int maxCookies, int maxCookieSize) {
        if (maxCookies <= 0) {
            throw new IllegalArgumentException("maxCookies <= 0");
        }
        if (maxCookieSize <= 0) {
            throw new IllegalArgumentException("maxCookieSize <= 0");
        }
        this.maxCookies_ = maxCookies;
        this.maxCookieSize_ = maxCookieSize;
    }

    public synchronized void readCookies(URLConnection conn) {
        String fieldKey;
        URL requestURL = conn.getURL();
        int n = 1;
        while ((fieldKey = conn.getHeaderFieldKey(n)) != null) {
            if (fieldKey.equalsIgnoreCase("Set-Cookie")) {
                try {
                    ListIterator<ClientCookie> values = ClientCookie.parseSetCookie(conn.getHeaderField(n), requestURL).listIterator();
                    while (values.hasNext()) {
                        ClientCookie cookie = values.next();
                        this.cookies_.remove(cookie);
                        if (cookie.getName().length() + cookie.getValue().length() > this.maxCookieSize_ || cookie.getEffectiveDomain().length() > this.maxCookieSize_ || cookie.getEffectivePath().length() > this.maxCookieSize_) continue;
                        this.cookies_.addFirst(cookie);
                        logger.fine("stored cookie: " + cookie.getName() + "=" + cookie.getValue() + "; domain = " + cookie.getEffectiveDomain() + "; path=" + cookie.getEffectivePath() + "; expires=" + cookie.getExpirationTime());
                    }
                }
                catch (HttpHeaderParseException e) {
                    logger.info(e.getMessage());
                }
            }
            ++n;
        }
        long currentTime = System.currentTimeMillis();
        ListIterator li = this.cookies_.listIterator();
        int pos = 0;
        while (li.hasNext()) {
            ClientCookie cookie = (ClientCookie)li.next();
            if (cookie.getExpirationTime() <= currentTime || pos >= this.maxCookies_) {
                logger.fine("removed cookie: " + cookie.getName());
                li.remove();
                continue;
            }
            ++pos;
        }
    }

    public synchronized void writeCookies(URLConnection conn) {
        URL requestURL = conn.getURL();
        long currentTime = System.currentTimeMillis();
        LinkedList<ClientCookie> requestCookies = new LinkedList<ClientCookie>();
        ListIterator li = this.cookies_.listIterator();
        while (li.hasNext()) {
            ClientCookie cookie = (ClientCookie)li.next();
            if (cookie.getExpirationTime() <= currentTime) {
                li.remove();
                continue;
            }
            if (!cookie.match(requestURL)) continue;
            li.remove();
            requestCookies.add(cookie);
        }
        if (!requestCookies.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Collections.sort(requestCookies);
            ListIterator cookies = requestCookies.listIterator();
            while (cookies.hasNext()) {
                ClientCookie cookie = (ClientCookie)cookies.next();
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                sb.append(cookie.encode());
                this.cookies_.addFirst(cookie);
            }
            logger.fine("sent cookie: " + sb);
            conn.setRequestProperty("Cookie", sb.toString());
        }
    }

    public Iterator<ClientCookie> getCookies() {
        return this.cookies_.listIterator();
    }
}

