/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.AbstractMutableMessage;
import com.google.appengine.repackaged.com.google.protobuf.AbstractMutableMessageLite;
import com.google.appengine.repackaged.com.google.protobuf.AbstractParser;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.FieldSet;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MutableMessage;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSet;
import com.google.appengine.repackaged.com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class MutableMapEntry<K, V>
extends AbstractMutableMessage {
    private static final int KEY_FIELD_NUMBER = 1;
    private static final int VALUE_FIELD_NUMBER = 2;
    private final Metadata<K, V> metadata;
    private K key;
    private V value;

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public MutableMapEntry<K, V> setKey(K key) {
        this.key = key;
        return this;
    }

    public MutableMapEntry<K, V> setValue(V value) {
        this.value = value;
        return this;
    }

    public MutableMapEntry<K, V> clearKey() {
        this.key = this.metadata.defaultInstance.key;
        return this;
    }

    public MutableMapEntry<K, V> clearValue() {
        this.value = this.metadata.defaultInstance.value;
        return this;
    }

    private static int getFieldSize(int number, WireFormat.FieldType type, Object value) {
        return CodedOutputStream.computeTagSize(number) + FieldSet.computeElementSizeNoTag(type, value);
    }

    @Override
    public int getSerializedSize() {
        int size = 0;
        size += MutableMapEntry.getFieldSize(1, this.metadata.keyType, this.key);
        this.cachedSize = size += MutableMapEntry.getFieldSize(2, this.metadata.valueType, this.value);
        return size;
    }

    @Override
    public boolean mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) {
        try {
            int tag;
            while ((tag = input.readTag()) != 0) {
                if (tag == WireFormat.makeTag(1, this.metadata.keyType.getWireType())) {
                    this.key = MutableMapEntry.mergeField(input, extensionRegistry, this.metadata.keyType, this.key);
                    continue;
                }
                if (tag == WireFormat.makeTag(2, this.metadata.valueType.getWireType())) {
                    this.value = MutableMapEntry.mergeField(input, extensionRegistry, this.metadata.valueType, this.value);
                    continue;
                }
                if (input.skipField(tag)) continue;
                break;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static <T> T mergeField(CodedInputStream input, ExtensionRegistryLite extensionRegistry, WireFormat.FieldType type, T value) throws IOException {
        switch (type) {
            case MESSAGE: {
                MutableMessage message = (MutableMessage)value;
                input.readMessage(message, extensionRegistry);
                return (T)message;
            }
            case ENUM: {
                return (T)Integer.valueOf(input.readEnum());
            }
            case GROUP: {
                throw new IllegalArgumentException("Groups are not allowed in maps.");
            }
        }
        return (T)FieldSet.readPrimitiveFieldForMutable(input, type, true);
    }

    private static void writeField(int number, WireFormat.FieldType type, Object value, CodedOutputStream output) throws IOException {
        output.writeTag(number, type.getWireType());
        FieldSet.writeElementNoTag(output, type, value);
    }

    @Override
    public void writeToWithCachedSizes(CodedOutputStream output) throws IOException {
        MutableMapEntry.writeField(1, this.metadata.keyType, this.key, output);
        if (this.metadata.valueType == WireFormat.FieldType.MESSAGE) {
            output.writeTag(2, this.metadata.valueType.getWireType());
            output.writeMessageNoTagWithCachedSizes((MutableMessage)this.value);
        } else {
            MutableMapEntry.writeField(2, this.metadata.valueType, this.value, output);
        }
    }

    private MutableMapEntry(Descriptors.Descriptor descriptor, WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
        this.metadata = new Metadata(descriptor, this, keyType, valueType);
        this.key = defaultKey;
        this.value = defaultValue;
    }

    private MutableMapEntry(Metadata<K, V> metadata) {
        this.metadata = metadata;
        this.key = metadata.defaultInstance.key;
        this.value = metadata.valueType.getJavaType() == WireFormat.JavaType.MESSAGE ? ((MutableMessage)metadata.defaultInstance.value).newMessageForType() : metadata.defaultInstance.value;
    }

    public static <K, V> MutableMapEntry<K, V> newDefaultInstance(Descriptors.Descriptor descriptor, WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
        return new MutableMapEntry<K, V>(descriptor, keyType, defaultKey, valueType, defaultValue);
    }

    @Override
    public Parser<? extends MutableMessage> getParserForType() {
        return this.metadata.parser;
    }

    @Override
    public MutableMapEntry<K, V> newMessageForType() {
        return new MutableMapEntry<K, V>(this.metadata);
    }

    @Override
    public MutableMapEntry<K, V> clear() {
        this.key = this.metadata.defaultInstance.key;
        this.value = this.metadata.defaultInstance.value;
        return this;
    }

    @Override
    public Message immutableCopy() {
        throw new UnsupportedOperationException("immutableCopy() is not implemented for map entry messages.");
    }

    @Override
    public Descriptors.Descriptor getDescriptorForType() {
        return this.metadata.descriptor;
    }

    @Override
    public Map<Descriptors.FieldDescriptor, Object> getAllFields() {
        TreeMap<Descriptors.FieldDescriptor, Object> result = new TreeMap<Descriptors.FieldDescriptor, Object>();
        for (Descriptors.FieldDescriptor field : this.metadata.descriptor.getFields()) {
            if (!this.hasField(field)) continue;
            result.put(field, this.getField(field));
        }
        return Collections.unmodifiableMap(result);
    }

    private void checkFieldDescriptor(Descriptors.FieldDescriptor field) {
        if (field.getContainingType() != this.metadata.descriptor) {
            String string = field.getFullName();
            String string2 = this.metadata.descriptor.getFullName();
            throw new IllegalArgumentException(new StringBuilder(42 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Wrong FieldDescriptor \"").append(string).append("\" used in message \"").append(string2).toString());
        }
    }

    @Override
    public boolean hasField(Descriptors.FieldDescriptor field) {
        this.checkFieldDescriptor(field);
        return true;
    }

    @Override
    public Object getField(Descriptors.FieldDescriptor field) {
        Object result;
        this.checkFieldDescriptor(field);
        Object object = result = field.getNumber() == 1 ? this.getKey() : this.getValue();
        if (field.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
            result = field.getEnumType().findValueByNumber((Integer)result);
        }
        if (field.getType() == Descriptors.FieldDescriptor.Type.BYTES) {
            result = ByteString.copyFrom((byte[])result);
        }
        return result;
    }

    @Override
    public int getRepeatedFieldCount(Descriptors.FieldDescriptor field) {
        throw new UnsupportedOperationException("There is no repeated field in a map entry message.");
    }

    @Override
    public Object getRepeatedField(Descriptors.FieldDescriptor field, int index) {
        throw new UnsupportedOperationException("There is no repeated field in a map entry message.");
    }

    @Override
    public UnknownFieldSet getUnknownFields() {
        return UnknownFieldSet.getDefaultInstance();
    }

    @Override
    public MutableMapEntry<K, V> setField(Descriptors.FieldDescriptor field, Object value) {
        this.checkFieldDescriptor(field);
        if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
            value = ((Descriptors.EnumValueDescriptor)value).getNumber();
        }
        if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.BYTE_STRING) {
            value = ((ByteString)value).toByteArray();
        }
        if (field.getNumber() == 1) {
            this.setKey(value);
        } else {
            this.setValue(value);
        }
        return null;
    }

    @Override
    public MutableMapEntry<K, V> clearField(Descriptors.FieldDescriptor field) {
        this.checkFieldDescriptor(field);
        if (field.getNumber() == 1) {
            this.clearKey();
        } else {
            this.clearValue();
        }
        return this;
    }

    @Override
    public MutableMapEntry<K, V> setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
        throw new UnsupportedOperationException("There is no repeated field in a map entry message.");
    }

    @Override
    public MutableMapEntry<K, V> addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
        throw new UnsupportedOperationException("There is no repeated field in a map entry message.");
    }

    @Override
    public MutableMapEntry<K, V> setUnknownFields(UnknownFieldSet unknownFields) {
        return this;
    }

    @Override
    public Object getMutableField(Descriptors.FieldDescriptor field) {
        this.checkFieldDescriptor(field);
        if (field.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) {
            throw new IllegalArgumentException("getMutableField() can only be called on a message field.");
        }
        if (field.getNumber() != 2) {
            String string = String.valueOf(field.getFullName());
            throw new IllegalArgumentException(string.length() != 0 ? "Invalid map entry field: ".concat(string) : new String("Invalid map entry field: "));
        }
        return this.getValue();
    }

    @Override
    public MutableMessage newMessageForField(Descriptors.FieldDescriptor field) {
        this.checkFieldDescriptor(field);
        if (field.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) {
            throw new IllegalArgumentException("newMessageForField() can only be called on a message field.");
        }
        if (field.getNumber() != 2) {
            String string = String.valueOf(field.getFullName());
            throw new IllegalArgumentException(string.length() != 0 ? "Invalid map entry field: ".concat(string) : new String("Invalid map entry field: "));
        }
        return ((MutableMessage)this.getValue()).newMessageForType();
    }

    @Override
    public MutableMapEntry<K, V> getDefaultInstanceForType() {
        return this.metadata.defaultInstance;
    }

    private static class Metadata<K, V> {
        public final Descriptors.Descriptor descriptor;
        public final MutableMapEntry<K, V> defaultInstance;
        public final AbstractParser<MutableMapEntry<K, V>> parser;
        public final WireFormat.FieldType keyType;
        public final WireFormat.FieldType valueType;

        public Metadata(Descriptors.Descriptor descriptor, final MutableMapEntry<K, V> defaultInstance, WireFormat.FieldType keyType, WireFormat.FieldType valueType) {
            this.descriptor = descriptor;
            this.defaultInstance = defaultInstance;
            this.keyType = keyType;
            this.valueType = valueType;
            this.parser = new AbstractParser<MutableMapEntry<K, V>>(this){

                @Override
                public MutableMapEntry<K, V> parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    MutableMessage result = defaultInstance.newMessageForType();
                    if (!((AbstractMutableMessageLite)((Object)result)).mergePartialFrom(input, extensionRegistry)) {
                        throw InvalidProtocolBufferException.parseFailure().setUnfinishedMessage(result);
                    }
                    return result;
                }
            };
        }
    }
}

