/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class OptionalLib {
    private final String name;
    private final String description;
    private final Map<String, List<File>> filesByVersion;
    private final Map<String, List<URL>> urlsByVersion;
    private final List<String> versions;

    public OptionalLib(String name, String description, Map<String, List<File>> filesByVersion) {
        this.name = Preconditions.checkNotNull(name, "name cannot be null");
        this.description = Preconditions.checkNotNull(description, "description cannot be null");
        Preconditions.checkNotNull(filesByVersion, "filesByVersion cannot be null");
        this.filesByVersion = new LinkedHashMap<String, List<File>>();
        for (Map.Entry<String, List<File>> entry : filesByVersion.entrySet()) {
            this.filesByVersion.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        this.versions = Collections.unmodifiableList(new ArrayList<String>(filesByVersion.keySet()));
        this.urlsByVersion = this.buildURLsByVersion(filesByVersion);
    }

    private Map<String, List<URL>> buildURLsByVersion(Map<String, List<File>> filesByVersion) {
        LinkedHashMap<String, List<URL>> urlsByVersion = new LinkedHashMap<String, List<URL>>();
        for (Map.Entry<String, List<File>> entry : filesByVersion.entrySet()) {
            urlsByVersion.put(entry.getKey(), Collections.unmodifiableList(this.toURLs(entry.getValue())));
        }
        return urlsByVersion;
    }

    private List<URL> toURLs(List<File> value) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File f : value) {
            try {
                urls.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return urls;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public List<File> getFilesForVersion(String version) {
        return this.filesByVersion.get(version);
    }

    public List<URL> getURLsForVersion(String version) {
        return this.urlsByVersion.get(version);
    }
}

